/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile;

import java.util.List;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.utils.ray.RayTrace;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.weapon.projectile.AProjectile;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class RemoveOnBlockCollisionProjectile
extends AProjectile {
    private static final RayTrace rayTrace = new RayTrace().disableEntityChecks();

    public RemoveOnBlockCollisionProjectile(Location location, Vector motion) {
        this(location, motion, null);
    }

    public RemoveOnBlockCollisionProjectile(Location location, Vector motion, FakeEntity disguise) {
        super(location, motion);
        if (disguise != null) {
            this.spawnDisguise(disguise);
        }
    }

    @Override
    public boolean updatePosition() {
        Vector possibleNextLocation = this.getLocation().add(this.getMotion());
        List hits = rayTrace.cast(this.getWorld(), this.getLocation(), possibleNextLocation, this.getNormalizedMotion());
        if (hits != null) {
            RayTraceResult firstHit = (RayTraceResult)hits.get(0);
            this.setRawLocation(firstHit.getHitLocation());
            this.onCollide(firstHit);
            return true;
        }
        this.setRawLocation(possibleNextLocation);
        this.addDistanceTravelled(this.getMotionLength());
        return false;
    }
}

