/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.projectile.AProjectile;
import me.deecaad.weaponmechanics.weapon.projectile.ProjectileScriptManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ProjectilesRunnable
extends BukkitRunnable {
    private final LinkedList<AProjectile> projectiles = new LinkedList();
    private final LinkedBlockingQueue<AProjectile> asyncProjectiles = new LinkedBlockingQueue();
    private final List<ProjectileScriptManager> managers = new LinkedList<ProjectileScriptManager>();

    public ProjectilesRunnable(Plugin plugin) {
        this.runTaskTimer(plugin, 0L, 0L);
    }

    public void addScriptManager(@NotNull ProjectileScriptManager manager) {
        this.managers.add(manager);
    }

    public void addProjectile(@NotNull AProjectile projectile) {
        if (projectile == null) {
            throw new IllegalArgumentException("Cannot add null projectile!");
        }
        if (projectile.isDead()) {
            return;
        }
        if (Bukkit.getServer().isPrimaryThread()) {
            this.tickOnAdd(projectile);
            return;
        }
        this.asyncProjectiles.add(projectile);
    }

    public void addProjectiles(Collection<? extends AProjectile> projectiles) {
        if (Bukkit.getServer().isPrimaryThread()) {
            for (AProjectile aProjectile : projectiles) {
                if (aProjectile == null || aProjectile.isDead()) continue;
                this.tickOnAdd(aProjectile);
            }
            return;
        }
        this.asyncProjectiles.addAll(projectiles);
    }

    private void tickOnAdd(@NotNull AProjectile projectile) {
        for (ProjectileScriptManager manager : this.managers) {
            manager.attach(projectile);
        }
        try {
            if (projectile.tick()) {
                projectile.remove();
                return;
            }
        }
        catch (Exception e) {
            projectile.remove();
            WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Unhandled exception while ticking projectile! Removing projectile"});
            WeaponMechanics.debug.log(LogLevel.WARN, "Removed Projectile: " + projectile, (Throwable)e);
            return;
        }
        this.projectiles.add(projectile);
    }

    public void run() {
        if (!Bukkit.getServer().isPrimaryThread()) {
            throw new IllegalStateException("Cannot tick projectiles asynchronously!");
        }
        while (!this.asyncProjectiles.isEmpty()) {
            AProjectile asyncProjectile = (AProjectile)this.asyncProjectiles.remove();
            this.projectiles.add(asyncProjectile);
            for (ProjectileScriptManager manager : this.managers) {
                manager.attach(asyncProjectile);
            }
        }
        Iterator projectilesIterator = this.projectiles.iterator();
        while (projectilesIterator.hasNext()) {
            AProjectile projectile = (AProjectile)projectilesIterator.next();
            try {
                if (!projectile.tick()) continue;
                projectile.remove();
                projectilesIterator.remove();
            }
            catch (Exception e) {
                projectilesIterator.remove();
                WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Unhandled exception while ticking projectiles! Removing projectile"});
                WeaponMechanics.debug.log(LogLevel.WARN, "Removed Projectile: " + projectile, (Throwable)e);
            }
        }
    }
}

