/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.projectile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.projectile.ProjectileScript;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public abstract class AProjectile {
    private static int CHECK_FOR_NEW_PLAYER_RATE = 0;
    private static final double version = CompatibilityAPI.getVersion();
    private final LivingEntity shooter;
    private final World world;
    private FakeEntity disguise;
    private int lastDisguiseUpdateTick;
    private Vector lastLocation;
    private Vector location;
    private Vector motion;
    private double motionLength;
    private int aliveTicks;
    private double distanceTravelled;
    private boolean dead;
    private Map<String, String> stringTags;
    private Map<String, Integer> integerTags;
    private final List<ProjectileScript<?>> scripts;

    protected AProjectile(Location location, Vector motion) {
        this(null, location, motion);
    }

    protected AProjectile(LivingEntity shooter, Location location, Vector motion) {
        this.shooter = shooter;
        this.world = location.getWorld();
        this.location = location.toVector();
        this.lastLocation = this.location.clone();
        this.motion = motion;
        this.motionLength = motion.length();
        this.scripts = new LinkedList();
        this.onStart();
    }

    public double getGravity() {
        return 0.05;
    }

    public double getMinimumSpeed() {
        return -1.0;
    }

    public boolean isRemoveAtMinimumSpeed() {
        return false;
    }

    public double getMaximumSpeed() {
        return -1.0;
    }

    public boolean isRemoveAtMaximumSpeed() {
        return false;
    }

    public double getDrag() {
        if (this.getCurrentBlock().isLiquid()) {
            return 0.96;
        }
        if (this.world.isThundering() || this.world.hasStorm()) {
            return 0.98;
        }
        return 0.99;
    }

    public int getMaximumAliveTicks() {
        return 600;
    }

    @Nullable
    public FakeEntity getDisguise() {
        return this.disguise;
    }

    @Nullable
    public LivingEntity getShooter() {
        return this.shooter;
    }

    public World getWorld() {
        return this.world;
    }

    public Vector getLastLocation() {
        return this.lastLocation.clone();
    }

    public Vector getLocation() {
        return this.location.clone();
    }

    public Block getCurrentBlock() {
        return this.world.getBlockAt(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public void setLocation(Vector location) {
        if (location == null) {
            throw new IllegalArgumentException("Location can't be null");
        }
        this.lastLocation = this.location.clone();
        this.location = location;
    }

    public void setRawLocation(Vector location) {
        if (location == null) {
            throw new IllegalArgumentException("Location can't be null");
        }
        this.location = location;
    }

    public Vector getMotion() {
        return this.motion.clone();
    }

    public double getMotionLength() {
        return this.motionLength;
    }

    public Vector getNormalizedMotion() {
        if (this.motionLength == 0.0) {
            return this.getMotion();
        }
        return this.getMotion().divide(new Vector(this.motionLength, this.motionLength, this.motionLength));
    }

    public void setMotion(Vector motion) {
        if (motion == null) {
            throw new IllegalArgumentException("Motion can't be null");
        }
        this.motion = motion;
        this.motionLength = motion.length();
    }

    public int getAliveTicks() {
        return this.aliveTicks;
    }

    public double getDistanceTravelled() {
        return this.distanceTravelled;
    }

    public void addDistanceTravelled(double amount) {
        this.distanceTravelled += amount;
    }

    public String getTag(String key) {
        return this.stringTags == null || this.stringTags.isEmpty() ? null : this.stringTags.get(key);
    }

    public void setTag(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        if (this.stringTags == null) {
            this.stringTags = new HashMap<String, String>();
        }
        this.stringTags.put(key, value);
    }

    public int getIntTag(String key) {
        return this.integerTags == null || this.integerTags.isEmpty() ? 0 : this.integerTags.getOrDefault(key, 0);
    }

    public void setIntTag(String key, int value) {
        if (key == null) {
            throw new IllegalArgumentException("Key can't be null");
        }
        if (this.integerTags == null) {
            this.integerTags = new HashMap<String, Integer>();
        }
        this.integerTags.put(key, value);
    }

    public boolean isDead() {
        return this.dead;
    }

    public void addProjectileScript(ProjectileScript<?> script) {
        this.scripts.add(script);
    }

    public void remove() {
        if (this.dead) {
            return;
        }
        this.dead = true;
        this.updateDisguise(true);
        this.onEnd();
        if (this.disguise != null) {
            this.disguise.remove();
        }
        this.scriptEvent(ProjectileScript::onTickEnd);
    }

    public boolean tick() {
        double gravity;
        block14: {
            block13: {
                if (this.dead) {
                    return true;
                }
                this.scriptEvent(ProjectileScript::onTickStart);
                this.lastLocation = this.location.clone();
                gravity = this.getGravity();
                if (gravity != 0.0) {
                    this.motion.setY(this.motion.getY() - gravity);
                }
                this.motion.multiply(this.getDrag());
                if (this.updatePosition()) {
                    return true;
                }
                double locationY = this.location.getY();
                if (this.aliveTicks >= this.getMaximumAliveTicks()) break block13;
                int n = version < 1.16 ? -32 : this.world.getMinHeight();
                if (!(locationY < (double)n) && !(locationY > (double)this.world.getMaxHeight())) break block14;
            }
            return true;
        }
        if (gravity == 0.0 && this.motionLength < Vector.getEpsilon()) {
            if (this.motionLength != 0.0) {
                this.motionLength = 0.0;
            }
            this.updateDisguise(true);
            this.scriptEvent(ProjectileScript::onTickEnd);
            ++this.aliveTicks;
            return false;
        }
        this.motionLength = this.motion.length();
        double minimumSpeed = this.getMinimumSpeed();
        double maximumSpeed = this.getMaximumSpeed();
        if (minimumSpeed != -1.0 && this.motionLength < minimumSpeed) {
            if (this.isRemoveAtMinimumSpeed()) {
                return true;
            }
            this.setMotion(this.getNormalizedMotion().multiply(this.getMinimumSpeed()));
        } else if (maximumSpeed != -1.0 && this.motionLength > maximumSpeed) {
            if (this.isRemoveAtMaximumSpeed()) {
                return true;
            }
            this.setMotion(this.getNormalizedMotion().multiply(this.getMaximumSpeed()));
        }
        this.updateDisguise(false);
        this.scriptEvent(ProjectileScript::onTickEnd);
        ++this.aliveTicks;
        return false;
    }

    public void spawnDisguise(FakeEntity disguise) {
        if (disguise == null || this.disguise != null) {
            return;
        }
        if (CHECK_FOR_NEW_PLAYER_RATE == 0) {
            CHECK_FOR_NEW_PLAYER_RATE = WeaponMechanics.getBasicConfigurations().getInt("Check_For_New_Player_Rate", 50);
        }
        this.disguise = disguise;
        if (this.getGravity() == 0.0) {
            this.disguise.setGravity(false);
        }
        this.disguise.show();
        this.disguise.setMotion(this.motion);
    }

    protected void updateDisguise(boolean forceTeleport) {
        if (this.disguise == null || this.lastDisguiseUpdateTick == this.aliveTicks) {
            return;
        }
        if (this.aliveTicks % CHECK_FOR_NEW_PLAYER_RATE == 0) {
            this.disguise.show();
        }
        if (this.motionLength == 0.0) {
            this.disguise.setPosition(this.location.getX(), this.location.getY(), this.location.getZ(), this.disguise.getYaw(), this.disguise.getPitch(), forceTeleport);
        } else {
            Vector normalizedMotion = this.getNormalizedMotion();
            this.disguise.setPosition(this.location.getX(), this.location.getY(), this.location.getZ(), this.calculateYaw(normalizedMotion), this.calculatePitch(normalizedMotion), forceTeleport);
        }
        this.disguise.setMotion(this.motion);
        this.lastDisguiseUpdateTick = this.aliveTicks;
    }

    private float calculateYaw(Vector normalizedMotion) {
        if (this.motionLength == 0.0) {
            return 0.0f;
        }
        double PI_2 = Math.PI * 2;
        return (float)Math.toDegrees((Math.atan2(-normalizedMotion.getX(), normalizedMotion.getZ()) + PI_2) % PI_2);
    }

    private float calculatePitch(Vector normalizedMotion) {
        if (this.motionLength == 0.0) {
            return 0.0f;
        }
        return (float)Math.toDegrees(Math.atan(-normalizedMotion.getY() / Math.sqrt(NumberConversions.square((double)normalizedMotion.getX()) + NumberConversions.square((double)normalizedMotion.getZ()))));
    }

    public abstract boolean updatePosition();

    public void onStart() {
        this.scriptEvent(ProjectileScript::onStart);
    }

    public void onEnd() {
        this.scriptEvent(ProjectileScript::onEnd);
    }

    public void onCollide(RayTraceResult hit) {
        this.scriptEvent(proj -> proj.onCollide(hit));
    }

    protected void scriptEvent(Consumer<ProjectileScript<?>> consumer) {
        Iterator<ProjectileScript<?>> iterator = this.scripts.iterator();
        boolean removeProjectile = false;
        while (iterator.hasNext()) {
            ProjectileScript<?> script = iterator.next();
            if (script.isRemoveScript()) {
                iterator.remove();
                continue;
            }
            consumer.accept(script);
            removeProjectile |= script.isRemoveProjectile();
        }
        if (removeProjectile) {
            this.remove();
        }
    }
}

