/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.melee;

import java.util.Collections;
import java.util.List;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTrace;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.compatibility.IWeaponCompatibility;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponMeleeMissEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class MeleeHandler
implements IValidator {
    private static final IWeaponCompatibility weaponCompatibility = WeaponCompatibilityAPI.getWeaponCompatibility();
    private WeaponHandler weaponHandler;

    public MeleeHandler() {
    }

    public MeleeHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    public boolean tryUse(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity knownVictim) {
        Vector direction;
        Location eyeLocation;
        if (triggerType != TriggerType.MELEE) {
            return false;
        }
        Configuration config = WeaponMechanics.getConfigurations();
        if (!config.getBool(weaponTitle + ".Melee.Enable_Melee") && (weaponTitle = config.getString(weaponTitle + ".Melee.Melee_Attachment")) == null) {
            return false;
        }
        HandData handData = entityWrapper.getMainHandData();
        int meleeHitDelay = config.getInt(weaponTitle + ".Melee.Melee_Hit_Delay");
        if (meleeHitDelay != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastMeleeTime(), (long)meleeHitDelay)) {
            return false;
        }
        int meleeMissDelay = config.getInt(weaponTitle + ".Melee.Melee_Miss.Melee_Miss_Delay");
        if (meleeMissDelay != 0 && !NumberUtil.hasMillisPassed((long)handData.getLastMeleeMissTime(), (long)meleeMissDelay)) {
            return false;
        }
        double meleeRange = config.getDouble(weaponTitle + ".Melee.Melee_Range");
        LivingEntity shooter = entityWrapper.getEntity();
        EntityTraceResult hit = this.getHit(shooter, eyeLocation = shooter.getEyeLocation(), direction = eyeLocation.getDirection(), meleeRange, knownVictim);
        if (hit != null) {
            boolean result = this.weaponHandler.getShootHandler().shootWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, triggerType, dualWield);
            if (result) {
                this.weaponHandler.getHitHandler().handleMeleeHit(hit, shooter, direction, weaponTitle, weaponStack, slot);
            }
            return result;
        }
        boolean hasPermission = this.weaponHandler.getInfoHandler().hasPermission(shooter, weaponTitle);
        if (!hasPermission) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                String permissionMessage = WeaponMechanics.getBasicConfigurations().getString("Messages.Permissions.Use_Weapon", "<red>You do not have permission to use " + weaponTitle);
                PlaceholderMessage message = new PlaceholderMessage(StringUtil.colorAdventure((String)permissionMessage));
                Component component = message.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)weaponStack, (String)weaponTitle, (EquipmentSlot)slot));
                MechanicsCore.getPlugin().adventure.player(player).sendMessage(component);
            }
            return false;
        }
        boolean consumeOnMiss = WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Melee.Melee_Miss.Consume_On_Miss");
        Mechanics missMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Melee.Melee_Miss.Mechanics", Mechanics.class);
        WeaponMeleeMissEvent event = new WeaponMeleeMissEvent(weaponTitle, weaponStack, shooter, slot, meleeMissDelay / 50, missMechanics, consumeOnMiss);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (event.isConsume()) {
            this.weaponHandler.getShootHandler().shootWithoutTrigger(entityWrapper, weaponTitle, weaponStack, slot, triggerType, dualWield);
        }
        if (event.getMechanics() != null) {
            event.getMechanics().use(new CastData(shooter, weaponTitle, weaponStack));
        }
        if (event.getMeleeMissDelay() != 0) {
            handData.setLastMeleeMissTime(System.currentTimeMillis());
        }
        return true;
    }

    @Nullable
    private EntityTraceResult getHit(LivingEntity shooter, Location eyeLocation, Vector direction, double range, @Nullable LivingEntity knownVictim) {
        Vector eyeLocationToVector = eyeLocation.toVector();
        if (knownVictim == null) {
            if (range <= 0.0) {
                return null;
            }
            RayTrace rayTrace = new RayTrace().withEntityFilter(entity -> entity.getEntityId() == shooter.getEntityId() || entity.getPassengers().contains(shooter));
            List hits = rayTrace.cast(eyeLocation.getWorld(), eyeLocationToVector, direction, range);
            if (hits == null) {
                return null;
            }
            RayTraceResult firstHit = (RayTraceResult)hits.get(0);
            if (!(firstHit instanceof EntityTraceResult)) {
                return null;
            }
            EntityTraceResult entityHit = (EntityTraceResult)firstHit;
            if (entityHit.getHitMin() > range) {
                return null;
            }
            return entityHit;
        }
        HitBox entityBox = CompatibilityAPI.getEntityCompatibility().getHitBox((Entity)knownVictim);
        if (entityBox == null) {
            return null;
        }
        RayTraceResult rayTraceResult = entityBox.rayTrace(eyeLocationToVector, direction);
        if (rayTraceResult == null || range > 0.0 && rayTraceResult.getHitMin() > range) {
            return null;
        }
        return (EntityTraceResult)rayTraceResult;
    }

    public String getKeyword() {
        return "Melee";
    }

    public List<String> getAllowedPaths() {
        return Collections.singletonList(".Melee");
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        int meleeMissDelay;
        boolean enableMelee = data.of("Enable_Melee").getBool(false);
        String meleeAttachment = (String)data.of("Melee_Attachment").get(null);
        if (!enableMelee && meleeAttachment == null) {
            throw data.exception(null, new String[]{"You must use either 'Enable_Melee: true' or 'Melee_Attachment: <weapon>'", "You cannot use the 'Melee' key without 1 of those 2 options"});
        }
        int meleeHitDelay = data.of("Melee_Hit_Delay").assertPositive().getInt(0);
        if (meleeHitDelay != 0) {
            configuration.set(data.key + ".Melee_Hit_Delay", (Object)(meleeHitDelay * 50));
        }
        if ((meleeMissDelay = data.of("Melee_Miss.Melee_Miss_Delay").assertPositive().getInt(0)) != 0) {
            configuration.set(data.key + ".Melee_Miss.Melee_Miss_Delay", (Object)(meleeMissDelay * 50));
        }
    }
}

