/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.info;

import java.util.Arrays;
import java.util.regex.Pattern;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ItemSerializer;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.shoot.SelectiveFireState;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WeaponItemSerializer
extends ItemSerializer {
    public String getKeyword() {
        return "Weapon_Item";
    }

    @NotNull
    public ItemStack serialize(@NotNull SerializeData data) throws SerializerException {
        String defaultSelectiveFire;
        ItemStack weaponStack = super.serializeWithoutRecipe(data);
        if (weaponStack.getType().name().equals("CROSSBOW")) {
            throw data.exception("Type", new String[]{"You cannot use 'CROSSBOW' as a WeaponMechanics weapon!", "YES! We know that you want weapons to be 'held up' like a minecraft crossbow", "Purchase WMC to 'fake' the crossbow animation for other players: https://www.spigotmc.org/resources/104539/"});
        }
        String weaponTitle = data.key.split("\\.")[0];
        Pattern pattern = Pattern.compile("[A-Za-z0-9_]+");
        if (!pattern.matcher(weaponTitle).matches()) {
            throw data.exception(null, new String[]{"Weapon title must only contain letters, numbers, and underscores!", "For example, AK-47 is not allowed, but AK_47 is fine", "This is only for the weapon title (the name defined in config), NOT the display name of the weapon. The display can be whatever you want.", SerializerException.forValue((Object)weaponTitle)});
        }
        WeaponMechanics.getWeaponHandler().getInfoHandler().addWeapon(weaponTitle);
        int magazineSize = (Integer)data.config.get(weaponTitle + ".Reload.Magazine_Size", (Object)-1);
        if (magazineSize != -1) {
            CustomTag.AMMO_LEFT.setInteger(weaponStack, magazineSize);
        }
        if ((defaultSelectiveFire = data.config.getString(weaponTitle + ".Shoot.Selective_Fire.Default")) != null) {
            try {
                SelectiveFireState state = SelectiveFireState.valueOf(defaultSelectiveFire);
                CustomTag.SELECTIVE_FIRE.setInteger(weaponStack, state.ordinal());
            }
            catch (IllegalArgumentException e) {
                throw data.exception(null, new String[]{SerializerException.forValue((Object)defaultSelectiveFire), SerializerException.didYouMean((String)defaultSelectiveFire, Arrays.asList("SINGLE", "BURST", "AUTO"))});
            }
        }
        CustomTag.WEAPON_TITLE.setString(weaponStack, weaponTitle);
        weaponStack = super.serializeRecipe(data, weaponStack);
        return weaponStack;
    }
}

