/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.info;

import java.lang.reflect.Constructor;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.placeholder.PlaceholderData;
import me.deecaad.core.placeholder.PlaceholderMessage;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import me.deecaad.weaponmechanics.wrappers.MessageHelper;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class WeaponInfoDisplay
implements Serializer<WeaponInfoDisplay> {
    private static Constructor<?> packetPlayOutExperienceConstructor;
    private PlaceholderMessage actionBar;
    private PlaceholderMessage bossBar;
    private BossBar.Color barColor;
    private BossBar.Overlay barStyle;
    private boolean showAmmoInBossBarProgress;
    private boolean showAmmoInExpLevel;
    private boolean showAmmoInExpProgress;
    private PlaceholderMessage dualWieldMainActionBar;
    private PlaceholderMessage dualWieldMainBossBar;
    private PlaceholderMessage dualWieldOffActionBar;
    private PlaceholderMessage dualWieldOffBossBar;
    private PlaceholderMessage dualWieldMainHandFormat;
    private PlaceholderMessage dualWieldOffHandFormat;
    private Component dualWieldSplit;

    public WeaponInfoDisplay() {
    }

    public WeaponInfoDisplay(String actionBar, String bossBar, BossBar.Color barColor, BossBar.Overlay barStyle, boolean showAmmoInBossBarProgress, boolean showAmmoInExpLevel, boolean showAmmoInExpProgress, String dualWieldMainActionBar, String dualWieldMainBossBar, String dualWieldOffActionBar, String dualWieldOffBossBar) {
        this.actionBar = actionBar == null ? null : new PlaceholderMessage(actionBar);
        this.bossBar = bossBar == null ? null : new PlaceholderMessage(bossBar);
        this.barColor = barColor;
        this.barStyle = barStyle;
        this.showAmmoInBossBarProgress = showAmmoInBossBarProgress;
        this.showAmmoInExpLevel = showAmmoInExpLevel;
        this.showAmmoInExpProgress = showAmmoInExpProgress;
        this.dualWieldMainActionBar = dualWieldMainActionBar == null ? null : new PlaceholderMessage(dualWieldMainActionBar);
        this.dualWieldMainBossBar = dualWieldMainBossBar == null ? null : new PlaceholderMessage(dualWieldMainBossBar);
        this.dualWieldOffActionBar = dualWieldOffActionBar == null ? null : new PlaceholderMessage(dualWieldOffActionBar);
        this.dualWieldOffBossBar = dualWieldOffBossBar == null ? null : new PlaceholderMessage(dualWieldOffBossBar);
        this.dualWieldMainHandFormat = new PlaceholderMessage(StringUtil.colorAdventure((String)WeaponMechanics.getBasicConfigurations().getString("Placeholder_Symbols.Dual_Wield.Main_Hand", "<gold><ammo_left><gray>\u00bb<gold><reload> <gold><firearm-state><weapon-title>")));
        this.dualWieldOffHandFormat = new PlaceholderMessage(StringUtil.colorAdventure((String)WeaponMechanics.getBasicConfigurations().getString("Placeholder_Symbols.Dual_Wield.Off_Hand", "<gold><weapon_title><firearm_state> <gold><reload><gray>\u00ab<gold><ammo-left>")));
        this.dualWieldSplit = MechanicsCore.getPlugin().message.deserialize((Object)StringUtil.colorAdventure((String)WeaponMechanics.getBasicConfigurations().getString("Placeholder_Symbols.Dual_Wield.Split", " <gray>|</gray> ")));
    }

    public void send(PlayerWrapper playerWrapper, EquipmentSlot slot) {
        this.send(playerWrapper, slot, null, null);
    }

    public void send(PlayerWrapper playerWrapper, EquipmentSlot slot, ItemStack knownNewMainStack, ItemStack knownNewOffStack) {
        Audience audience;
        boolean isDualWielding;
        final Player player = playerWrapper.getPlayer();
        final MessageHelper messageHelper = playerWrapper.getMessageHelper();
        String mainWeapon = playerWrapper.getMainHandData().getCurrentWeaponTitle();
        String offWeapon = playerWrapper.getOffHandData().getCurrentWeaponTitle();
        ItemStack mainStack = knownNewMainStack == null ? player.getEquipment().getItemInMainHand() : knownNewMainStack;
        ItemStack offStack = knownNewOffStack == null ? player.getEquipment().getItemInOffHand() : knownNewOffStack;
        InfoHandler infoHandler = WeaponMechanics.getWeaponHandler().getInfoHandler();
        String checkCorrectMain = infoHandler.getWeaponTitle(mainStack, false);
        if (checkCorrectMain == null) {
            mainStack = null;
            mainWeapon = null;
            playerWrapper.getMainHandData().setCurrentWeaponTitle(null);
        } else if (!checkCorrectMain.equals(mainWeapon)) {
            mainWeapon = checkCorrectMain;
        }
        String checkCorrectOff = infoHandler.getWeaponTitle(offStack, false);
        if (checkCorrectOff == null) {
            offStack = null;
            offWeapon = null;
            playerWrapper.getOffHandData().setCurrentWeaponTitle(null);
        } else if (!checkCorrectOff.equals(offWeapon)) {
            offWeapon = checkCorrectOff;
        }
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        boolean hasInvertedMainHand = player.getMainHand() == MainHand.LEFT;
        boolean mainhand = slot == EquipmentSlot.HAND;
        boolean bl = isDualWielding = mainWeapon != null && offWeapon != null && mainStack != null && offStack != null;
        if (this.actionBar != null) {
            if (isDualWielding) {
                WeaponInfoDisplay offDisplay;
                WeaponInfoDisplay mainDisplay;
                if (mainWeapon.equals(offWeapon)) {
                    mainDisplay = this;
                    offDisplay = this;
                } else {
                    mainDisplay = mainhand ? this : (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(mainWeapon + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class);
                    offDisplay = mainhand ? (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(offWeapon + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class) : this;
                }
                ComponentLike offHand = this.getDualDisplay(offDisplay, PlaceholderData.of((Player)player, (ItemStack)offStack, (String)offWeapon, (EquipmentSlot)EquipmentSlot.OFF_HAND), mainDisplay, false, hasInvertedMainHand);
                ComponentLike mainHand = this.getDualDisplay(mainDisplay, PlaceholderData.of((Player)player, (ItemStack)mainStack, (String)mainWeapon, (EquipmentSlot)EquipmentSlot.HAND), offDisplay, false, hasInvertedMainHand);
                audience = MechanicsCore.getPlugin().adventure.player(player);
                audience.sendActionBar((ComponentLike)this.buildDisplay(Component.text(), hasInvertedMainHand, mainHand, offHand));
            } else if (mainhand) {
                if (mainStack != null && mainStack.hasItemMeta()) {
                    audience = MechanicsCore.getPlugin().adventure.player(player);
                    audience.sendActionBar(this.actionBar.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)mainStack, (String)mainWeapon, (EquipmentSlot)slot)));
                }
            } else if (offStack != null && offStack.hasItemMeta()) {
                audience = MechanicsCore.getPlugin().adventure.player(player);
                audience.sendActionBar(this.actionBar.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)offStack, (String)offWeapon, (EquipmentSlot)slot)));
            }
        }
        double magazineProgress = -1.0;
        if (this.bossBar != null) {
            TextComponent.Builder builder = Component.text();
            if (isDualWielding) {
                WeaponInfoDisplay offDisplay;
                WeaponInfoDisplay mainDisplay;
                if (mainWeapon.equals(offWeapon)) {
                    mainDisplay = this;
                    offDisplay = this;
                } else {
                    mainDisplay = mainhand ? this : (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(mainWeapon + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class);
                    offDisplay = mainhand ? (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(offWeapon + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class) : this;
                }
                ComponentLike offHand = this.getDualDisplay(offDisplay, PlaceholderData.of((Player)player, (ItemStack)offStack, (String)offWeapon, (EquipmentSlot)EquipmentSlot.OFF_HAND), mainDisplay, true, hasInvertedMainHand);
                ComponentLike mainHand = this.getDualDisplay(mainDisplay, PlaceholderData.of((Player)player, (ItemStack)mainStack, (String)mainWeapon, (EquipmentSlot)EquipmentSlot.HAND), offDisplay, true, hasInvertedMainHand);
                this.buildDisplay(builder, hasInvertedMainHand, mainHand, offHand);
            } else if (mainhand) {
                if (mainStack != null && mainStack.hasItemMeta()) {
                    builder.append(this.bossBar.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)mainStack, (String)mainWeapon, (EquipmentSlot)slot)));
                }
            } else if (offStack != null && offStack.hasItemMeta()) {
                builder.append(this.bossBar.replaceAndDeserialize(PlaceholderData.of((Player)player, (ItemStack)offStack, (String)offWeapon, (EquipmentSlot)slot)));
            }
            BossBar bossBar = messageHelper.getBossBar();
            if (bossBar == null) {
                bossBar = BossBar.bossBar((ComponentLike)builder, (float)1.0f, (BossBar.Color)this.barColor, (BossBar.Overlay)this.barStyle);
                messageHelper.setBossBar(bossBar);
                audience = MechanicsCore.getPlugin().adventure.player(player);
                audience.showBossBar(bossBar);
            } else {
                Bukkit.getScheduler().cancelTask(messageHelper.getBossBarTask());
                bossBar.name((ComponentLike)builder);
                bossBar.color(this.barColor);
                bossBar.overlay(this.barStyle);
            }
            if (this.showAmmoInBossBarProgress) {
                magazineProgress = mainhand ? this.getMagazineProgress(mainStack, mainWeapon) : this.getMagazineProgress(offStack, offWeapon);
                bossBar.progress((float)magazineProgress);
            }
            messageHelper.setBossBarTask(new BukkitRunnable(){

                public void run() {
                    Audience audience = MechanicsCore.getPlugin().adventure.player(player);
                    audience.hideBossBar(messageHelper.getBossBar());
                    messageHelper.setBossBar(null);
                    messageHelper.setBossBarTask(0);
                }
            }.runTaskLater(WeaponMechanics.getPlugin(), 40L).getTaskId());
        }
        if (this.showAmmoInExpLevel || this.showAmmoInExpProgress) {
            int lastExpTask;
            String useWeapon;
            ItemStack useStack = mainhand ? mainStack : offStack;
            String string = useWeapon = mainhand ? mainWeapon : offWeapon;
            if (useStack == null || !useStack.hasItemMeta() || useWeapon == null) {
                return;
            }
            if (magazineProgress == -1.0) {
                magazineProgress = this.getMagazineProgress(useStack, useWeapon);
            }
            if ((lastExpTask = messageHelper.getExpTask()) != 0) {
                Bukkit.getServer().getScheduler().cancelTask(lastExpTask);
            }
            if (CompatibilityAPI.getVersion() < 1.15) {
                CompatibilityAPI.getCompatibility().sendPackets(player, ReflectionUtil.newInstance(packetPlayOutExperienceConstructor, (Object[])new Object[]{Float.valueOf(this.showAmmoInExpProgress ? (float)(magazineProgress != -1.0 ? magazineProgress : this.getMagazineProgress(useStack, useWeapon)) : player.getExp()), player.getTotalExperience(), this.showAmmoInExpLevel ? this.getAmmoLeft(useStack, useWeapon) : player.getLevel()}));
                messageHelper.setExpTask(new BukkitRunnable(){

                    public void run() {
                        CompatibilityAPI.getCompatibility().sendPackets(player, ReflectionUtil.newInstance(packetPlayOutExperienceConstructor, (Object[])new Object[]{Float.valueOf(player.getExp()), player.getTotalExperience(), player.getLevel()}));
                        messageHelper.setExpTask(0);
                    }
                }.runTaskLater(WeaponMechanics.getPlugin(), 40L).getTaskId());
            } else {
                player.sendExperienceChange(this.showAmmoInExpProgress ? (float)(magazineProgress != -1.0 ? magazineProgress : this.getMagazineProgress(useStack, useWeapon)) : player.getExp(), this.showAmmoInExpLevel ? this.getAmmoLeft(useStack, useWeapon) : player.getLevel());
                messageHelper.setExpTask(new BukkitRunnable(){

                    public void run() {
                        player.sendExperienceChange(player.getExp(), player.getLevel());
                        messageHelper.setExpTask(0);
                    }
                }.runTaskLater(WeaponMechanics.getPlugin(), 40L).getTaskId());
            }
        }
    }

    private ComponentLike getDualDisplay(WeaponInfoDisplay display, PlaceholderData data, WeaponInfoDisplay otherDisplay, boolean bossbar, boolean isInverted) {
        if (display == null) {
            return null;
        }
        PlaceholderMessage toApply = otherDisplay == null ? (bossbar ? display.bossBar : display.actionBar) : (isInverted ? (data.slot() == EquipmentSlot.HAND ? (bossbar ? (display.dualWieldOffBossBar != null ? display.dualWieldOffBossBar : this.dualWieldOffHandFormat) : (display.dualWieldOffActionBar != null ? display.dualWieldOffActionBar : this.dualWieldOffHandFormat)) : (bossbar ? (display.dualWieldMainBossBar != null ? display.dualWieldMainBossBar : this.dualWieldMainHandFormat) : (display.dualWieldMainActionBar != null ? display.dualWieldMainActionBar : this.dualWieldMainHandFormat))) : (data.slot() == EquipmentSlot.HAND ? (bossbar ? (display.dualWieldMainBossBar != null ? display.dualWieldMainBossBar : this.dualWieldMainHandFormat) : (display.dualWieldMainActionBar != null ? display.dualWieldMainActionBar : this.dualWieldMainHandFormat)) : (bossbar ? (display.dualWieldOffBossBar != null ? display.dualWieldOffBossBar : this.dualWieldOffHandFormat) : (display.dualWieldOffActionBar != null ? display.dualWieldOffActionBar : this.dualWieldOffHandFormat))));
        return toApply.replaceAndDeserialize(data);
    }

    private TextComponent.Builder buildDisplay(TextComponent.Builder builder, boolean hasInvertedMainHand, ComponentLike mainHand, ComponentLike offHand) {
        if (hasInvertedMainHand) {
            if (mainHand != null) {
                builder.append(mainHand);
                if (offHand != null) {
                    builder.append(this.dualWieldSplit);
                }
            }
            if (offHand != null) {
                builder.append(offHand);
            }
        } else {
            if (offHand != null) {
                builder.append(offHand);
                if (mainHand != null) {
                    builder.append(this.dualWieldSplit);
                }
            }
            if (mainHand != null) {
                builder.append(mainHand);
            }
        }
        return builder;
    }

    private int getAmmoLeft(ItemStack weaponStack, String weaponTitle) {
        return WeaponMechanics.getWeaponHandler().getReloadHandler().getAmmoLeft(weaponStack, weaponTitle);
    }

    private double getMagazineProgress(ItemStack weaponStack, String weaponTitle) {
        double progress = (double)WeaponMechanics.getWeaponHandler().getReloadHandler().getAmmoLeft(weaponStack, weaponTitle) / (double)WeaponMechanics.getConfigurations().getInt(weaponTitle + ".Reload.Magazine_Size");
        return NumberUtil.clamp((double)progress, (double)0.0, (double)1.0);
    }

    public String getKeyword() {
        return "Weapon_Info_Display";
    }

    @NotNull
    public WeaponInfoDisplay serialize(@NotNull SerializeData data) throws SerializerException {
        String actionBarMessage = data.of("Action_Bar.Message").getAdventure(null);
        String bossBarMessage = data.of("Boss_Bar.Title").getAdventure(null);
        BossBar.Color barColor = null;
        BossBar.Overlay barStyle = null;
        if (bossBarMessage != null) {
            barColor = (BossBar.Color)data.of("Boss_Bar.Bar_Color").getEnum(BossBar.Color.class, (Enum)BossBar.Color.WHITE);
            barStyle = (BossBar.Overlay)data.of("Boss_Bar.Bar_Style").getEnum(BossBar.Overlay.class, (Enum)BossBar.Overlay.NOTCHED_20);
        }
        boolean expLevel = data.of("Show_Ammo_In.Exp_Level").getBool(false);
        boolean expProgress = data.of("Show_Ammo_In.Exp_Progress").getBool(false);
        boolean bossBarProgress = data.of("Show_Ammo_In.Boss_Bar_Progress").getBool(false);
        String dualWieldMainActionBar = data.of("Action_Bar.Dual_Wield.Main_Hand").getAdventure(null);
        String dualWieldMainBossBar = data.of("Boss_Bar.Dual_Wield.Main_Hand").getAdventure(null);
        String dualWieldOffActionBar = data.of("Action_Bar.Dual_Wield.Off_Hand").getAdventure(null);
        String dualWieldOffBossBar = data.of("Boss_Bar.Dual_Wield.Off_Hand").getAdventure(null);
        if (actionBarMessage == null && bossBarMessage == null && !expLevel && !expProgress) {
            throw data.exception(null, new String[]{"Found an empty Weapon_Info_Display... Users won't be able to see any changes in their ammo!"});
        }
        if (bossBarProgress && bossBarMessage == null) {
            throw data.exception(null, new String[]{"In order for a boss bar to work properly, 'Show_Ammo_In.Boss_Bar_Progress: true' and the", "boss bar needs to be defined in the message."});
        }
        return new WeaponInfoDisplay(actionBarMessage, bossBarMessage, barColor, barStyle, bossBarProgress, expLevel, expProgress, dualWieldMainActionBar, dualWieldMainBossBar, dualWieldOffActionBar, dualWieldOffBossBar);
    }

    static {
        if (CompatibilityAPI.getVersion() < 1.15) {
            packetPlayOutExperienceConstructor = ReflectionUtil.getConstructor((Class)ReflectionUtil.getPacketClass((String)"PacketPlayOutExperience"), (Class[])new Class[]{Float.TYPE, Integer.TYPE, Integer.TYPE});
        }
    }
}

