/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.info;

import java.util.ArrayList;
import java.util.Map;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class WeaponConverter
implements Serializer<WeaponConverter> {
    private boolean type;
    private boolean name;
    private boolean lore;
    private boolean enchantments;
    private boolean cmd;

    public WeaponConverter() {
    }

    public WeaponConverter(boolean type, boolean name, boolean lore, boolean enchantments, boolean cmd) {
        this.type = type;
        this.name = name;
        this.lore = lore;
        this.enchantments = enchantments;
        this.cmd = cmd;
    }

    public boolean isMatch(ItemStack weaponStack, ItemStack other) {
        double version = CompatibilityAPI.getVersion();
        if (this.type) {
            if (weaponStack.getType() != other.getType()) {
                return false;
            }
            if (version < 1.13 && weaponStack.getData().getData() != other.getData().getData()) {
                return false;
            }
        }
        ItemMeta weaponMeta = weaponStack.getItemMeta();
        ItemMeta otherMeta = other.getItemMeta();
        if (weaponMeta == null || otherMeta == null) {
            throw new IllegalArgumentException("Tried to convert an item that was air");
        }
        if (this.name && (weaponMeta.hasDisplayName() != otherMeta.hasDisplayName() || weaponMeta.hasDisplayName() && !weaponMeta.getDisplayName().equals(otherMeta.getDisplayName()))) {
            return false;
        }
        if (this.lore && (weaponMeta.hasLore() != otherMeta.hasLore() || weaponMeta.hasLore() && !weaponMeta.getLore().equals(otherMeta.getLore()))) {
            return false;
        }
        if (this.cmd && ReflectionUtil.getMCVersion() >= 14) {
            if (weaponMeta.hasCustomModelData() != otherMeta.hasCustomModelData()) {
                return false;
            }
            if (weaponMeta.hasCustomModelData() && weaponMeta.getCustomModelData() != otherMeta.getCustomModelData()) {
                return false;
            }
        }
        if (this.enchantments) {
            return weaponMeta.hasEnchants() == otherMeta.hasEnchants() && (!weaponMeta.hasEnchants() || WeaponConverter.equals(weaponMeta.getEnchants(), otherMeta.getEnchants()));
        }
        return true;
    }

    private static boolean equals(Map<Enchantment, Integer> ench1, Map<Enchantment, Integer> ench2) {
        if (ench1 == ench2) {
            return true;
        }
        if (ench1.size() != ench2.size()) {
            return false;
        }
        ArrayList<Map.Entry<Enchantment, Integer>> list1 = new ArrayList<Map.Entry<Enchantment, Integer>>(ench1.entrySet());
        ArrayList<Map.Entry<Enchantment, Integer>> list2 = new ArrayList<Map.Entry<Enchantment, Integer>>(ench2.entrySet());
        for (int i = 0; i < list1.size(); ++i) {
            Map.Entry entry1 = (Map.Entry)list1.get(i);
            Map.Entry entry2 = (Map.Entry)list2.get(i);
            if (!((Enchantment)entry1.getKey()).equals(entry2.getKey())) {
                return false;
            }
            if (((Integer)entry1.getValue()).equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    public String getKeyword() {
        return "Weapon_Converter_Check";
    }

    @NotNull
    public WeaponConverter serialize(@NotNull SerializeData data) throws SerializerException {
        boolean type = data.of("Type").getBool(false);
        boolean name = data.of("Name").getBool(false);
        boolean lore = data.of("Lore").getBool(false);
        boolean enchantments = data.of("Enchantments").getBool(false);
        boolean cmd = data.of("Custom_Model_Data").getBool(false);
        if (!(type || name || lore || enchantments || cmd)) {
            throw data.exception(null, new String[]{"'Type', 'Name', 'Lore', 'Enchantments', 'Custom_Model_Data' are all 'false'", "One of them should be 'true' to allow weapon conversion", "If you want to remove the weapon conversion feature, remove the '" + this.getKeyword() + "' option from config"});
        }
        if (cmd && ReflectionUtil.getMCVersion() < 14) {
            throw data.exception("Custom_Model_Data", new String[]{"Custom_Model_Data is only available for 1.14+"});
        }
        WeaponMechanics.getWeaponHandler().getInfoHandler().addWeaponWithConvert(data.key.split("\\.")[0]);
        return new WeaponConverter(type, name, lore, enchantments, cmd);
    }
}

