/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.AdventureUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.info.DualWield;
import me.deecaad.weaponmechanics.weapon.info.WeaponConverter;
import me.deecaad.weaponmechanics.weapon.shoot.CustomDurability;
import me.deecaad.weaponmechanics.weapon.skin.SkinSelector;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponGenerateEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfoHandler
implements IValidator {
    private final Set<String> weaponList = new LinkedHashSet<String>();
    private final List<String> sortedWeaponList = new ArrayList<String>();
    private final Set<String> weaponsWithConvert = new LinkedHashSet<String>();
    private WeaponHandler weaponHandler;

    public InfoHandler() {
    }

    public InfoHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @NotNull
    public String getWeaponTitle(String weapon) {
        ArrayList<String> startsWith = new ArrayList<String>();
        for (String title : this.weaponList) {
            if (!title.toLowerCase(Locale.ROOT).startsWith(weapon.toLowerCase(Locale.ROOT))) continue;
            startsWith.add(title);
        }
        return StringUtil.didYouMean((String)weapon, startsWith.isEmpty() ? this.weaponList : startsWith);
    }

    public boolean hasPermission(LivingEntity player, String weaponTitle) {
        return player.hasPermission("weaponmechanics.use.*") || player.hasPermission("weaponmechanics.use." + weaponTitle);
    }

    public void addWeapon(String weaponTitle) {
        this.weaponList.add(weaponTitle);
        if (!this.sortedWeaponList.contains(weaponTitle)) {
            this.sortedWeaponList.add(weaponTitle);
            Collections.sort(this.sortedWeaponList);
        }
    }

    public boolean hasWeapon(String weaponTitle) {
        return this.weaponList.contains(weaponTitle);
    }

    public List<String> getSortedWeaponList() {
        return new ArrayList<String>(this.sortedWeaponList);
    }

    public void addWeaponWithConvert(String weaponTitle) {
        this.weaponsWithConvert.add(weaponTitle);
    }

    @Nullable
    public String getWeaponTitle(ItemStack weaponStack, boolean autoConvert) {
        if (weaponStack == null || weaponStack.getType() == Material.AIR) {
            return null;
        }
        String weaponTitle = CustomTag.WEAPON_TITLE.getString(weaponStack);
        if (weaponTitle != null) {
            return weaponTitle;
        }
        return autoConvert ? this.tryConvertingToWeapon(weaponStack) : null;
    }

    @Nullable
    public String tryConvertingToWeapon(ItemStack possibleWeaponStack) {
        if (this.weaponsWithConvert.isEmpty()) {
            return null;
        }
        for (String weaponWithConvert : this.weaponsWithConvert) {
            ItemStack weaponStack = ((ItemStack)WeaponMechanics.getConfigurations().getObject(weaponWithConvert + ".Info.Weapon_Item", ItemStack.class)).clone();
            WeaponConverter weaponConverter = (WeaponConverter)WeaponMechanics.getConfigurations().getObject(weaponWithConvert + ".Info.Weapon_Converter_Check", WeaponConverter.class);
            if (!weaponConverter.isMatch(weaponStack, possibleWeaponStack)) continue;
            possibleWeaponStack.setType(weaponStack.getType());
            possibleWeaponStack.setItemMeta(weaponStack.getItemMeta());
            return weaponWithConvert;
        }
        return null;
    }

    public ItemStack generateWeapon(String weaponTitle, int amount) {
        ItemStack weaponStack = (ItemStack)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Item", ItemStack.class);
        if (weaponStack == null) {
            return null;
        }
        weaponStack = weaponStack.clone();
        weaponStack.setAmount(amount);
        AdventureUtil.updatePlaceholders(null, (ItemStack)weaponStack);
        SkinSelector skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class);
        if (skins != null) {
            skins.getDefaultSkin().apply(weaponStack);
        }
        return weaponStack;
    }

    public boolean giveOrDropWeapon(String weaponTitle, LivingEntity entity, int amount) {
        return this.giveOrDropWeapon(weaponTitle, entity, amount, Collections.emptyMap());
    }

    public boolean giveOrDropWeapon(String weaponTitle, LivingEntity entity, int amount, Map<String, Object> data) {
        EntityEquipment equipment;
        SkinSelector skins;
        Player player;
        CustomDurability customDurability;
        if (weaponTitle == null || entity == null || amount < 1 || data == null) {
            throw new IllegalArgumentException("Bad args: " + weaponTitle + ", " + entity + ", " + amount + ", " + data);
        }
        ItemStack weaponStack = (ItemStack)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Item", ItemStack.class);
        if (weaponStack == null) {
            return false;
        }
        weaponStack = weaponStack.clone();
        weaponStack.setAmount(amount);
        int ammo = (Integer)data.getOrDefault("ammo", -1);
        int firemode = (Integer)data.getOrDefault("firemode", -1);
        boolean skipMainhand = (Integer)data.getOrDefault("skipMainhand", 0) == 1;
        int slot = (Integer)data.getOrDefault("slot", -1);
        int durability = (Integer)data.getOrDefault("durability", -1);
        int maxDurability = (Integer)data.getOrDefault("maxDurability", -1);
        if (slot != -1) {
            skipMainhand = true;
        }
        if (ammo != -1) {
            CustomTag.AMMO_LEFT.setInteger(weaponStack, ammo);
        }
        if (firemode != -1) {
            CustomTag.SELECTIVE_FIRE.setInteger(weaponStack, firemode);
        }
        if ((customDurability = (CustomDurability)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class)) != null) {
            CustomTag.DURABILITY.setInteger(weaponStack, durability == -1 ? customDurability.getMaxDurability() : durability);
            CustomTag.MAX_DURABILITY.setInteger(weaponStack, maxDurability == -1 ? customDurability.getMaxDurability() : maxDurability);
        }
        Bukkit.getPluginManager().callEvent((Event)new WeaponGenerateEvent(weaponTitle, weaponStack, entity, data));
        boolean isPlayer = entity instanceof Player;
        Player player2 = player = isPlayer ? (Player)entity : null;
        if (isPlayer) {
            AdventureUtil.updatePlaceholders((Player)player, (ItemStack)weaponStack);
        }
        if ((skins = (SkinSelector)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Skin", SkinSelector.class)) != null) {
            skins.getDefaultSkin().apply(weaponStack);
        }
        if (!((equipment = entity.getEquipment()).getItemInMainHand() != null && equipment.getItemInMainHand().getType() != Material.AIR || isPlayer && skipMainhand)) {
            equipment.setItemInMainHand(weaponStack);
        } else if (isPlayer && slot != -1) {
            player.getInventory().setItem(slot, weaponStack);
        } else if (isPlayer && player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{weaponStack});
        } else {
            if (isPlayer) {
                entity.getWorld().dropItemNaturally(entity.getLocation().add(0.0, 1.0, 0.0), weaponStack);
                return false;
            }
            return false;
        }
        Mechanics weaponGetMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Get_Mechanics", Mechanics.class);
        if (weaponGetMechanics != null) {
            weaponGetMechanics.use(new CastData(entity, weaponTitle, weaponStack));
        }
        return true;
    }

    public boolean denyDualWielding(TriggerType checkCause, @Nullable Player player, @Nullable String mainWeaponTitle, @Nullable String offWeaponTitle) {
        if (mainWeaponTitle == null || offWeaponTitle == null) {
            return false;
        }
        DualWield mainDualWield = (DualWield)WeaponMechanics.getConfigurations().getObject(mainWeaponTitle + ".Info.Dual_Wield", DualWield.class);
        if (mainDualWield == null) {
            return true;
        }
        if (mainDualWield.denyDualWieldingWith(offWeaponTitle)) {
            mainDualWield.sendDeniedMessage(checkCause, player, mainWeaponTitle);
            return true;
        }
        DualWield offDualWield = (DualWield)WeaponMechanics.getConfigurations().getObject(offWeaponTitle + ".Info.Dual_Wield", DualWield.class);
        if (offDualWield == null) {
            return true;
        }
        if (offDualWield.denyDualWieldingWith(mainWeaponTitle)) {
            offDualWield.sendDeniedMessage(checkCause, player, offWeaponTitle);
            return true;
        }
        return false;
    }

    private static int[] mapToCharTable(String str) {
        int[] table = new int["abcdefghijklmnopqrstuvwxyz".length()];
        for (int i = 0; i < str.length(); ++i) {
            try {
                int n = Character.toLowerCase(str.charAt(i)) - 97;
                table[n] = table[n] + 1;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return table;
    }

    public String getKeyword() {
        return "Info";
    }

    public List<String> getAllowedPaths() {
        return Collections.singletonList(".Info");
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        int weaponEquipDelay = data.of("Weapon_Equip_Delay").assertPositive().getInt(0);
        if (weaponEquipDelay != 0) {
            configuration.set(data.key + ".Weapon_Equip_Delay", (Object)(weaponEquipDelay * 50));
        }
    }
}

