/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.info;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.trigger.Trigger;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DualWield
implements Serializer<DualWield> {
    private boolean whitelist;
    private Set<String> weapons;
    private Mechanics mechanics;

    public DualWield() {
    }

    public DualWield(boolean whitelist, Set<String> weapons, Mechanics mechanics) {
        this.whitelist = whitelist;
        this.weapons = weapons;
        this.mechanics = mechanics;
    }

    public boolean denyDualWieldingWith(String weaponTitle) {
        if (!this.whitelist) {
            return this.weapons.contains(weaponTitle.toLowerCase(Locale.ROOT));
        }
        return !this.weapons.contains(weaponTitle.toLowerCase(Locale.ROOT));
    }

    public void sendDeniedMessage(TriggerType checkCause, @Nullable Player player, String weaponTitle) {
        if (player != null) {
            Configuration config = WeaponMechanics.getConfigurations();
            for (String type : new String[]{".Shoot", ".Reload", ".Scope"}) {
                Trigger trigger = (Trigger)config.getObject(weaponTitle + type + ".Trigger", Trigger.class);
                if (trigger == null || trigger.getMainhand() != checkCause && trigger.getOffhand() != checkCause) continue;
                if (this.mechanics == null) break;
                this.mechanics.use(new CastData((LivingEntity)player, weaponTitle, null));
                break;
            }
        }
    }

    public String getKeyword() {
        return "Dual_Wield";
    }

    @NotNull
    public DualWield serialize(@NotNull SerializeData data) throws SerializerException {
        List weaponsList = data.ofList("Weapons").addArgument(String.class, true, true).assertExists().assertList().get();
        HashSet<String> weapons = new HashSet<String>();
        weaponsList.forEach(weaponTitle -> weapons.add(weaponTitle[0].toLowerCase(Locale.ROOT)));
        boolean whitelist = data.of("Whitelist").getBool(false);
        Mechanics mechanics = (Mechanics)data.of("Mechanics_On_Deny").serialize(Mechanics.class);
        return new DualWield(whitelist, weapons, mechanics);
    }
}

