/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.firearm;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmState;
import me.deecaad.weaponmechanics.weapon.firearm.FirearmType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FirearmAction
implements Serializer<FirearmAction> {
    private FirearmType firearmType;
    private int firearmActionFrequency;
    private int openTime;
    private int closeTime;
    private Mechanics open;
    private Mechanics close;

    public FirearmAction() {
    }

    public FirearmAction(FirearmType firearmType, int firearmActionFrequency, int openTime, int closeTime, Mechanics open, Mechanics close) {
        this.firearmType = firearmType;
        this.firearmActionFrequency = firearmActionFrequency;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.open = open;
        this.close = close;
    }

    public void useMechanics(CastData castData, boolean isOpen) {
        if (isOpen) {
            if (this.open != null) {
                this.open.use(castData);
            }
            return;
        }
        if (this.close != null) {
            this.close.use(castData);
        }
    }

    public FirearmState getState(ItemStack weaponStack) {
        int state = CustomTag.FIREARM_ACTION_STATE.getInteger(weaponStack);
        return switch (state) {
            case 1 -> FirearmState.OPEN;
            case 2 -> FirearmState.CLOSE;
            default -> FirearmState.READY;
        };
    }

    public void changeState(ItemStack weaponStack, FirearmState state) {
        CustomTag.FIREARM_ACTION_STATE.setInteger(weaponStack, state.getId());
    }

    public FirearmType getFirearmType() {
        return this.firearmType;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public int getCloseTime() {
        return this.closeTime;
    }

    public Mechanics getOpen() {
        return this.open;
    }

    public Mechanics getClose() {
        return this.close;
    }

    public int getFirearmActionFrequency() {
        return this.firearmActionFrequency;
    }

    public String getKeyword() {
        return "Firearm_Action";
    }

    @NotNull
    public FirearmAction serialize(@NotNull SerializeData data) throws SerializerException {
        FirearmType type = (FirearmType)data.of("Type").assertExists().getEnum(FirearmType.class);
        int firearmActionFrequency = data.of("Firearm_Action_Frequency").assertRange(1, Integer.MAX_VALUE).getInt(1);
        int openTime = data.of("Open.Time").assertRange(1, Integer.MAX_VALUE).getInt(1);
        int closeTime = data.of("Close.Time").assertRange(1, Integer.MAX_VALUE).getInt(1);
        Mechanics open = (Mechanics)data.of("Open.Mechanics").serialize(Mechanics.class);
        Mechanics close = (Mechanics)data.of("Close.Mechanics").serialize(Mechanics.class);
        return new FirearmAction(type, firearmActionFrequency, openTime, closeTime, open, close);
    }
}

