/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.shapes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

public class SphericalExplosion
implements ExplosionShape {
    private static final Configuration config = WeaponMechanics.getBasicConfigurations();
    private final double radius;
    private final double radiusSquared;

    public SphericalExplosion(double radius) {
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    @Override
    @NotNull
    public List<Block> getBlocks(@NotNull Location origin) {
        ArrayList<Block> temp = new ArrayList<Block>();
        Location pos1 = origin.clone().add(-this.radius, -this.radius, -this.radius);
        Location pos2 = origin.clone().add(this.radius, this.radius, this.radius);
        double noiseDistance = NumberConversions.square((double)config.getDouble("Explosions.Spherical.Noise_Distance", 1.0));
        double noiseChance = config.getDouble("Explosions.Spherical.Noise_Chance", 0.1);
        for (int x = pos1.getBlockX(); x < pos2.getBlockX(); ++x) {
            for (int y = pos1.getBlockY(); y < pos2.getBlockY(); ++y) {
                for (int z = pos1.getBlockZ(); z < pos2.getBlockZ(); ++z) {
                    boolean isNearEdge;
                    Location loc = new Location(origin.getWorld(), (double)x, (double)y, (double)z);
                    double distance = loc.distanceSquared(origin);
                    if (!(distance <= this.radiusSquared)) continue;
                    boolean bl = isNearEdge = this.radiusSquared - distance < noiseDistance;
                    if (isNearEdge && RandomUtil.chance((double)noiseChance)) {
                        WeaponMechanics.debug.log(LogLevel.DEBUG, new String[]{"Skipping block (" + x + ", " + y + ", " + z + ") due to noise."});
                        continue;
                    }
                    temp.add(loc.getBlock());
                }
            }
        }
        return temp;
    }

    @Override
    @NotNull
    public List<LivingEntity> getEntities(@NotNull Location origin) {
        return origin.getWorld().getLivingEntities().stream().filter(entity -> entity.getLocation().distanceSquared(origin) < this.radiusSquared).collect(Collectors.toList());
    }

    @Override
    public double getMaxDistance() {
        return this.radius;
    }

    @Override
    public boolean isContained(@NotNull Location origin, @NotNull Location point) {
        return origin.distanceSquared(point) < this.radiusSquared;
    }

    @Override
    public double getArea() {
        return 4.1887902047863905 * this.radius * this.radius * this.radius;
    }

    public String toString() {
        return "SphericalExplosion{radius=" + this.radius + "}";
    }
}

