/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.shapes;

import java.util.Objects;
import me.deecaad.weaponmechanics.utils.Factory;
import me.deecaad.weaponmechanics.weapon.explode.shapes.CuboidExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.DefaultExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ParabolicExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.SphericalExplosion;

public final class ShapeFactory
extends Factory<ExplosionShape> {
    private static final ShapeFactory INSTANCE;

    private ShapeFactory() {
        super(ExplosionShape.class);
    }

    public static ShapeFactory getInstance() {
        return INSTANCE;
    }

    static {
        ShapeFactory shapeFactory = INSTANCE = new ShapeFactory();
        Objects.requireNonNull(shapeFactory);
        INSTANCE.set("DEFAULT", new Factory.Arguments(shapeFactory, DefaultExplosion.class, new String[]{"Yield", "Rays"}, new Class[]{Double.TYPE, Integer.TYPE}));
        ShapeFactory shapeFactory2 = INSTANCE;
        Objects.requireNonNull(shapeFactory2);
        INSTANCE.set("CUBE,CUBOID", new Factory.Arguments(shapeFactory2, CuboidExplosion.class, new String[]{"Width", "Height"}, new Class[]{Double.TYPE, Double.TYPE}));
        ShapeFactory shapeFactory3 = INSTANCE;
        Objects.requireNonNull(shapeFactory3);
        INSTANCE.set("PARABOLA,PARABOLIC", new Factory.Arguments(shapeFactory3, ParabolicExplosion.class, new String[]{"Depth", "Angle"}, new Class[]{Double.TYPE, Double.TYPE}));
        ShapeFactory shapeFactory4 = INSTANCE;
        Objects.requireNonNull(shapeFactory4);
        INSTANCE.set("SPHERE,SPHERICAL", new Factory.Arguments(shapeFactory4, SphericalExplosion.class, new String[]{"Radius"}, new Class[]{Double.TYPE}));
    }
}

