/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.shapes;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class ParabolicExplosion
implements ExplosionShape {
    private static final Configuration config = WeaponMechanics.getBasicConfigurations();
    private final double depth;
    private final double angle;

    public ParabolicExplosion(double depth) {
        this(depth, 0.5);
    }

    public ParabolicExplosion(double depth, double angle) {
        this.depth = -Math.abs(depth);
        this.angle = angle;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    @NotNull
    public List<Block> getBlocks(@NotNull Location origin) {
        ArrayList<Block> temp = new ArrayList<Block>();
        double intercept = Math.sqrt(-this.depth / this.angle);
        double noiseDistance = config.getDouble("Explosions.Spherical.Noise_Distance", 1.25);
        double noiseChance = config.getDouble("Explosions.Spherical.Noise_Chance", 0.25);
        for (double x = -intercept; x < intercept; x += 1.0) {
            for (double y = this.depth; y < -this.depth; y += 1.0) {
                for (double z = -intercept; z < intercept; z += 1.0) {
                    if (!this.test(x, y, z)) continue;
                    if (RandomUtil.chance((double)noiseChance) && this.isNearEdge(x, y, z, noiseDistance)) {
                        WeaponMechanics.debug.log(LogLevel.DEBUG, new String[]{"Skipping block (" + x + ", " + y + ", " + z + ") due to noise."});
                        continue;
                    }
                    temp.add(origin.clone().add(x, y, z).getBlock());
                }
            }
        }
        return temp;
    }

    @Override
    @NotNull
    public List<LivingEntity> getEntities(@NotNull Location origin) {
        List all = origin.getWorld().getLivingEntities();
        ArrayList<LivingEntity> temp = new ArrayList<LivingEntity>(all.size());
        for (LivingEntity entity : all) {
            if (!this.isContained(origin, entity.getLocation())) continue;
            temp.add(entity);
        }
        return temp;
    }

    @Override
    public double getMaxDistance() {
        double xOffset = Math.sqrt(-this.depth / this.angle);
        return Math.max(xOffset, -this.depth);
    }

    public boolean test(Location origin, Location loc) {
        loc.subtract(origin);
        return this.test(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public boolean isContained(@NotNull Location origin, @NotNull Location point) {
        return this.test(point.getX() - origin.getX(), point.getY() - origin.getY(), point.getZ() - origin.getZ());
    }

    @Override
    public double getArea() {
        return Math.PI * 3 * this.depth * this.depth / this.angle;
    }

    public boolean test(double x, double y, double z) {
        double temp1 = this.angle * (x * x) + this.depth - y;
        double temp2 = -this.angle * (x * x) - this.depth - y;
        double temp3 = this.angle * (z * z) + this.depth - y;
        double temp4 = -this.angle * (z * z) - this.depth - y;
        return temp1 <= 0.0 && temp2 >= 0.0 && temp3 <= 0.0 && temp4 >= 0.0;
    }

    public boolean isNearEdge(double x, double y, double z, double distance) {
        double temp1 = this.angle * (x * x) + this.depth - y;
        double temp2 = -this.angle * (x * x) - this.depth - y;
        double temp3 = this.angle * (z * z) + this.depth - y;
        double temp4 = -this.angle * (z * z) - this.depth - y;
        return temp1 > -distance || temp2 < distance || temp3 > -distance || temp4 < distance;
    }

    public String toString() {
        return "ParabolicExplosion{depth=" + this.depth + ", angle=" + this.angle + "}";
    }
}

