/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.shapes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DefaultExplosion
implements ExplosionShape {
    private static final double DECAY_RATE = 0.3;
    private static final double ABSORB_RATE = 0.3;
    private final float yield;
    private final int gridSize;
    private final int bound;

    public DefaultExplosion(double yield) {
        this(yield, 16);
    }

    public DefaultExplosion(double yield, int gridSize) {
        this.yield = (float)yield;
        this.gridSize = gridSize;
        this.bound = gridSize - 1;
    }

    @Override
    @NotNull
    public List<Block> getBlocks(@NotNull Location origin) {
        if (origin.getWorld() == null) {
            throw new IllegalArgumentException("origin is null");
        }
        if (this.yield < 0.1f) {
            return List.of();
        }
        World world = origin.getWorld();
        HashSet<Block> set = new HashSet<Block>();
        for (int k = 0; k < this.gridSize; ++k) {
            for (int i = 0; i < this.gridSize; ++i) {
                for (int j = 0; j < this.gridSize; ++j) {
                    if (k != 0 && k != this.bound && i != 0 && i != this.bound && j != 0 && j != this.bound) continue;
                    Vector vector = new Vector((double)k / (double)this.bound * 2.0 - 1.0, (double)i / (double)this.bound * 2.0 - 1.0, (double)j / (double)this.bound * 2.0 - 1.0);
                    vector.normalize();
                    double x = origin.getX();
                    double y = origin.getY();
                    double z = origin.getZ();
                    float intensity = this.yield * (0.7f + ThreadLocalRandom.current().nextFloat() * 0.6f);
                    while (intensity > 0.0f) {
                        Block block = world.getBlockAt((int)x, (int)y, (int)z);
                        if (!block.isEmpty()) {
                            float resistance = CompatibilityAPI.getBlockCompatibility().getBlastResistance(block);
                            intensity = (float)((double)intensity - (double)(resistance + 0.3f) * 0.3);
                        }
                        if (intensity > 0.0f && y < 256.0 && y >= 0.0) {
                            set.add(block);
                        }
                        x += vector.getX() * 0.3;
                        y += vector.getY() * 0.3;
                        z += vector.getZ() * 0.3;
                        intensity = (float)((double)intensity - 0.22499999999999998);
                    }
                }
            }
        }
        return new ArrayList<Block>(set);
    }

    @Override
    public List<LivingEntity> getEntities(@NotNull Location origin) {
        double damageRadius = this.yield * 2.0f;
        double damageRadiusOuter = damageRadius + 1.0;
        World world = origin.getWorld();
        if (world == null) {
            WeaponMechanics.debug.log(LogLevel.ERROR, new String[]{"Explosion in null world? Location: " + origin, "Please report error to devs"});
            return null;
        }
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (Entity entity : world.getNearbyEntities(origin, damageRadiusOuter, damageRadiusOuter, damageRadiusOuter)) {
            if (!entity.getType().isAlive()) continue;
            entities.add((LivingEntity)entity);
        }
        return entities;
    }

    @Override
    public double getMaxDistance() {
        return this.yield * 2.0f;
    }

    @Override
    public boolean isContained(@NotNull Location origin, @NotNull Location point) {
        return origin.distanceSquared(point) < (double)(this.yield * this.yield);
    }

    @Override
    public double getArea() {
        return 4.1887902047863905 * (double)this.yield * (double)this.yield * (double)this.yield;
    }

    public String toString() {
        return "DefaultExplosion{yield=" + this.yield + "}";
    }
}

