/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.shapes;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class CuboidExplosion
implements ExplosionShape {
    private static final Configuration config = WeaponMechanics.getBasicConfigurations();
    private final double width;
    private final double height;

    public CuboidExplosion(double width, double height) {
        this.width = width / 2.0;
        this.height = height / 2.0;
    }

    @Override
    @NotNull
    public List<Block> getBlocks(@NotNull Location origin) {
        ArrayList<Block> temp = new ArrayList<Block>((int)(2.0 * this.width + 2.0 * this.height) + 1);
        double noiseDistance = config.getDouble("Explosions.Spherical.Noise_Distance", 1.25);
        double noiseChance = config.getDouble("Explosions.Spherical.Noise_Chance", 0.25);
        World world = origin.getWorld();
        if (world == null) {
            WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Cuboid explosion's origin was null? Origin:", origin.toString()});
            return temp;
        }
        int blockX = origin.getBlockX();
        int blockY = origin.getBlockY();
        int blockZ = origin.getBlockZ();
        int x = (int)(-this.width);
        while ((double)x < this.width) {
            int y = (int)(-this.height);
            while ((double)y < this.height) {
                int z = (int)(-this.width);
                while ((double)z < this.width) {
                    if (this.isNearEdge(x, y, z, noiseDistance) && RandomUtil.chance((double)noiseChance)) {
                        WeaponMechanics.debug.log(LogLevel.DEBUG, new String[]{"Skipping block(" + x + ", " + y + ", " + z + ") due to noise."});
                    } else {
                        temp.add(world.getBlockAt(x + blockX, y + blockY, z + blockZ));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return temp;
    }

    @Override
    @NotNull
    public List<LivingEntity> getEntities(@NotNull Location origin) {
        double xMin = origin.getX() - this.width;
        double xMax = origin.getX() + this.width;
        double yMin = origin.getY() - this.height;
        double yMax = origin.getY() + this.height;
        double zMin = origin.getZ() - this.width;
        double zMax = origin.getZ() + this.width;
        List all = origin.getWorld().getLivingEntities();
        ArrayList<LivingEntity> temp = new ArrayList<LivingEntity>(all.size());
        for (LivingEntity entity : all) {
            double x = entity.getLocation().getX();
            double y = entity.getLocation().getY();
            double z = entity.getLocation().getZ();
            boolean in = x >= xMin && x <= xMax && y >= yMin && y <= yMax && z >= zMin && z <= zMax;
            if (!in) continue;
            temp.add(entity);
        }
        return temp;
    }

    @Override
    public double getMaxDistance() {
        return Math.sqrt(this.width * this.width + this.height * this.height);
    }

    @Override
    public double getArea() {
        return this.width * this.width * this.height;
    }

    @Override
    public boolean isContained(@NotNull Location origin, @NotNull Location point) {
        double x1 = origin.getX() - this.width;
        double y1 = origin.getY() - this.height;
        double z1 = origin.getZ() - this.width;
        double x2 = origin.getX() + this.width;
        double y2 = origin.getY() + this.height;
        double z2 = origin.getZ() + this.width;
        return point.getX() > x1 && point.getX() < x2 && point.getY() > y1 && point.getY() < y2 && point.getZ() > z1 && point.getZ() < z2;
    }

    public boolean isNearEdge(double x, double y, double z, double distance) {
        x = this.width - Math.abs(x);
        y = this.height - Math.abs(y);
        z = this.width - Math.abs(z);
        return x < distance || y < distance || z < distance;
    }

    public String toString() {
        return "CuboidExplosion{width=" + this.width + ", height=" + this.height + "}";
    }
}

