/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.regeneration;

import me.deecaad.weaponmechanics.weapon.explode.Explosion;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.BlockRegenSorter;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class LayerDistanceSorter
extends BlockRegenSorter {
    public LayerDistanceSorter(Location origin, Explosion explosion) {
        super(origin, explosion);
    }

    @Override
    public int compare(Block a, Block b) {
        int height = Integer.compare(a.getY(), b.getY());
        if (height != 0) {
            return height;
        }
        return this.calculateDistance(a, b);
    }

    private int calculateDistance(Block a, Block b) {
        int x = this.origin.getBlockX();
        int y = this.origin.getBlockY();
        int z = this.origin.getBlockZ();
        int distanceA = LayerDistanceSorter.square(a.getX() - x) + LayerDistanceSorter.square(a.getY() - y) + LayerDistanceSorter.square(a.getZ() - z);
        int distanceB = LayerDistanceSorter.square(b.getX() - x) + LayerDistanceSorter.square(b.getY() - y) + LayerDistanceSorter.square(b.getZ() - z);
        return -Integer.compare(distanceA, distanceB);
    }

    private static int square(int a) {
        return a * a;
    }
}

