/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.raytrace;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnegative;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.compatibility.block.BlockCompatibility;
import me.deecaad.core.utils.VectorUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceCollision;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceResult;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Ray {
    private static final Vector BUFFER = new Vector(2.0, 2.0, 2.0);
    private final World world;
    private final Vector origin;
    private final Vector end;
    private final double directionLength;

    public Ray(@NotNull Location origin, @NotNull Vector direction) {
        if (origin.getWorld() == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = origin.getWorld();
        this.origin = origin.toVector();
        this.end = this.origin.clone().add(direction);
        this.directionLength = direction.length();
    }

    public Ray(@NotNull World world, Vector start, Vector stop) {
        this.world = world;
        this.origin = start;
        this.end = stop;
        this.directionLength = stop.clone().subtract(start).length();
    }

    public Ray(World world, Vector origin, Vector end, double directionLength) {
        this.world = world;
        this.origin = origin;
        this.end = end;
        this.directionLength = directionLength;
    }

    public TraceResult trace(@NotNull TraceCollision collision, @Nonnegative double accuracy) {
        return this.trace(collision, accuracy, false);
    }

    public TraceResult trace(@NotNull TraceCollision collision, @Nonnegative double accuracy, boolean isShow) {
        Map availableEntities;
        BlockCompatibility factory = CompatibilityAPI.getBlockCompatibility();
        Map<Object, Object> map = availableEntities = collision.isHitEntity() ? this.getEntities(collision) : Collections.emptyMap();
        if (!collision.isHitBlock() && availableEntities.isEmpty()) {
            return new TraceResult(Collections.emptySet(), Collections.emptySet());
        }
        LinkedHashSet<Block> blocks = new LinkedHashSet<Block>();
        LinkedHashSet<Entity> entities = new LinkedHashSet<Entity>();
        double step = accuracy / this.directionLength;
        if (step > 1.0) {
            return new TraceResult(entities, blocks);
        }
        boolean collides = false;
        for (double i = step; i <= 1.0; i += step) {
            Vector point = VectorUtil.lerp((Vector)this.origin, (Vector)this.end, (double)i);
            Block block = this.world.getBlockAt(point.getBlockX(), point.getBlockY(), point.getBlockZ());
            if (collision.isHitBlock() && collision.canHit(block) && Ray.contains(factory.getHitBox(block), point)) {
                blocks.add(block);
                collides = true;
            }
            for (Map.Entry entry : availableEntities.entrySet()) {
                Entity entity = (Entity)entry.getKey();
                HitBox hitbox = (HitBox)entry.getValue();
                if (!collision.isHitEntity() || !collision.canHit(entity) || !Ray.contains(hitbox, point)) continue;
                entities.add(entity);
                collides = true;
                if (!collision.isFirst()) continue;
                break;
            }
            if (collides && collision.isFirst()) break;
            if (isShow) {
                this.displayPoint(point, collides);
            }
            collides = false;
        }
        return new TraceResult(entities, blocks);
    }

    public Map<Entity, HitBox> getEntities(TraceCollision collision) {
        Vector min = VectorUtil.min((Vector)this.origin, (Vector)this.end).subtract(BUFFER);
        Vector max = VectorUtil.max((Vector)this.origin, (Vector)this.end).add(BUFFER);
        int minChunkX = (int)Math.floor(min.getX() / 16.0);
        int minChunkZ = (int)Math.floor(min.getZ() / 16.0);
        int maxChunkX = (int)Math.ceil(max.getX() / 16.0);
        int maxChunkZ = (int)Math.ceil(max.getZ() / 16.0);
        HashMap<Entity, HitBox> temp = new HashMap<Entity, HitBox>();
        Location reuse = new Location(null, 0.0, 0.0, 0.0);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                Chunk chunk = this.world.getChunkAt(x, z);
                for (Entity entity : chunk.getEntities()) {
                    if (!Ray.contains(min, max, entity.getLocation(reuse)) || !collision.canHit(entity)) continue;
                    temp.put(entity, CompatibilityAPI.getEntityCompatibility().getHitBox(entity));
                }
            }
        }
        return temp;
    }

    private void displayPoint(final Vector point, boolean collides) {
        final Particle.DustOptions color = collides ? new Particle.DustOptions(Color.RED, 0.25f) : new Particle.DustOptions(Color.LIME, 0.25f);
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i++ >= 1000) {
                    this.cancel();
                }
                assert (Ray.this.world != null);
                Ray.this.world.spawnParticle(Particle.REDSTONE, point.getX(), point.getY(), point.getZ(), 1, 0.0, 0.0, 0.0, 0.0, (Object)color, true);
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, 2L);
    }

    private static boolean contains(Vector min, Vector max, Location loc) {
        return loc.getX() > min.getX() && loc.getX() < max.getX() && loc.getY() > min.getY() && loc.getY() < max.getY() && loc.getZ() > min.getZ() && loc.getZ() < max.getZ();
    }

    private static boolean contains(HitBox hitbox, Vector point) {
        if (hitbox == null) {
            return false;
        }
        return hitbox.collides(point);
    }
}

