/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.exposures;

import java.util.List;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.Ray;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceCollision;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceResult;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class OptimizedExposure
implements ExplosionExposure {
    @Override
    @NotNull
    public DoubleMap<LivingEntity> mapExposures(@NotNull Location origin, @NotNull ExplosionShape shape) {
        List<LivingEntity> entities = shape.getEntities(origin);
        DoubleMap temp = new DoubleMap(entities.size());
        double damageRadius = shape.getMaxDistance() * 2.0;
        World world = origin.getWorld();
        double x = origin.getX();
        double y = origin.getY();
        double z = origin.getZ();
        if (world == null) {
            WeaponMechanics.debug.log(LogLevel.ERROR, new String[]{"Explosion in null world? Location: " + origin, "Please report error to devs"});
            return temp;
        }
        Vector vector = new Vector(x, y, z);
        for (LivingEntity entity : entities) {
            Vector entityLocation = entity.getLocation().toVector();
            Vector between = entityLocation.subtract(vector);
            double distance = between.length();
            double impactRate = (damageRadius - distance) / damageRadius;
            if (impactRate > 1.0) {
                WeaponMechanics.debug.log(LogLevel.DEBUG, new String[]{"Entity " + entity + " was just outside the blast radius"});
                continue;
            }
            Vector betweenEntityAndExplosion = entityLocation.subtract(vector);
            if (distance == 0.0) continue;
            betweenEntityAndExplosion.multiply(1.0 / distance);
            double exposure = OptimizedExposure.getExposure(vector, (Entity)entity);
            double impact = impactRate * exposure;
            temp.put((Object)entity, impact);
        }
        return temp;
    }

    private static double getExposure(Vector vec3d, Entity entity) {
        HitBox box = CompatibilityAPI.getEntityCompatibility().getHitBox(entity);
        if (box == null) {
            return 0.0;
        }
        World world = entity.getWorld();
        Vector min = box.getMin();
        Vector max = box.getMax();
        int successfulTraces = 0;
        int totalTraces = 0;
        Vector reuse = new Vector();
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    OptimizedExposure.lerp(reuse, min, max, x, y, z);
                    Ray ray = new Ray(world, vec3d, reuse);
                    TraceResult trace = ray.trace(TraceCollision.BLOCK, 0.3);
                    if (trace.getBlocks().isEmpty()) {
                        ++successfulTraces;
                    }
                    ++totalTraces;
                }
            }
        }
        OptimizedExposure.lerp(reuse, min, max, 0.5, 0.5, 0.5);
        Ray ray = new Ray(world, vec3d, reuse);
        TraceResult trace = ray.trace(TraceCollision.BLOCK, 0.3);
        if (trace.getBlocks().isEmpty()) {
            successfulTraces += 4;
            totalTraces += 4;
        }
        return (double)successfulTraces / (double)totalTraces;
    }

    public static void lerp(Vector reuse, Vector min, Vector max, double x, double y, double z) {
        reuse.setX(NumberUtil.lerp((double)min.getX(), (double)max.getX(), (double)x));
        reuse.setY(NumberUtil.lerp((double)min.getY(), (double)max.getY(), (double)y));
        reuse.setZ(NumberUtil.lerp((double)min.getZ(), (double)max.getZ(), (double)z));
    }
}

