/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.exposures;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.VectorUtil;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.Ray;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceCollision;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceResult;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public interface ExplosionExposure {
    public static final double FOV = Math.toRadians(70.0);

    @NotNull
    public DoubleMap<LivingEntity> mapExposures(@NotNull Location var1, @NotNull ExplosionShape var2);

    default public boolean canSee(@NotNull Location origin, @NotNull LivingEntity entity) {
        return this.canSee(origin, entity, FOV);
    }

    default public boolean canSee(@NotNull Location originLoc, final @NotNull LivingEntity entity, double fov) {
        Vector between;
        Vector origin = originLoc.toVector();
        Vector end = entity.getEyeLocation().toVector();
        Vector direction = entity.getLocation().getDirection();
        double angle = VectorUtil.getAngleBetween((Vector)direction, (Vector)(between = origin.clone().subtract(end)));
        if (angle > fov) {
            return false;
        }
        Ray ray = new Ray(originLoc.getWorld(), origin, end, between.length());
        TraceCollision collision = new TraceCollision(TraceCollision.BLOCK_OR_ENTITY){

            @Override
            public boolean canHit(Block block) {
                String name = block.getType().name();
                if (name.endsWith("GLASS") || name.endsWith("PANE")) {
                    return false;
                }
                if (name.endsWith("LEAVES")) {
                    return false;
                }
                if (name.endsWith("FENCE") || name.endsWith("FENCE_GATE")) {
                    return false;
                }
                if (name.equals("SLIME_BLOCK")) {
                    return false;
                }
                return CompatibilityAPI.getBlockCompatibility().getHitBox(block) != null;
            }

            @Override
            public boolean canHit(Entity entity1) {
                return !entity1.equals(entity);
            }
        };
        TraceResult result = ray.trace(collision, 0.2);
        return result.isEmpty();
    }
}

