/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.exposures;

import java.util.List;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DistanceExposure
implements ExplosionExposure {
    @Override
    @NotNull
    public DoubleMap<LivingEntity> mapExposures(@NotNull Location origin, @NotNull ExplosionShape shape) {
        List<LivingEntity> entities = shape.getEntities(origin);
        DoubleMap temp = new DoubleMap(entities.size());
        double maxDistance = shape.getMaxDistance();
        for (LivingEntity entity : entities) {
            Vector vector = origin.toVector().subtract(entity.getLocation().toVector());
            double length = vector.length();
            double distanceRate = (maxDistance - length) / maxDistance;
            temp.put((Object)entity, distanceRate);
        }
        return temp;
    }
}

