/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode.exposures;

import java.util.List;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.Ray;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceCollision;
import me.deecaad.weaponmechanics.weapon.explode.raytrace.TraceResult;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class DefaultExposure
implements ExplosionExposure {
    @Override
    @NotNull
    public DoubleMap<LivingEntity> mapExposures(@NotNull Location origin, @NotNull ExplosionShape shape) {
        List<LivingEntity> entities = shape.getEntities(origin);
        DoubleMap temp = new DoubleMap(entities.size());
        double damageRadius = shape.getMaxDistance() * 2.0;
        World world = origin.getWorld();
        double x = origin.getX();
        double y = origin.getY();
        double z = origin.getZ();
        if (world == null) {
            WeaponMechanics.debug.log(LogLevel.ERROR, new String[]{"Explosion in null world? Location: " + origin, "Please report error to devs"});
            return temp;
        }
        Vector vector = new Vector(x, y, z);
        for (LivingEntity entity : entities) {
            Vector entityLocation = entity.getLocation().toVector();
            double impactRate = (damageRadius - entityLocation.distance(vector)) / damageRadius;
            if (impactRate > 1.0) {
                WeaponMechanics.debug.log(LogLevel.DEBUG, new String[]{"Entity " + entity + " was just outside the blast radius"});
                continue;
            }
            Vector betweenEntityAndExplosion = entityLocation.subtract(vector);
            double distance = betweenEntityAndExplosion.length();
            if (distance == 0.0) continue;
            betweenEntityAndExplosion.multiply(1.0 / distance);
            double exposure = DefaultExposure.getExposure(vector, (Entity)entity);
            double impact = impactRate * exposure;
            temp.put((Object)entity, impact);
        }
        return temp;
    }

    private static double getExposure(Vector vec3d, Entity entity) {
        HitBox box = CompatibilityAPI.getEntityCompatibility().getHitBox(entity);
        if (box == null) {
            return 0.0;
        }
        double width = box.getWidth();
        double height = box.getHeight();
        double depth = box.getDepth();
        double stepX = width * 2.0 + 1.0;
        double stepY = height * 2.0 + 1.0;
        double stepZ = depth * 2.0 + 1.0;
        double gridX = 1.0 / stepX;
        double gridY = 1.0 / stepY;
        double gridZ = 1.0 / stepZ;
        if (gridX < 0.0 || gridY < 0.0 || gridZ < 0.0) {
            return 0.0;
        }
        double d3 = (1.0 - Math.floor(stepX) * gridX) / 2.0;
        double d4 = (1.0 - Math.floor(stepZ) * gridZ) / 2.0;
        World world = entity.getWorld();
        int successfulTraces = 0;
        int totalTraces = 0;
        for (double x = 0.0; x <= 1.0; x += gridX) {
            for (double y = 0.0; y <= 1.0; y += gridY) {
                for (double z = 0.0; z <= 1.0; z += gridZ) {
                    double a = NumberUtil.lerp((double)box.getMinX(), (double)box.getMaxX(), (double)x);
                    double b = NumberUtil.lerp((double)box.getMinY(), (double)box.getMaxY(), (double)y);
                    double c = NumberUtil.lerp((double)box.getMinZ(), (double)box.getMaxZ(), (double)z);
                    Vector vector = new Vector(a + d3, b, c + d4).subtract(vec3d);
                    Ray ray = new Ray(vec3d.toLocation(world), vector);
                    TraceResult trace = ray.trace(TraceCollision.BLOCK, 0.3);
                    if (trace.getBlocks().isEmpty()) {
                        ++successfulTraces;
                    }
                    ++totalTraces;
                }
            }
        }
        return (double)successfulTraces / (double)totalTraces;
    }
}

