/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import java.util.Collection;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class Flashbang
implements Serializer<Flashbang> {
    private double distance;
    private double distanceSquared;
    private Mechanics mechanics;

    public Flashbang() {
    }

    public Flashbang(double distance, Mechanics mechanics) {
        this.distance = distance;
        this.distanceSquared = distance * distance;
        this.mechanics = mechanics;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
        this.distanceSquared = distance * distance;
    }

    public Mechanics getMechanics() {
        return this.mechanics;
    }

    public void setMechanics(Mechanics mechanics) {
        this.mechanics = mechanics;
    }

    public void trigger(ExplosionExposure exposure, WeaponProjectile projectile, Location origin) {
        Collection entities = origin.getWorld().getNearbyEntities(origin, this.distance, this.distance, this.distance);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity.getType() != EntityType.PLAYER || !this.canEffect(exposure, origin, livingEntity = (LivingEntity)entity)) continue;
            this.effect(projectile, livingEntity, origin);
        }
    }

    public boolean canEffect(ExplosionExposure exposure, Location origin, LivingEntity entity) {
        if (origin.getWorld() != entity.getWorld()) {
            return false;
        }
        Location eye = entity.getEyeLocation();
        double distanceSquared = origin.distanceSquared(eye);
        if (this.distanceSquared < distanceSquared) {
            return false;
        }
        return exposure.canSee(origin.add(0.0, 0.5, 0.0), entity);
    }

    public void effect(WeaponProjectile projectile, LivingEntity entity, Location origin) {
        if (this.mechanics != null) {
            CastData cast = new CastData(entity, projectile.getWeaponTitle(), projectile.getWeaponStack());
            cast.setTargetLocation(origin);
            cast.setTargetEntity(entity);
            this.mechanics.use(cast);
        }
    }

    @NotNull
    public Flashbang serialize(@NotNull SerializeData data) throws SerializerException {
        double distance = data.of("Effect_Distance").assertExists().assertPositive().getDouble();
        Mechanics mechanics = (Mechanics)data.of("Mechanics").assertExists().serialize(Mechanics.class);
        return new Flashbang(distance, mechanics);
    }
}

