/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.compatibility.worldguard.WorldGuardCompatibility;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ChanceSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.core.utils.VectorUtil;
import me.deecaad.core.utils.primitive.DoubleEntry;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.damage.BlockDamageData;
import me.deecaad.weaponmechanics.weapon.explode.AirStrike;
import me.deecaad.weaponmechanics.weapon.explode.BlockDamage;
import me.deecaad.weaponmechanics.weapon.explode.ClusterBomb;
import me.deecaad.weaponmechanics.weapon.explode.Detonation;
import me.deecaad.weaponmechanics.weapon.explode.ExplosionTrigger;
import me.deecaad.weaponmechanics.weapon.explode.Flashbang;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExposureFactory;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.BlockRegenSorter;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.LayerDistanceSorter;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.RegenerationData;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ShapeFactory;
import me.deecaad.weaponmechanics.weapon.projectile.RemoveOnBlockCollisionProjectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileExplodeEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectilePreExplodeEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Explosion
implements Serializer<Explosion> {
    private ExplosionShape shape;
    private ExplosionExposure exposure;
    private BlockDamage blockDamage;
    private RegenerationData regeneration;
    private Detonation detonation;
    private double blockChance;
    private double knockbackRate;
    private ClusterBomb cluster;
    private AirStrike airStrike;
    private Flashbang flashbang;
    private Mechanics mechanics;

    public Explosion() {
    }

    public Explosion(ExplosionShape shape, ExplosionExposure exposure, BlockDamage blockDamage, RegenerationData regeneration, Detonation detonation, double blockChance, double knockbackRate, ClusterBomb clusterBomb, AirStrike airStrike, Flashbang flashbang, Mechanics mechanics) {
        this.shape = shape;
        this.exposure = exposure;
        this.blockDamage = blockDamage;
        this.regeneration = regeneration;
        this.detonation = detonation;
        this.blockChance = blockChance;
        this.knockbackRate = knockbackRate;
        this.cluster = clusterBomb;
        this.airStrike = airStrike;
        this.flashbang = flashbang;
        this.mechanics = mechanics;
    }

    public ExplosionShape getShape() {
        return this.shape;
    }

    public ExplosionExposure getExposure() {
        return this.exposure;
    }

    public BlockDamage getBlockDamage() {
        return this.blockDamage;
    }

    public RegenerationData getRegeneration() {
        return this.regeneration;
    }

    public Detonation getDetonation() {
        return this.detonation;
    }

    public double getBlockChance() {
        return this.blockChance;
    }

    public boolean isKnockback() {
        return this.knockbackRate != 0.0;
    }

    public double getKnockbackRate() {
        return this.knockbackRate;
    }

    public ClusterBomb getCluster() {
        return this.cluster;
    }

    public AirStrike getAirStrike() {
        return this.airStrike;
    }

    public Flashbang getFlashbang() {
        return this.flashbang;
    }

    public Mechanics getMechanics() {
        return this.mechanics;
    }

    public void handleExplosion(LivingEntity cause, WeaponProjectile projectile, ExplosionTrigger trigger) {
        this.handleExplosion(cause, null, projectile, trigger);
    }

    public void handleExplosion(final LivingEntity cause, final @Nullable Location origin, final WeaponProjectile projectile, ExplosionTrigger trigger) {
        if (projectile.getIntTag("explosion-detonation") == 1) {
            return;
        }
        final Detonation currentDetonation = this.airStrike != null && this.airStrike.getDetonation() != null && projectile.getIntTag("airstrike-bomb") == 1 ? this.airStrike.getDetonation() : (this.cluster != null && this.cluster.getDetonation() != null && projectile.getIntTag("cluster-split-level") >= 1 ? this.cluster.getDetonation() : this.detonation);
        if (!currentDetonation.getTriggers().contains((Object)trigger)) {
            return;
        }
        projectile.setIntTag("explosion-detonation", 1);
        new BukkitRunnable(){

            public void run() {
                ProjectilePreExplodeEvent event = new ProjectilePreExplodeEvent(projectile, Explosion.this);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                event.getExplosion().explode(cause, origin != null ? origin : projectile.getLocation().toLocation(projectile.getWorld()), projectile);
                if (currentDetonation.isRemoveProjectileOnDetonation()) {
                    projectile.remove();
                }
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), (long)currentDetonation.getDelay());
    }

    public void explode(LivingEntity cause, Location origin, WeaponProjectile projectile) {
        WorldGuardCompatibility worldGuard = CompatibilityAPI.getWorldGuardCompatibility();
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper(cause);
        PlayerWrapper playerWrapper = cause.getType() == EntityType.PLAYER ? (PlayerWrapper)entityWrapper : null;
        if (!worldGuard.testFlag(origin, playerWrapper != null ? playerWrapper.getPlayer() : null, "weapon-explode")) {
            Object obj = worldGuard.getValue(origin, "weapon-explode-message");
            if (obj != null && !obj.toString().isEmpty()) {
                Component component = MechanicsCore.getPlugin().message.deserialize((Object)obj.toString());
                Audience audience = MechanicsCore.getPlugin().adventure.sender((CommandSender)entityWrapper.getEntity());
                audience.sendMessage(component);
            }
            return;
        }
        if (projectile != null && (projectile.isRolling() || projectile.getStickedData() != null)) {
            origin.add(0.0, 0.5, 0.0);
        }
        if (projectile != null && this.airStrike != null && projectile.getIntTag("airstrike-bomb") == 0) {
            this.airStrike.trigger(origin, cause, projectile);
            return;
        }
        List<Block> blocks = this.shape.getBlocks(origin);
        BlockRegenSorter sorter = new LayerDistanceSorter(origin, this);
        DoubleMap<LivingEntity> entities = this.exposure.mapExposures(origin, this.shape);
        Mechanics mechanics = this.mechanics;
        if (projectile != null) {
            ProjectileExplodeEvent event = new ProjectileExplodeEvent(projectile, blocks, sorter, entities, mechanics);
            Bukkit.getPluginManager().callEvent((Event)event);
            blocks = event.getBlocks();
            sorter = event.getSorter();
            entities = event.getEntities();
            mechanics = event.getMechanics();
            if (this.blockDamage != null && !blocks.isEmpty() && !WeaponMechanics.getBasicConfigurations().getBool("Disable_Entity_Explode_Event")) {
                EntityExplodeEvent entityExplodeEvent = new EntityExplodeEvent((Entity)projectile.getShooter(), origin, blocks, 5.0f);
                Bukkit.getPluginManager().callEvent((Event)entityExplodeEvent);
                if (entityExplodeEvent.isCancelled()) {
                    return;
                }
            }
        }
        ArrayList<Block> transparent = new ArrayList<Block>(blocks.size());
        ArrayList<Block> solid = new ArrayList<Block>(blocks.size());
        for (Block block : blocks) {
            if (block.getType().isSolid()) {
                solid.add(block);
                continue;
            }
            if (block.isEmpty()) continue;
            transparent.add(block);
        }
        try {
            if (sorter == null) {
                WeaponMechanics.debug.debug(new String[]{"Null sorter used while regenerating explosion... Was this intentional?"});
            } else {
                solid.sort(sorter);
            }
        }
        catch (IllegalArgumentException e) {
            WeaponMechanics.debug.log(LogLevel.ERROR, "A plugin modified the explosion block sorter with an illegal sorter! Please report this error to the developers of that plugin. Sorter: " + sorter.getClass(), (Throwable)e);
        }
        if (this.blockDamage != null) {
            int timeOffset = this.regeneration == null ? -1 : solid.size() * this.regeneration.getInterval() / this.regeneration.getMaxBlocksPerUpdate();
            this.damageBlocks(transparent, true, origin, timeOffset, playerWrapper, projectile);
            this.damageBlocks(solid, false, origin, 0, playerWrapper, projectile);
        }
        if (projectile != null && projectile.getWeaponTitle() != null) {
            WeaponMechanics.getWeaponHandler().getDamageHandler().tryUseExplosion(projectile, origin, entities);
            if (this.isKnockback()) {
                Vector originVector = origin.toVector();
                for (DoubleEntry entry : entities.entrySet()) {
                    LivingEntity entity = (LivingEntity)entry.getKey();
                    double exposure = entry.getValue();
                    Vector between = VectorUtil.setLength((Vector)entity.getLocation().toVector().subtract(originVector), (double)(exposure *= this.knockbackRate));
                    Vector motion = entity.getVelocity().add(between);
                    entity.setVelocity(motion);
                }
            }
            if (this.cluster != null) {
                this.cluster.trigger(projectile, cause, origin);
            }
        } else {
            for (DoubleEntry doubleEntry : entities.entrySet()) {
                LivingEntity entity = (LivingEntity)doubleEntry.getKey();
                double impact = doubleEntry.getValue();
                entity.sendMessage(ChatColor.RED + "You suffered " + impact * 100.0 + "% of the impact");
            }
        }
        if (this.flashbang != null) {
            this.flashbang.trigger(this.exposure, projectile, origin);
        }
        if (mechanics != null) {
            CastData cast = new CastData(cause, projectile == null ? null : projectile.getWeaponTitle(), projectile == null ? null : projectile.getWeaponStack());
            cast.setTargetLocation(origin);
            mechanics.use(cast);
        }
    }

    protected void damageBlocks(List<Block> blocks, boolean isAtOnce, Location origin, int timeOffset, PlayerWrapper playerWrapper, WeaponProjectile projectile) {
        boolean isRegenerate;
        boolean bl = isRegenerate = this.regeneration != null;
        if (isRegenerate) {
            timeOffset += this.regeneration.getTicksBeforeStart();
        }
        ArrayList<BlockDamageData.DamageData> brokenBlocks = isRegenerate ? new ArrayList<BlockDamageData.DamageData>(this.regeneration.getMaxBlocksPerUpdate()) : null;
        Location temp = new Location(null, 0.0, 0.0, 0.0);
        int blocksBroken = 0;
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            Block block = blocks.get(i);
            if (!CompatibilityAPI.getWorldGuardCompatibility().testFlag(block.getLocation(temp), null, "weapon-break-block")) continue;
            BlockState state = block.getState();
            BlockDamageData.DamageData data = this.blockDamage.damage(block, null, isRegenerate);
            if (data == null) continue;
            if (isRegenerate) {
                brokenBlocks.add(data);
                if (brokenBlocks.size() == this.regeneration.getMaxBlocksPerUpdate() || i == size - 1) {
                    int time = timeOffset + (isAtOnce ? size : i) / this.regeneration.getMaxBlocksPerUpdate() * this.regeneration.getInterval();
                    final ArrayList finalBrokenBlocks = new ArrayList(brokenBlocks);
                    new BukkitRunnable(){

                        public void run() {
                            for (BlockDamageData.DamageData block : finalBrokenBlocks) {
                                if (!block.isBroken()) continue;
                                block.regenerate();
                                block.remove();
                            }
                        }
                    }.runTaskLater(WeaponMechanics.getPlugin(), (long)time);
                    brokenBlocks.clear();
                }
            } else if (data.isBroken()) {
                data.remove();
            }
            if (!data.isBroken() || this.blockDamage.getBreakMode(state.getType()) != BlockDamage.BreakMode.BREAK) continue;
            ++blocksBroken;
            if (!RandomUtil.chance((double)this.blockChance)) continue;
            Location loc = block.getLocation().add(0.5, 0.5, 0.5);
            Vector velocity = loc.toVector().subtract(origin.toVector()).normalize();
            velocity.setY(Math.abs(velocity.getY()));
            this.spawnFallingBlock(loc, state, velocity);
        }
        if (blocksBroken != 0 && playerWrapper != null && playerWrapper.getStatsData() != null && projectile != null && projectile.getWeaponTitle() != null) {
            playerWrapper.getStatsData().add(projectile.getWeaponTitle(), WeaponStat.BLOCKS_DESTROYED, blocksBroken);
        }
    }

    protected void spawnFallingBlock(Location location, BlockState state, Vector velocity) {
        FakeEntity disguise = CompatibilityAPI.getEntityCompatibility().generateFakeEntity(location, state);
        RemoveOnBlockCollisionProjectile projectile = new RemoveOnBlockCollisionProjectile(location, velocity, disguise);
        projectile.setIntTag("explosion-falling-block", 1);
        WeaponMechanics.getProjectilesRunnable().addProjectile(projectile);
    }

    public String getKeyword() {
        return "Explosion";
    }

    public String getWikiLink() {
        return "https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/explosion";
    }

    @NotNull
    public Explosion serialize(@NotNull SerializeData data) throws SerializerException {
        ExplosionShape shape;
        ExplosionExposure exposure;
        data.of("Explosion_Type_Data.Yield").assertPositive();
        data.of("Explosion_Type_Data.Angle").assertPositive();
        data.of("Explosion_Type_Data.Height").assertPositive();
        data.of("Explosion_Type_Data.Width").assertPositive();
        data.of("Explosion_Type_Data.Radius").assertPositive();
        data.of("Explosion_Type_Data.Rays").assertPositive();
        Map typeData = ((ConfigurationSection)data.of("Explosion_Type_Data").assertExists().assertType(ConfigurationSection.class).get()).getValues(false);
        if (!typeData.containsKey("Rays")) {
            typeData.put("Rays", 16);
        }
        try {
            exposure = (ExplosionExposure)ExposureFactory.getInstance().get((String)data.of("Explosion_Exposure").get((Object)"DEFAULT"), typeData);
            shape = (ExplosionShape)ShapeFactory.getInstance().get((String)data.of("Explosion_Shape").get((Object)"DEFAULT"), typeData);
        }
        catch (SerializerException ex) {
            ex.setLocation(data.of("Explosion_Type_Data").getLocation());
            throw ex;
        }
        BlockDamage blockDamage = (BlockDamage)data.of("Block_Damage").serialize(BlockDamage.class);
        RegenerationData regeneration = (RegenerationData)data.of("Regeneration").serialize(RegenerationData.class);
        if (data.has("Block_Damage.Ticks_Before_Regenerate")) {
            throw data.exception("Block_Damage.Ticks_Before_Regenerate", new String[]{"You cannot use 'Ticks_Before_Regenerate' in Explosions", "Use the 'Explosion.Regeneration' section instead", "Wiki: https://cjcrafter.gitbook.io/weaponmechanics/weapon-modules/explosion#regeneration"});
        }
        if (!(blockDamage != null && blockDamage.canBreakBlocks() || regeneration == null)) {
            throw data.exception(null, new String[]{"Found an Explosion that defines 'Regeneration' when 'Block_Damage' cannot break blocks!", "This happens when 'Block_Damage.Break_Blocks: false' or when 'Block_Damage' was not added AND you tried to add 'Regeneration'"});
        }
        Detonation detonation = (Detonation)data.of("Detonation").assertExists().serialize(Detonation.class);
        Double blockChance = (Double)data.step(BlockDamage.class).of("Spawn_Falling_Block_Chance").serialize((Serializer)new ChanceSerializer());
        if (blockChance == null) {
            blockChance = 0.0;
        }
        double knockbackRate = data.of("Knockback_Multiplier").getDouble(1.0);
        ClusterBomb clusterBomb = (ClusterBomb)data.of("Cluster_Bomb").serialize(ClusterBomb.class);
        AirStrike airStrike = (AirStrike)data.of("Airstrike").serialize(AirStrike.class);
        Flashbang flashbang = (Flashbang)data.of("Flashbang").serialize(Flashbang.class);
        Mechanics mechanics = (Mechanics)data.of("Mechanics").serialize(Mechanics.class);
        return new Explosion(shape, exposure, blockDamage, regeneration, detonation, blockChance, knockbackRate, clusterBomb, airStrike, flashbang, mechanics);
    }
}

