/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.weapon.explode.ExplosionTrigger;
import org.jetbrains.annotations.NotNull;

public class Detonation
implements Serializer<Detonation> {
    private Set<ExplosionTrigger> triggers;
    private int delay;
    private boolean removeProjectileOnDetonation;

    public Detonation() {
    }

    public Detonation(Set<ExplosionTrigger> triggers, int delay, boolean removeProjectileOnDetonation) {
        this.triggers = triggers;
        this.delay = delay;
        this.removeProjectileOnDetonation = removeProjectileOnDetonation;
    }

    public Set<ExplosionTrigger> getTriggers() {
        return this.triggers;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRemoveProjectileOnDetonation() {
        return this.removeProjectileOnDetonation;
    }

    @NotNull
    public Detonation serialize(@NotNull SerializeData data) throws SerializerException {
        HashSet<ExplosionTrigger> triggers = new HashSet<ExplosionTrigger>(ExplosionTrigger.values().length, 1.0f);
        for (ExplosionTrigger trigger : ExplosionTrigger.values()) {
            String key = StringUtil.snakeToUpperSnake((String)trigger.name().toLowerCase(Locale.ROOT));
            boolean enable = data.of("Impact_When." + key).getBool(false);
            if (!enable) continue;
            triggers.add(trigger);
        }
        int delay = data.of("Delay_After_Impact").assertPositive().getInt(0);
        boolean removeProjectileOnDetonation = data.of("Remove_Projectile_On_Detonation").getBool(true);
        return new Detonation(triggers, delay, removeProjectileOnDetonation);
    }
}

