/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.Detonation;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Projectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ClusterBomb
implements Serializer<ClusterBomb> {
    private Projectile projectile;
    private double speed;
    private int splits;
    private int bombs;
    private Detonation detonation;
    private Mechanics mechanics;

    public ClusterBomb() {
    }

    public ClusterBomb(Projectile projectile, double speed, int splits, int bombs, Detonation detonation, Mechanics mechanics) {
        this.projectile = projectile;
        this.speed = speed;
        this.splits = splits;
        this.bombs = bombs;
        this.detonation = detonation;
        this.mechanics = mechanics;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getSplits() {
        return this.splits;
    }

    public int getBombs() {
        return this.bombs;
    }

    public Detonation getDetonation() {
        return this.detonation;
    }

    public void trigger(WeaponProjectile projectile, LivingEntity shooter, Location splitLocation) {
        int currentDepth = projectile.getIntTag("cluster-split-level");
        if (currentDepth >= this.splits) {
            return;
        }
        if (this.mechanics != null) {
            CastData cast = new CastData(shooter, projectile.getWeaponTitle(), projectile.getWeaponStack());
            cast.setTargetLocation(projectile.getLocation().toLocation(projectile.getWorld()));
            this.mechanics.use(cast);
        }
        for (int i = 0; i < this.bombs; ++i) {
            Projectile projectileHandler;
            Vector vector = RandomUtil.onUnitSphere().multiply(this.speed);
            vector.setY(Math.abs(vector.getY()));
            Projectile projectile2 = projectileHandler = this.getProjectile() != null ? this.getProjectile() : (Projectile)WeaponMechanics.getConfigurations().getObject(projectile.getWeaponTitle() + ".Projectile", Projectile.class);
            if (projectileHandler == null) continue;
            WeaponProjectile newProjectile = this.getProjectile() != null ? projectileHandler.create(shooter, splitLocation, vector, projectile.getWeaponStack(), projectile.getWeaponTitle(), projectile.getHand()) : projectile.clone(splitLocation, vector);
            newProjectile.setIntTag("cluster-split-level", currentDepth + 1);
            projectileHandler.shoot(newProjectile, splitLocation);
        }
        projectile.remove();
    }

    @NotNull
    public ClusterBomb serialize(@NotNull SerializeData data) throws SerializerException {
        int bombs = data.of("Number_Of_Bombs").assertExists().assertPositive().getInt();
        Projectile projectileSettings = (Projectile)data.of("Split_Projectile").serialize(Projectile.class);
        double speed = data.of("Projectile_Speed").assertPositive().getDouble(30.0) / 20.0;
        int splits = data.of("Number_Of_Splits").assertPositive().getInt(1);
        Detonation detonation = (Detonation)data.of("Detonation").serialize(Detonation.class);
        Mechanics mechanics = (Mechanics)data.of("Mechanics").serialize(Mechanics.class);
        return new ClusterBomb(projectileSettings, speed, splits, bombs, detonation, mechanics);
    }
}

