/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ChanceSerializer;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.damage.BlockDamageData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockDamage
implements Serializer<BlockDamage> {
    private double dropBlockChance;
    private int damage;
    private int defaultBlockDurability;
    private Material defaultMask;
    private BreakMode defaultMode;
    private Map<Material, DamageConfig> blocks;

    public BlockDamage() {
    }

    public BlockDamage(double dropBlockChance, int damage, int defaultBlockDurability, Material defaultMask, BreakMode defaultMode, Map<Material, DamageConfig> blocks) {
        this.dropBlockChance = dropBlockChance;
        this.damage = damage;
        this.defaultBlockDurability = defaultBlockDurability;
        this.defaultMask = defaultMask;
        this.defaultMode = defaultMode;
        this.blocks = blocks;
    }

    public double getDropBlockChance() {
        return this.dropBlockChance;
    }

    public void setDropBlockChance(double dropBlockChance) {
        this.dropBlockChance = dropBlockChance;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public int getDefaultBlockDurability() {
        return this.defaultBlockDurability;
    }

    public void setDefaultBlockDurability(int defaultBlockDurability) {
        this.defaultBlockDurability = defaultBlockDurability;
    }

    public Material getDefaultMask() {
        return this.defaultMask;
    }

    public void setDefaultMask(Material defaultMask) {
        this.defaultMask = defaultMask;
    }

    public BreakMode getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(BreakMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    public Map<Material, DamageConfig> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Map<Material, DamageConfig> blocks) {
        this.blocks = blocks;
    }

    public BreakMode getBreakMode(Block block) {
        return this.getBreakMode(block.getType());
    }

    public BreakMode getBreakMode(Material material) {
        DamageConfig config = this.blocks.get(material);
        return config == null ? this.defaultMode : config.mode;
    }

    public int getDurability(Block block) {
        return this.getDurability(block.getType());
    }

    public int getDurability(Material material) {
        DamageConfig config = this.blocks.get(material);
        return config == null ? this.defaultBlockDurability : config.blockDurability;
    }

    public Material getMask(Block block) {
        return this.getMask(block.getType());
    }

    public Material getMask(Material material) {
        DamageConfig config = this.blocks.get(material);
        return config == null ? this.defaultMask : config.mask;
    }

    public boolean canBreakBlocks() {
        if (this.defaultMode == BreakMode.BREAK) {
            return true;
        }
        return this.blocks.values().stream().anyMatch(config -> config.mode == BreakMode.BREAK);
    }

    @Nullable
    public BlockDamageData.DamageData damage(Block block, @Nullable Player player, boolean isRegenerate) {
        BreakMode blockBreakMode = this.getBreakMode(block);
        if (blockBreakMode != BreakMode.CANCEL && !BlockDamageData.isBroken(block)) {
            int max;
            BlockDamageData.DamageData data;
            boolean dropItems = blockBreakMode == BreakMode.BREAK;
            ArrayList drops = null;
            if (blockBreakMode == BreakMode.BREAK) {
                boolean disableBlockBreakEvent = WeaponMechanics.getBasicConfigurations().getBool("Disable_Block_Break_Event");
                if (!disableBlockBreakEvent && player != null) {
                    BlockBreakEvent breakEvent = new BlockBreakEvent(block, player){

                        @NotNull
                        public String getEventName() {
                            return "WeaponMechanicsBlockDamage";
                        }
                    };
                    Bukkit.getPluginManager().callEvent((Event)breakEvent);
                    if (breakEvent.isCancelled()) {
                        return null;
                    }
                    if (ReflectionUtil.getMCVersion() >= 12) {
                        dropItems = breakEvent.isDropItems();
                    }
                }
                drops = RandomUtil.chance((double)this.dropBlockChance) ? block.getDrops() : null;
                BlockState blockState = block.getState();
                if (blockState instanceof InventoryHolder) {
                    InventoryHolder inv = (InventoryHolder)blockState;
                    if (!isRegenerate) {
                        if (drops == null) {
                            drops = new ArrayList();
                        }
                        if (inv instanceof Chest) {
                            Collections.addAll(drops, ((Chest)inv).getBlockInventory().getContents());
                        } else {
                            Collections.addAll(drops, inv.getInventory().getContents());
                        }
                    }
                }
            }
            if ((data = BlockDamageData.damage(block, (double)this.damage / (double)(max = this.getDurability(block)), this.getBreakMode(block) == BreakMode.BREAK, isRegenerate, this.getMask(block))).isBroken() && drops != null && dropItems) {
                Location location = block.getLocation();
                for (ItemStack item : drops) {
                    if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) continue;
                    block.getWorld().dropItemNaturally(location, item);
                }
            }
            return data;
        }
        return null;
    }

    public String getKeyword() {
        return "Block_Damage";
    }

    public boolean letPassThrough(@NotNull String key) {
        return key.endsWith("Spawn_Falling_Block_Chance") || key.endsWith("Regenerate_After_Ticks");
    }

    @NotNull
    public BlockDamage serialize(@NotNull SerializeData data) throws SerializerException {
        if (data.has("Block_List") || data.has("Shots_To_Break_Blocks")) {
            throw data.exception(null, new String[]{"Found an outdated configuration!", "You need to update your 'Block_Damage' to match the new format"});
        }
        Double dropBlockChance = (Double)data.of("Drop_Broken_Block_Chance").serialize((Serializer)new ChanceSerializer());
        if (dropBlockChance == null) {
            dropBlockChance = 0.0;
        }
        int damagePerHit = data.of("Damage_Per_Hit").assertPositive().getInt(1);
        int defaultBlockDurability = data.of("Default_Block_Durability").assertPositive().getInt(1);
        BreakMode defaultMode = (BreakMode)data.of("Default_Mode").getEnum(BreakMode.class, (Enum)BreakMode.BREAK);
        Material defaultMask = (Material)data.of("Default_Mask").getEnum(Material.class, (Enum)Material.AIR);
        EnumMap<Material, DamageConfig> blocks = new EnumMap<Material, DamageConfig>(Material.class);
        List list = data.ofList("Blocks").addArgument(Material.class, true).addArgument(BreakMode.class, true).addArgument(Integer.TYPE, false).assertArgumentPositive().addArgument(Material.class, false).assertExists().assertList().get();
        for (int i = 0; i < list.size(); ++i) {
            Material mask;
            CharSequence[] split = (String[])list.get(i);
            List materials = EnumUtil.parseEnums(Material.class, (String)split[0]);
            BreakMode mode = BreakMode.valueOf(split[1].toUpperCase(Locale.ROOT));
            int blockDurability = split.length > 2 ? Integer.parseInt(split[2]) : -1;
            Material material = mask = split.length > 3 ? Material.valueOf((String)split[3]) : null;
            if (mode != BreakMode.BREAK && mask != null) {
                throw data.listException("Blocks", i, new String[]{"You cannot use material masks with '" + mode + "'", SerializerException.forValue((Object)String.join((CharSequence)" ", split)), "In order to use masks, use 'BREAK' mode"});
            }
            if (mode == BreakMode.CANCEL && blockDurability != -1) {
                throw data.listException("Blocks", i, new String[]{"You cannot use durability with 'CANCEL'", SerializerException.forValue((Object)String.join((CharSequence)" ", split)), "In order to use durability, use 'BREAK' or 'CRACK'"});
            }
            if ((mode == BreakMode.CRACK || mode == BreakMode.BREAK) && blockDurability == -1) {
                int goodNumber = ReflectionUtil.getMCVersion() < 13 ? 1 : (int)((Material)materials.get(0)).getBlastResistance() + 1;
                throw data.listException("Blocks", i, new String[]{"When using '" + mode + "', you MUST also use durability", SerializerException.forValue((Object)String.join((CharSequence)" ", split)), "For example, try '" + String.join((CharSequence)" ", split) + " " + goodNumber + "' instead"});
            }
            if (blockDurability == 0) {
                throw data.listException("Blocks", i, new String[]{"Tried to use '0' for block durability, must be at least '1'"});
            }
            if (mask == null) {
                mask = Material.AIR;
            }
            DamageConfig config = new DamageConfig(mode, blockDurability, mask);
            for (Material mat : materials) {
                blocks.put(mat, config);
            }
        }
        return new BlockDamage(dropBlockChance, damagePerHit, defaultBlockDurability, defaultMask, defaultMode, blocks);
    }

    public static enum BreakMode {
        CANCEL,
        BREAK,
        CRACK;

    }

    public record DamageConfig(BreakMode mode, int blockDurability, Material mask) {
    }
}

