/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.explode;

import java.util.ArrayList;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.Detonation;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Projectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class AirStrike
implements Serializer<AirStrike> {
    private Projectile projectile;
    private int min;
    private int max;
    private double height;
    private double yVariation;
    private double distanceBetweenSquared;
    private double radius;
    private int loops;
    private int delay;
    private Detonation detonation;
    private Mechanics mechanics;

    public AirStrike() {
    }

    public AirStrike(Projectile projectile, int min, int max, double height, double yVariation, double distance, double radius, int loops, int delay, Detonation detonation, Mechanics mechanics) {
        this.projectile = projectile;
        this.min = min;
        this.max = max;
        this.height = height;
        this.yVariation = yVariation;
        this.distanceBetweenSquared = distance * distance;
        this.radius = radius;
        this.loops = loops;
        this.delay = delay;
        this.detonation = detonation;
        this.mechanics = mechanics;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public void setProjectile(Projectile projectile) {
        this.projectile = projectile;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getyVariation() {
        return this.yVariation;
    }

    public void setyVariation(double yVariation) {
        this.yVariation = yVariation;
    }

    public double getDistanceBetweenSquared() {
        return this.distanceBetweenSquared;
    }

    public void setDistanceBetweenSquared(double distanceBetweenSquared) {
        this.distanceBetweenSquared = distanceBetweenSquared;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public int getLoops() {
        return this.loops;
    }

    public void setLoops(int loops) {
        this.loops = loops;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public Detonation getDetonation() {
        return this.detonation;
    }

    public void setDetonation(Detonation detonation) {
        this.detonation = detonation;
    }

    public void trigger(final Location flareLocation, final LivingEntity shooter, final WeaponProjectile projectile) {
        if (this.mechanics != null) {
            CastData cast = new CastData(shooter, projectile.getWeaponTitle(), projectile.getWeaponStack());
            cast.setTargetLocation(flareLocation);
            this.mechanics.use(cast);
        }
        new BukkitRunnable(){
            int count = 0;

            public void run() {
                int bombs = RandomUtil.range((int)AirStrike.this.min, (int)AirStrike.this.max);
                int checks = bombs * bombs;
                ArrayList<Vector2d> spawnLocations = new ArrayList<Vector2d>(bombs);
                block0: for (int i = 0; i < checks && spawnLocations.size() < bombs; ++i) {
                    Projectile projectileHandler;
                    double x = flareLocation.getX() + RandomUtil.range((double)(-AirStrike.this.radius), (double)AirStrike.this.radius);
                    double z = flareLocation.getZ() + RandomUtil.range((double)(-AirStrike.this.radius), (double)AirStrike.this.radius);
                    Vector2d vector = new Vector2d(x, z);
                    for (Vector2d spawnLocation : spawnLocations) {
                        if (!(vector.distanceSquared(spawnLocation) < AirStrike.this.distanceBetweenSquared)) continue;
                        continue block0;
                    }
                    spawnLocations.add(vector);
                    double y = flareLocation.getY() + AirStrike.this.height + RandomUtil.range((double)(-AirStrike.this.yVariation), (double)AirStrike.this.yVariation);
                    Location location = new Location(flareLocation.getWorld(), x, y, z);
                    Projectile projectile2 = projectileHandler = AirStrike.this.getProjectile() != null ? AirStrike.this.getProjectile() : (Projectile)WeaponMechanics.getConfigurations().getObject(projectile.getWeaponTitle() + ".Projectile", Projectile.class);
                    if (projectileHandler == null) continue;
                    WeaponProjectile newProjectile = AirStrike.this.getProjectile() != null ? projectileHandler.create(shooter, location, new Vector(0, 0, 0), projectile.getWeaponStack(), projectile.getWeaponTitle(), projectile.getHand()) : projectile.clone(location, new Vector(0, 0, 0));
                    newProjectile.setIntTag("airstrike-bomb", 1);
                    projectileHandler.shoot(newProjectile, location);
                }
                if (++this.count >= AirStrike.this.loops) {
                    this.cancel();
                }
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, (long)this.delay);
    }

    @NotNull
    public AirStrike serialize(@NotNull SerializeData data) throws SerializerException {
        int max;
        int min = data.of("Minimum_Bombs").assertExists().assertPositive().getInt();
        if (min > (max = data.of("Maximum_Bombs").assertExists().assertPositive().getInt())) {
            throw data.exception("Minimum_Bombs", new String[]{"The number for 'Minimum_Bombs' should be less then 'Maximum_Bombs'"});
        }
        Projectile projectile = (Projectile)data.of("Dropped_Projectile").assertExists().serialize(Projectile.class);
        double yOffset = data.of("Height").assertPositive().getDouble(60.0);
        double yNoise = data.of("Vertical_Randomness").assertPositive().getDouble(5.0);
        double separation = data.of("Distance_Between_Bombs").assertPositive().getDouble(3.0);
        double range = data.of("Maximum_Distance_From_Center").assertPositive().getDouble(25.0);
        int layers = data.of("Layers").assertPositive().getInt(1);
        int interval = data.of("Delay_Between_Layers").assertPositive().getInt(40);
        Detonation detonation = (Detonation)data.of("Detonation").serialize(Detonation.class);
        Mechanics mechanics = (Mechanics)data.of("Mechanics").serialize(Mechanics.class);
        return new AirStrike(projectile, min, max, yOffset, yNoise, separation, range, layers, interval, detonation, mechanics);
    }

    record Vector2d(double x, double z) {
        double distanceSquared(Vector2d vector) {
            return NumberConversions.square((double)(this.x - vector.x)) + NumberConversions.square((double)(this.z - vector.z));
        }
    }
}

