/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.damage;

import java.util.Set;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.MinecraftVersions;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.compatibility.WeaponCompatibilityAPI;
import me.deecaad.weaponmechanics.utils.MetadataKey;
import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public class DamageUtil {
    private DamageUtil() {
    }

    public static boolean apply(LivingEntity cause, LivingEntity victim, double damage) {
        Player player;
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        Configuration config = WeaponMechanics.getBasicConfigurations();
        if (victim instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)victim;
            if (config.getBool("Damage.Ignore_Armor_Stand.Always")) {
                return true;
            }
            if (config.getBool("Damage.Ignore_Armor_Stand.Marker") && armorStand.isMarker()) {
                return true;
            }
            if (config.getBool("Damage.Ignore_Armor_Stand.Invisible") && armorStand.isInvisible()) {
                return true;
            }
        }
        if (victim.isInvulnerable() || victim.isDead()) {
            return true;
        }
        if (victim instanceof Player) {
            Player player2 = (Player)victim;
            GameMode gamemode = player2.getGameMode();
            if (gamemode == GameMode.CREATIVE || gamemode == GameMode.SPECTATOR) {
                return true;
            }
        } else if (victim instanceof Enderman) {
            Enderman enderman = (Enderman)victim;
            if (ReflectionUtil.getMCVersion() >= 20) {
                int teleportAttempts = WeaponMechanics.getBasicConfigurations().getInt("Damage.Enderman_Teleport_Attempts", 64);
                boolean isTeleported = false;
                for (int i = 0; i < teleportAttempts && !isTeleported; ++i) {
                    isTeleported = enderman.getTarget() == null ? enderman.teleport() : enderman.teleportTowards((Entity)cause);
                }
                if (isTeleported) {
                    return true;
                }
            }
        }
        if (damage < 0.0) {
            damage = 0.0;
        }
        if (WeaponMechanics.getBasicConfigurations().getBool("Damage.Use_Vanilla_Damaging", false)) {
            if (damage == 0.0) {
                return true;
            }
            MetadataKey.VANILLA_DAMAGE.set((Entity)victim, null);
            victim.damage(damage, (Entity)cause);
            if (MetadataKey.CANCELLED_DAMAGE.has((Entity)victim)) {
                MetadataKey.CANCELLED_DAMAGE.remove((Entity)victim);
                return true;
            }
            victim.setNoDamageTicks(0);
            return false;
        }
        double tempDamage = damage;
        try {
            victim.setMetadata("doing-weapon-damage", (MetadataValue)new LazyMetadataValue(WeaponMechanics.getPlugin(), () -> true));
            entityDamageByEntityEvent = WeaponCompatibilityAPI.getWeaponCompatibility().newEntityDamageByEntityEvent(victim, cause, damage, true);
            Bukkit.getPluginManager().callEvent((Event)entityDamageByEntityEvent);
            victim.removeMetadata("doing-weapon-damage", WeaponMechanics.getPlugin());
            if (entityDamageByEntityEvent.isCancelled()) {
                return true;
            }
        }
        catch (LinkageError ex) {
            WeaponMechanics.debug.error(new String[]{"You are using an outdated version of Spigot 1.20.4. Please update to the latest version.", "This is required for the new damage source API to work.", "Detected version: " + MinecraftVersions.getCURRENT(), ""});
            return true;
        }
        damage = entityDamageByEntityEvent.getDamage();
        if (tempDamage != damage && damage == 0.0) {
            return true;
        }
        double absorption = CompatibilityAPI.getEntityCompatibility().getAbsorption(victim);
        double absorbed = Math.max(0.0, absorption - damage);
        CompatibilityAPI.getEntityCompatibility().setAbsorption(victim, absorbed);
        damage = Math.max(damage - absorption, 0.0);
        double oldHealth = victim.getHealth();
        WeaponCompatibilityAPI.getWeaponCompatibility().logDamage(victim, cause, oldHealth, damage, false);
        if (cause instanceof Player) {
            Player player3 = (Player)cause;
            WeaponCompatibilityAPI.getWeaponCompatibility().setKiller(victim, player3);
        }
        WeaponCompatibilityAPI.getWeaponCompatibility().playHurtAnimation(victim);
        victim.setLastDamage(damage);
        victim.setLastDamageCause((EntityDamageEvent)entityDamageByEntityEvent);
        double newHealth = NumberUtil.clamp((double)(oldHealth - damage), (double)0.0, (double)victim.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        boolean killed = newHealth <= 0.0;
        boolean resurrected = false;
        if (killed) {
            resurrected = CompatibilityAPI.getEntityCompatibility().tryUseTotemOfUndying(victim);
            boolean bl = killed = !resurrected;
        }
        if (!resurrected) {
            victim.setHealth(newHealth);
        }
        if (victim instanceof Player) {
            player = (Player)victim;
            if (ReflectionUtil.getMCVersion() >= 13 && absorbed >= 0.1) {
                player.incrementStatistic(Statistic.DAMAGE_ABSORBED, Math.round((float)absorbed * 10.0f));
            }
            if (damage >= 0.1) {
                player.incrementStatistic(Statistic.DAMAGE_TAKEN, Math.round((float)damage * 10.0f));
            }
            if (killed && DamageUtil.isWhitelisted(cause.getType())) {
                player.incrementStatistic(Statistic.ENTITY_KILLED_BY, cause.getType());
            }
        }
        if (cause instanceof Player) {
            player = (Player)cause;
            if (ReflectionUtil.getMCVersion() >= 13 && absorbed >= 0.1) {
                player.incrementStatistic(Statistic.DAMAGE_DEALT_ABSORBED, Math.round((float)absorbed * 10.0f));
            }
            if (damage >= 0.1) {
                player.incrementStatistic(Statistic.DAMAGE_DEALT, Math.round((float)damage * 10.0f));
            }
            if (killed) {
                if (DamageUtil.isWhitelisted(victim.getType())) {
                    player.incrementStatistic(Statistic.KILL_ENTITY, victim.getType());
                }
                if (ReflectionUtil.getMCVersion() < 13) {
                    if (victim.getType() == EntityType.PLAYER) {
                        player.incrementStatistic(Statistic.PLAYER_KILLS);
                    } else {
                        player.incrementStatistic(Statistic.MOB_KILLS);
                    }
                }
            }
        }
        return false;
    }

    public static boolean isWhitelisted(EntityType type) {
        if (ReflectionUtil.getMCVersion() >= 13) {
            return true;
        }
        return switch (type) {
            case EntityType.IRON_GOLEM, EntityType.SNOWMAN, EntityType.ENDER_DRAGON, EntityType.WITHER, EntityType.GIANT, EntityType.PLAYER -> false;
            default -> ReflectionUtil.getMCVersion() != 12 || type != EntityType.ILLUSIONER;
        };
    }

    public static void damageArmor(LivingEntity victim, int amount) {
        DamageUtil.damageArmor(victim, amount, null);
    }

    public static void damageArmor(LivingEntity victim, int amount, @Nullable DamagePoint point) {
        if (amount <= 0) {
            return;
        }
        EntityEquipment equipment = victim.getEquipment();
        if (equipment == null) {
            return;
        }
        if (point == null) {
            DamageUtil.damage(equipment, EquipmentSlot.HEAD, amount);
            DamageUtil.damage(equipment, EquipmentSlot.CHEST, amount);
            DamageUtil.damage(equipment, EquipmentSlot.LEGS, amount);
            DamageUtil.damage(equipment, EquipmentSlot.FEET, amount);
        } else {
            switch (point) {
                case HEAD: {
                    DamageUtil.damage(equipment, EquipmentSlot.HEAD, amount);
                    break;
                }
                case BODY: 
                case ARMS: {
                    DamageUtil.damage(equipment, EquipmentSlot.CHEST, amount);
                    break;
                }
                case LEGS: {
                    DamageUtil.damage(equipment, EquipmentSlot.LEGS, amount);
                    break;
                }
                case FEET: {
                    DamageUtil.damage(equipment, EquipmentSlot.FEET, amount);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown point: " + point);
                }
            }
        }
    }

    private static void damage(EntityEquipment equipment, EquipmentSlot slot, int amount) {
        boolean skipDamage;
        ItemStack armor = switch (slot) {
            case EquipmentSlot.HEAD -> equipment.getHelmet();
            case EquipmentSlot.CHEST -> equipment.getChestplate();
            case EquipmentSlot.LEGS -> equipment.getLeggings();
            case EquipmentSlot.FEET -> equipment.getBoots();
            default -> throw new IllegalArgumentException("Invalid slot: " + slot);
        };
        if (armor == null || "AIR".equals(armor.getType().name()) || ReflectionUtil.getMCVersion() >= 13 && armor.getType().getMaxDurability() == 0) {
            return;
        }
        ItemMeta meta = armor.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta.isUnbreakable()) {
            return;
        }
        int level = meta.getEnchantLevel(Enchantment.DURABILITY);
        boolean bl = skipDamage = !RandomUtil.chance((double)(0.6 + 0.4 / (double)(level + 1)));
        if (skipDamage) {
            return;
        }
        if (ReflectionUtil.getMCVersion() >= 13) {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(damageable.getDamage() + amount);
                armor.setItemMeta(meta);
                if (damageable.getDamage() >= armor.getType().getMaxDurability()) {
                    armor.setAmount(0);
                }
            }
        } else {
            armor.setDurability((short)(armor.getDurability() + amount));
            if (armor.getDurability() >= armor.getType().getMaxDurability()) {
                armor.setAmount(0);
            }
        }
        switch (slot) {
            case HEAD: {
                equipment.setHelmet(armor);
                break;
            }
            case CHEST: {
                equipment.setChestplate(armor);
                break;
            }
            case LEGS: {
                equipment.setLeggings(armor);
                break;
            }
            case FEET: {
                equipment.setBoots(armor);
            }
        }
    }

    public static boolean canHarmScoreboardTeams(LivingEntity cause, LivingEntity victim) {
        if (cause.equals(victim)) {
            return true;
        }
        if (cause.getType() != EntityType.PLAYER || victim.getType() != EntityType.PLAYER) {
            return true;
        }
        Scoreboard shooterScoreboard = ((Player)cause).getScoreboard();
        if (shooterScoreboard == null) {
            return true;
        }
        Set teams = shooterScoreboard.getTeams();
        if (teams == null || teams.isEmpty()) {
            return true;
        }
        for (Team team : teams) {
            Set entries = team.getEntries();
            if (!entries.contains(cause.getName()) || !entries.contains(victim.getName()) || team.allowFriendlyFire()) continue;
            return false;
        }
        return true;
    }
}

