/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.damage;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.primitive.DoubleEntry;
import me.deecaad.core.utils.primitive.DoubleMap;
import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageModifier
implements Serializer<DamageModifier> {
    private double min;
    private double max;
    private double perArmorPoint;
    private DoubleMap<Material> armorModifiers;
    private DoubleMap<Enchantment> enchantmentModifiers;
    private double headModifier;
    private double bodyModifier;
    private double armsModifier;
    private double legsModifier;
    private double feetModifier;
    private double backModifier;
    private double sneakingModifier;
    private double walkingModifier;
    private double swimmingModifier;
    private double sprintingModifier;
    private double inMidairModifier;
    private double shieldModifier;
    private DoubleMap<EntityType> entityTypeModifiers;
    private DoubleMap<PotionEffectType> potionEffectModifiers;

    public DamageModifier() {
    }

    public DamageModifier(double min, double max, double perArmorPoint, DoubleMap<Material> armorModifiers, DoubleMap<Enchantment> enchantmentModifiers, double headModifier, double bodyModifier, double armsModifier, double legsModifier, double feetModifier, double backModifier, double sneakingModifier, double walkingModifier, double swimmingModifier, double sprintingModifier, double inMidairModifier, double shieldModifier, DoubleMap<EntityType> entityTypeModifiers, DoubleMap<PotionEffectType> potionEffectModifiers) {
        this.min = min;
        this.max = max;
        this.perArmorPoint = perArmorPoint;
        this.armorModifiers = armorModifiers;
        this.enchantmentModifiers = enchantmentModifiers;
        this.headModifier = headModifier;
        this.bodyModifier = bodyModifier;
        this.armsModifier = armsModifier;
        this.legsModifier = legsModifier;
        this.feetModifier = feetModifier;
        this.backModifier = backModifier;
        this.sneakingModifier = sneakingModifier;
        this.walkingModifier = walkingModifier;
        this.swimmingModifier = swimmingModifier;
        this.sprintingModifier = sprintingModifier;
        this.inMidairModifier = inMidairModifier;
        this.shieldModifier = shieldModifier;
        this.entityTypeModifiers = entityTypeModifiers;
        this.potionEffectModifiers = potionEffectModifiers;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getPerArmorPoint() {
        return this.perArmorPoint;
    }

    public void setPerArmorPoint(double perArmorPoint) {
        this.perArmorPoint = perArmorPoint;
    }

    public DoubleMap<Material> getArmorModifiers() {
        return this.armorModifiers;
    }

    public void setArmorModifiers(DoubleMap<Material> armorModifiers) {
        this.armorModifiers = armorModifiers;
    }

    public DoubleMap<Enchantment> getEnchantmentModifiers() {
        return this.enchantmentModifiers;
    }

    public void setEnchantmentModifiers(DoubleMap<Enchantment> enchantmentModifiers) {
        this.enchantmentModifiers = enchantmentModifiers;
    }

    public double getHeadModifier() {
        return this.headModifier;
    }

    public void setHeadModifier(double headModifier) {
        this.headModifier = headModifier;
    }

    public double getBodyModifier() {
        return this.bodyModifier;
    }

    public void setBodyModifier(double bodyModifier) {
        this.bodyModifier = bodyModifier;
    }

    public double getArmsModifier() {
        return this.armsModifier;
    }

    public void setArmsModifier(double armsModifier) {
        this.armsModifier = armsModifier;
    }

    public double getLegsModifier() {
        return this.legsModifier;
    }

    public void setLegsModifier(double legsModifier) {
        this.legsModifier = legsModifier;
    }

    public double getFeetModifier() {
        return this.feetModifier;
    }

    public void setFeetModifier(double feetModifier) {
        this.feetModifier = feetModifier;
    }

    public double getBackModifier() {
        return this.backModifier;
    }

    public void setBackModifier(double backModifier) {
        this.backModifier = backModifier;
    }

    public double getSneakingModifier() {
        return this.sneakingModifier;
    }

    public void setSneakingModifier(double sneakingModifier) {
        this.sneakingModifier = sneakingModifier;
    }

    public double getWalkingModifier() {
        return this.walkingModifier;
    }

    public void setWalkingModifier(double walkingModifier) {
        this.walkingModifier = walkingModifier;
    }

    public double getSwimmingModifier() {
        return this.swimmingModifier;
    }

    public void setSwimmingModifier(double swimmingModifier) {
        this.swimmingModifier = swimmingModifier;
    }

    public double getSprintingModifier() {
        return this.sprintingModifier;
    }

    public void setSprintingModifier(double sprintingModifier) {
        this.sprintingModifier = sprintingModifier;
    }

    public double getInMidairModifier() {
        return this.inMidairModifier;
    }

    public void setInMidairModifier(double inMidairModifier) {
        this.inMidairModifier = inMidairModifier;
    }

    public DoubleMap<EntityType> getEntityTypeModifiers() {
        return this.entityTypeModifiers;
    }

    public void setEntityTypeModifiers(DoubleMap<EntityType> entityTypeModifiers) {
        this.entityTypeModifiers = entityTypeModifiers;
    }

    public DoubleMap<PotionEffectType> getPotionEffectModifiers() {
        return this.potionEffectModifiers;
    }

    public void setPotionEffectModifiers(DoubleMap<PotionEffectType> potionEffectModifiers) {
        this.potionEffectModifiers = potionEffectModifiers;
    }

    public double getRate(@NotNull EntityWrapper wrapper, @Nullable DamagePoint point, boolean isBackStab) {
        Player player;
        LivingEntity livingEntity;
        LivingEntity victim = wrapper.getEntity();
        double rate = 1.0;
        AttributeInstance armorAttribute = victim.getAttribute(Attribute.GENERIC_ARMOR);
        if (armorAttribute != null) {
            rate += this.perArmorPoint * armorAttribute.getValue();
        }
        EntityEquipment equipment = victim.getEquipment();
        if ((this.enchantmentModifiers != null || this.armorModifiers != null) && equipment != null) {
            for (ItemStack armor : equipment.getArmorContents()) {
                if (armor == null) continue;
                if (this.armorModifiers != null) {
                    rate += this.armorModifiers.get((Object)armor.getType());
                }
                if (this.enchantmentModifiers == null) continue;
                for (Map.Entry entry : armor.getEnchantments().entrySet()) {
                    rate += this.enchantmentModifiers.get(entry.getKey()) * (double)((Integer)entry.getValue()).intValue();
                }
            }
        }
        if (point != null) {
            rate += (switch (point) {
                default -> throw new IncompatibleClassChangeError();
                case DamagePoint.HEAD -> this.headModifier;
                case DamagePoint.BODY -> this.bodyModifier;
                case DamagePoint.ARMS -> this.armsModifier;
                case DamagePoint.LEGS -> this.legsModifier;
                case DamagePoint.FEET -> this.feetModifier;
            });
        }
        if (isBackStab) {
            rate += this.backModifier;
        }
        if (wrapper.isSneaking()) {
            rate += this.sneakingModifier;
        }
        if (wrapper.isWalking()) {
            rate += this.walkingModifier;
        }
        if (wrapper.isSwimming()) {
            rate += this.swimmingModifier;
        }
        if (wrapper.isSprinting()) {
            rate += this.sprintingModifier;
        }
        if (wrapper.isInMidair()) {
            rate += this.inMidairModifier;
        }
        if (!isBackStab && (livingEntity = wrapper.getEntity()) instanceof Player && (player = (Player)livingEntity).isBlocking()) {
            rate += this.shieldModifier;
        }
        if (this.entityTypeModifiers != null) {
            rate += this.entityTypeModifiers.get((Object)victim.getType());
        }
        if (this.potionEffectModifiers != null) {
            for (DoubleEntry entry : this.potionEffectModifiers.entrySet()) {
                if (!victim.hasPotionEffect((PotionEffectType)entry.getKey())) continue;
                rate += entry.getValue();
            }
        }
        return NumberUtil.clamp((double)rate, (double)this.min, (double)this.max);
    }

    public double clamp(double rate) {
        return NumberUtil.clamp((double)rate, (double)this.min, (double)this.max);
    }

    public double applyRates(double damage, EntityWrapper wrapper, DamagePoint point, boolean isBackStab) {
        return damage * this.getRate(wrapper, point, isBackStab);
    }

    public String getKeyword() {
        return "Damage_Modifiers";
    }

    @NotNull
    public DamageModifier serialize(@NotNull SerializeData data) throws SerializerException {
        double min = DamageModifier.serializePercentage(data.of("Min"), "20%");
        double max = DamageModifier.serializePercentage(data.of("Max"), "1000%");
        double perArmorPoint = DamageModifier.serializePercentage(data.of("Per_Armor_Point"));
        DoubleMap armorModifiers = new DoubleMap();
        List armorSplitList = data.ofList("Armor").addArgument(Material.class, true).addArgument(String.class, true).assertList().get();
        for (int i = 0; i < armorSplitList.size(); ++i) {
            String[] split = (String[])armorSplitList.get(i);
            List armorMaterial = EnumUtil.parseEnums(Material.class, (String)split[0]);
            double percentage = DamageModifier.stringToDouble(split[1], data.ofList("Armor").getLocation(i));
            for (Material material : armorMaterial) {
                armorModifiers.put((Object)material, percentage);
            }
        }
        DoubleMap enchantmentModifiers = new DoubleMap();
        List enchantmentSplitList = data.ofList("Enchantments").addArgument(Enchantment.class, true, true).addArgument(String.class, true).assertList().get();
        for (int i = 0; i < enchantmentSplitList.size(); ++i) {
            String[] split = (String[])enchantmentSplitList.get(i);
            Enchantment enchantment = null;
            if (ReflectionUtil.getMCVersion() >= 13) {
                enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)split[0].toLowerCase(Locale.ROOT)));
            }
            if (enchantment == null) {
                enchantment = Enchantment.getByName((String)split[0].toUpperCase(Locale.ROOT));
            }
            if (enchantment == null) {
                List<String> options = Arrays.stream(Enchantment.values()).map(ench -> ReflectionUtil.getMCVersion() < 13 ? ench.getName() : ench.getKey().getKey()).toList();
                throw new SerializerOptionsException((Serializer)this, "Enchantment", options, split[0], data.ofList("Enchantments").getLocation(i));
            }
            double percentage = DamageModifier.stringToDouble(split[1], data.ofList("Enchantments").getLocation(i));
            enchantmentModifiers.put((Object)enchantment, percentage);
        }
        double headModifier = DamageModifier.serializePercentage(data.of("Head"));
        double bodyModifier = DamageModifier.serializePercentage(data.of("Body"));
        double armsModifier = DamageModifier.serializePercentage(data.of("Arms"));
        double legsModifier = DamageModifier.serializePercentage(data.of("Legs"));
        double feetModifier = DamageModifier.serializePercentage(data.of("Feet"));
        double backModifier = DamageModifier.serializePercentage(data.of("Back"));
        double sneakingModifier = DamageModifier.serializePercentage(data.of("Sneaking"));
        double walkingModifier = DamageModifier.serializePercentage(data.of("Walking"));
        double swimmingModifier = DamageModifier.serializePercentage(data.of("Swimming"));
        double sprintingModifier = DamageModifier.serializePercentage(data.of("Sprinting"));
        double inMidairModifier = DamageModifier.serializePercentage(data.of("In_Midair"));
        double shieldModifier = DamageModifier.serializePercentage(data.of("Shielding"));
        DoubleMap entityTypeModifiers = new DoubleMap();
        List entitySplitList = data.ofList("Entities").addArgument(EntityType.class, true).addArgument(String.class, true).assertList().get();
        for (int i = 0; i < entitySplitList.size(); ++i) {
            String[] split = (String[])entitySplitList.get(i);
            List entityTypes = EnumUtil.parseEnums(EntityType.class, (String)split[0]);
            double percentage = DamageModifier.stringToDouble(split[1], data.ofList("Armor").getLocation(i));
            for (EntityType entity : entityTypes) {
                entityTypeModifiers.put((Object)entity, percentage);
            }
        }
        DoubleMap potionEffectModifiers = new DoubleMap();
        List potionSplitList = data.ofList("Potions").addArgument(PotionEffectType.class, true, true).addArgument(String.class, true).assertList().get();
        for (int i = 0; i < potionSplitList.size(); ++i) {
            String[] split = (String[])potionSplitList.get(i);
            PotionEffectType potion = null;
            if (ReflectionUtil.getMCVersion() >= 13) {
                potion = PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)split[0].toLowerCase(Locale.ROOT)));
            }
            if (potion == null) {
                potion = PotionEffectType.getByName((String)split[0].toUpperCase(Locale.ROOT));
            }
            if (potion == null) {
                List<String> options = Arrays.stream(Enchantment.values()).map(ench -> ReflectionUtil.getMCVersion() < 13 ? ench.getName() : ench.getKey().getKey()).toList();
                throw new SerializerOptionsException((Serializer)this, "Potion", options, split[0], data.ofList("Potions").getLocation(i));
            }
            double percentage = DamageModifier.stringToDouble(split[1], data.ofList("Potions").getLocation(i));
            potionEffectModifiers.put((Object)potion, percentage);
        }
        return new DamageModifier(min, max, perArmorPoint, (DoubleMap<Material>)armorModifiers, (DoubleMap<Enchantment>)enchantmentModifiers, headModifier, bodyModifier, armsModifier, legsModifier, feetModifier, backModifier, sneakingModifier, walkingModifier, swimmingModifier, sprintingModifier, inMidairModifier, shieldModifier, (DoubleMap<EntityType>)entityTypeModifiers, (DoubleMap<PotionEffectType>)potionEffectModifiers);
    }

    private static double serializePercentage(SerializeData.ConfigAccessor accessor) throws SerializerException {
        return DamageModifier.serializePercentage(accessor, "+0%");
    }

    private static double serializePercentage(SerializeData.ConfigAccessor accessor, String defaultVal) throws SerializerException {
        return DamageModifier.stringToDouble((String)accessor.assertType(String.class).get((Object)defaultVal), accessor.getLocation());
    }

    private static double stringToDouble(String str, String location) throws SerializerException {
        str = str.trim();
        boolean isNegative = str.startsWith("-");
        str = str.replace("%", "");
        str = str.replace("+", "");
        str = str.replace("-", "");
        try {
            double value = Double.parseDouble(str);
            return isNegative ? -value : (value /= 100.0);
        }
        catch (NumberFormatException e) {
            throw new SerializerTypeException("DamageModifier", Double.class, String.class, (Object)str, location);
        }
    }
}

