/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.damage;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.jetbrains.annotations.NotNull;

public class DamageDropoff
implements Serializer<DamageDropoff> {
    private TreeMap<Double, Double> distances;

    public DamageDropoff() {
    }

    public DamageDropoff(TreeMap<Double, Double> distances) {
        this.distances = distances;
    }

    public double getDamage(double distance) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Smooth_Damage_Dropoff", false)) {
            Map.Entry<Double, Double> floor = this.distances.floorEntry(distance);
            Map.Entry<Double, Double> ceiling = this.distances.ceilingEntry(distance);
            if (ceiling == null) {
                return floor == null ? 0.0 : floor.getValue();
            }
            double floorDistance = floor == null ? 0.0 : floor.getKey();
            double floorDamage = floor == null ? 0.0 : floor.getValue();
            return NumberUtil.remap((double)distance, (double)floorDistance, (double)ceiling.getKey(), (double)floorDamage, (double)ceiling.getValue());
        }
        Map.Entry<Double, Double> floor = this.distances.floorEntry(distance);
        return floor == null ? 0.0 : floor.getValue();
    }

    public String getKeyword() {
        return "Dropoff";
    }

    @NotNull
    public DamageDropoff serialize(@NotNull SerializeData data) throws SerializerException {
        List list = data.ofList().addArgument(Double.TYPE, true).addArgument(Double.TYPE, true).assertExists().assertList().get();
        TreeMap<Double, Double> distances = new TreeMap<Double, Double>();
        for (String[] split : list) {
            Double blocks = Double.valueOf(split[0]);
            Double damage = Double.valueOf(split[1]);
            distances.put(blocks, damage);
        }
        return new DamageDropoff(distances);
    }
}

