/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.damage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.block.BlockCompatibility;
import me.deecaad.core.utils.DistanceUtil;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Candle;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockDamageData {
    private static final Map<ChunkPos, Map<Block, DamageData>> DAMAGE_MAP = new LinkedHashMap<ChunkPos, Map<Block, DamageData>>(256);
    public static final int MAX_BLOCK_CRACK = 9;
    public static final Material MASK = Material.valueOf((String)"AIR");
    public static final double EPSILON = 1.0E-7;

    private BlockDamageData() {
    }

    public static DamageData damage(@NotNull Block block, double damage, boolean isBreak, boolean isRegenerate) {
        return BlockDamageData.damage(block, damage, isBreak, isRegenerate, MASK);
    }

    public static DamageData damage(@NotNull Block block, double damage, boolean isBreak, boolean isRegenerate, Material mask) {
        ChunkPos pos = new ChunkPos(block);
        Map map = DAMAGE_MAP.computeIfAbsent(pos, k -> new HashMap());
        DamageData damageData = map.computeIfAbsent(block, DamageData::new);
        damageData.damage(damage, isBreak, isRegenerate, mask);
        return damageData;
    }

    @Nullable
    public static DamageData getBlockDamage(@NotNull Block block) {
        Map<Block, DamageData> map = DAMAGE_MAP.get(new ChunkPos(block));
        if (map == null) {
            return null;
        }
        return map.get(block);
    }

    public static boolean isBroken(@NotNull Block block) {
        DamageData data = BlockDamageData.getBlockDamage(block);
        return data != null && data.isBroken();
    }

    public static void regenerate(@NotNull Block block) {
        Map<Block, DamageData> data = DAMAGE_MAP.get(new ChunkPos(block));
        if (data == null) {
            return;
        }
        DamageData damage = data.get(block);
        damage.regenerate();
        data.remove(block);
    }

    public static void regenerate(@NotNull Chunk chunk) {
        ChunkPos pos = new ChunkPos(chunk);
        BlockDamageData.regenerate(pos);
        DAMAGE_MAP.remove(pos);
    }

    public static void regenerate(@NotNull World world) {
        Iterator<ChunkPos> iterator = DAMAGE_MAP.keySet().iterator();
        while (iterator.hasNext()) {
            ChunkPos pos = iterator.next();
            if (!pos.world.equals(world)) continue;
            BlockDamageData.regenerate(pos);
            iterator.remove();
        }
    }

    public static void regenerateAll() {
        Iterator<ChunkPos> iterator = DAMAGE_MAP.keySet().iterator();
        while (iterator.hasNext()) {
            ChunkPos pos = iterator.next();
            BlockDamageData.regenerate(pos);
            iterator.remove();
        }
    }

    private static void regenerate(@NotNull ChunkPos pos) {
        Map<Block, DamageData> blocks = DAMAGE_MAP.get(pos);
        if (blocks == null) {
            return;
        }
        blocks.forEach((block, damage) -> damage.regenerate());
    }

    public static class DamageData {
        private final Block block;
        private double durability = 1.0;
        private BlockState state = null;
        private int packetId = -1;

        private DamageData(Block block) {
            this.block = block;
        }

        public void damage(double amount, boolean isBreak, boolean isRegenerate) {
            this.damage(amount, isBreak, isRegenerate, MASK);
        }

        public void damage(double amount, boolean isBreak, boolean isRegenerate, Material mask) {
            this.durability -= amount;
            if (isBreak && this.isBroken()) {
                this.destroy(isRegenerate, mask);
            } else {
                this.sendCrackPacket();
            }
        }

        public boolean isBroken() {
            return this.durability <= 1.0E-7;
        }

        public void destroy(boolean isRegenerate, Material mask) {
            boolean attemptCopy;
            this.state = this.block.getState();
            if (isRegenerate && this.state instanceof InventoryHolder) {
                Inventory inv = this.state instanceof Chest ? ((Chest)this.state).getBlockInventory() : ((InventoryHolder)this.state).getInventory();
                inv.clear();
            }
            if ((attemptCopy = WeaponMechanics.getBasicConfigurations().getBool("Explosions.Attempt_Copy_Data", false)) && ReflectionUtil.getMCVersion() >= 13) {
                BlockData oldData = this.block.getBlockData();
                BlockData newData = mask.createBlockData();
                if (newData instanceof MultipleFacing) {
                    MultipleFacing newFace = (MultipleFacing)newData;
                    if (oldData instanceof MultipleFacing) {
                        MultipleFacing oldFace = (MultipleFacing)oldData;
                        for (BlockFace face : oldFace.getAllowedFaces()) {
                            newFace.setFace(face, oldFace.hasFace(face));
                        }
                    }
                }
                if (newData instanceof Orientable) {
                    Orientable newOrient = (Orientable)newData;
                    if (oldData instanceof Orientable) {
                        Orientable oldOrient = (Orientable)oldData;
                        newOrient.setAxis(oldOrient.getAxis());
                    }
                }
                if (newData instanceof Ageable) {
                    Ageable newAge = (Ageable)newData;
                    if (oldData instanceof Ageable) {
                        Ageable oldAge = (Ageable)oldData;
                        newAge.setAge(oldAge.getAge());
                    }
                }
                if (newData instanceof Lightable) {
                    Lightable newLight = (Lightable)newData;
                    if (oldData instanceof Lightable) {
                        Lightable oldLight = (Lightable)oldData;
                        newLight.setLit(oldLight.isLit());
                    }
                }
                if (newData instanceof Candle) {
                    Candle newCandle = (Candle)newData;
                    if (oldData instanceof Candle) {
                        Candle oldCandle = (Candle)oldData;
                        newCandle.setCandles(oldCandle.getCandles());
                    }
                }
                if (newData instanceof SeaPickle) {
                    SeaPickle newPickle = (SeaPickle)newData;
                    if (oldData instanceof SeaPickle) {
                        SeaPickle oldPickle = (SeaPickle)oldData;
                        newPickle.setPickles(oldPickle.getPickles());
                    }
                }
                if (newData instanceof Waterlogged) {
                    Waterlogged newWater = (Waterlogged)newData;
                    if (oldData instanceof Waterlogged) {
                        Waterlogged oldWater = (Waterlogged)oldData;
                        newWater.setWaterlogged(oldWater.isWaterlogged());
                    }
                }
                if (newData instanceof Rotatable) {
                    Rotatable newRotate = (Rotatable)newData;
                    if (oldData instanceof Rotatable) {
                        Rotatable oldRotate = (Rotatable)oldData;
                        newRotate.setRotation(oldRotate.getRotation());
                    }
                }
                this.block.setBlockData(newData, false);
                return;
            }
            this.block.setType(mask, !isRegenerate);
        }

        public void regenerate() {
            if (this.state != null) {
                this.state.update(true, false);
                this.state = null;
            }
            this.durability = 1.0;
            this.sendCrackPacket();
        }

        public void remove() {
            Map<Block, DamageData> map = DAMAGE_MAP.get(new ChunkPos(this.block));
            map.remove(this.block);
        }

        public void sendCrackPacket() {
            if (this.packetId == -1) {
                this.packetId = BlockCompatibility.IDS.incrementAndGet();
            }
            int crack = this.durability >= 0.9999999 ? -1 : (int)NumberUtil.lerp((double)9.0, (double)0.0, (double)this.durability);
            Object packet = CompatibilityAPI.getBlockCompatibility().getCrackPacket(this.block, crack, this.packetId);
            DistanceUtil.sendPacket((Location)this.block.getLocation(), (Object[])new Object[]{packet});
        }
    }

    public static class ChunkPos {
        private final World world;
        private final int x;
        private final int z;

        public ChunkPos(Block block) {
            this(block.getChunk());
        }

        public ChunkPos(Chunk chunk) {
            this.world = chunk.getWorld();
            this.x = chunk.getX();
            this.z = chunk.getZ();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkPos chunkPos = (ChunkPos)o;
            return this.x == chunkPos.x && this.z == chunkPos.z && this.world.equals(chunkPos.world);
        }

        public int hashCode() {
            return this.x * 31 ^ this.z ^ this.world.hashCode();
        }
    }
}

