/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon.damage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.IValidator;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AssistData
implements IValidator {
    private final Map<UUID, Map<String, DamageInfo>> players = new HashMap<UUID, Map<String, DamageInfo>>();

    public void logDamage(Player shooter, String weaponTitle, ItemStack weaponStack, double amount) {
        UUID uuid = shooter.getUniqueId();
        this.players.putIfAbsent(uuid, new HashMap());
        this.players.get(uuid).compute(weaponTitle, (key, value) -> value == null ? new DamageInfo(amount, weaponStack) : value.add(amount, weaponStack));
    }

    @Nullable
    public Map<Player, Map<String, DamageInfo>> getAssists(Player killer) {
        if (this.players.isEmpty()) {
            return null;
        }
        HashMap<Player, Map<String, DamageInfo>> assists = new HashMap<Player, Map<String, DamageInfo>>();
        double requiredDamageAmount = WeaponMechanics.getBasicConfigurations().getDouble("Assists_Event.Required_Damage_Amount", 0.0);
        int timer = WeaponMechanics.getBasicConfigurations().getInt("Assists_Event.Timer", 0);
        this.players.forEach((uuid, value) -> {
            if (killer != null && uuid.equals(killer.getUniqueId())) {
                return;
            }
            Player playerByUuid = Bukkit.getPlayer((UUID)uuid);
            if (playerByUuid == null) {
                return;
            }
            assists.putIfAbsent(playerByUuid, new HashMap());
            double totalDamage = 0.0;
            long lastHitTime = 0L;
            for (Map.Entry entry : value.entrySet()) {
                DamageInfo entryValue = (DamageInfo)entry.getValue();
                totalDamage += entryValue.damage;
                if (lastHitTime == 0L) {
                    lastHitTime = entryValue.lastHitTime;
                }
                lastHitTime = Math.max(lastHitTime, entryValue.lastHitTime);
                ((Map)assists.get(playerByUuid)).put((String)entry.getKey(), entryValue);
            }
            if (requiredDamageAmount != 0.0 && totalDamage < requiredDamageAmount || timer != 0 && NumberUtil.hasMillisPassed((long)lastHitTime, (long)timer)) {
                assists.remove(playerByUuid);
            }
        });
        return assists.isEmpty() ? null : assists;
    }

    public String toString() {
        return "AssistData{players=" + this.players + "}";
    }

    public String getKeyword() {
        return "Assists_Event";
    }

    public void validate(Configuration configuration, SerializeData data) throws SerializerException {
        int timer = data.of("Timer").assertPositive().getInt(100);
        if (timer != 0) {
            configuration.set(data.key + ".Timer", (Object)(timer * 50));
        }
        double damageAmount = data.of("Required_Damage_Amount").assertPositive().getDouble(0.0);
        if (data.of("Enable").getBool(true) && timer == 0 && damageAmount == 0.0) {
            throw data.exception("", new String[]{"When using assists, make sure to either use Timer or Required_Damage_Amount"});
        }
    }

    public static class DamageInfo {
        private long lastHitTime = System.currentTimeMillis();
        private double damage;
        private ItemStack weaponStack;

        public DamageInfo(double damage, ItemStack weaponStack) {
            this.damage = damage;
            this.weaponStack = weaponStack;
        }

        private DamageInfo add(double damage, ItemStack weaponStack) {
            this.lastHitTime = System.currentTimeMillis();
            this.damage += damage;
            this.weaponStack = weaponStack;
            return this;
        }

        public double getDamage() {
            return this.damage;
        }

        public ItemStack getWeaponStack() {
            return this.weaponStack;
        }

        public int getLastHitTime() {
            return (int)((System.currentTimeMillis() - this.lastHitTime) / 50L);
        }

        public String toString() {
            return "DamageInfo{lastHitTime=" + this.lastHitTime + ", damage=" + this.damage + ", weaponStack=" + this.weaponStack.getType() + "}";
        }
    }
}

