/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon;

import java.util.ArrayList;
import java.util.List;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.HitHandler;
import me.deecaad.weaponmechanics.weapon.damage.DamageHandler;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import me.deecaad.weaponmechanics.weapon.melee.MeleeHandler;
import me.deecaad.weaponmechanics.weapon.reload.ReloadHandler;
import me.deecaad.weaponmechanics.weapon.scope.ScopeHandler;
import me.deecaad.weaponmechanics.weapon.shoot.ShootHandler;
import me.deecaad.weaponmechanics.weapon.skin.SkinHandler;
import me.deecaad.weaponmechanics.weapon.stats.StatsHandler;
import me.deecaad.weaponmechanics.weapon.trigger.AmmoTypeSwitchTriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.SelectiveFireTriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerListener;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeaponHandler {
    private final InfoHandler infoHandler = new InfoHandler(this);
    private final ShootHandler shootHandler = new ShootHandler(this);
    private final ReloadHandler reloadHandler = new ReloadHandler(this);
    private final ScopeHandler scopeHandler = new ScopeHandler(this);
    private final DamageHandler damageHandler = new DamageHandler(this);
    private final SkinHandler skinHandler = new SkinHandler(this);
    private final MeleeHandler meleeHandler = new MeleeHandler(this);
    private final StatsHandler statsHandler = new StatsHandler(this);
    private final HitHandler hitHandler = new HitHandler(this);
    private final List<TriggerListener> triggerListeners = new ArrayList<TriggerListener>(5);

    public WeaponHandler() {
        this.fillTriggerListeners();
    }

    public void useTrigger(LivingEntity livingEntity, TriggerType triggerType, boolean autoConvert) {
        boolean dualWield;
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper(livingEntity, true);
        if (entityWrapper == null) {
            return;
        }
        if (livingEntity.getType() == EntityType.PLAYER && ((Player)livingEntity).getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        ItemStack mainStack = entityEquipment.getItemInMainHand();
        String mainWeapon = this.infoHandler.getWeaponTitle(mainStack, autoConvert);
        ItemStack offStack = entityEquipment.getItemInOffHand();
        String offWeapon = this.infoHandler.getWeaponTitle(offStack, autoConvert);
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        if (this.infoHandler.denyDualWielding(triggerType, livingEntity.getType() == EntityType.PLAYER ? (Player)livingEntity : null, mainWeapon, offWeapon)) {
            return;
        }
        boolean bl = dualWield = mainWeapon != null && offWeapon != null;
        if (mainWeapon != null) {
            this.tryUses(entityWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, triggerType, dualWield, null);
        }
        if (offWeapon != null) {
            this.tryUses(entityWrapper, offWeapon, offStack, EquipmentSlot.OFF_HAND, triggerType, dualWield, null);
        }
    }

    public void tryUses(EntityWrapper entityWrapper, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot, TriggerType triggerType, boolean dualWield, @Nullable LivingEntity victim) {
        if (!weaponStack.hasItemMeta()) {
            return;
        }
        try {
            for (TriggerListener listener : this.triggerListeners) {
                if (!listener.tryUse(entityWrapper, weaponTitle, weaponStack, slot, triggerType, dualWield, victim) || listener.allowOtherTriggers()) continue;
                return;
            }
        }
        catch (Exception e) {
            WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Unhandled exception while looping trigger listeners!"});
            WeaponMechanics.debug.log(LogLevel.WARN, (Throwable)e);
            return;
        }
        this.getSkinHandler().tryUse(triggerType, entityWrapper, weaponTitle, weaponStack, slot);
    }

    private void fillTriggerListeners() {
        this.triggerListeners.add(this.shootHandler);
        this.triggerListeners.add(this.reloadHandler);
        this.triggerListeners.add(this.scopeHandler);
        this.triggerListeners.add(new AmmoTypeSwitchTriggerListener());
        this.triggerListeners.add(new SelectiveFireTriggerListener());
    }

    public void addTriggerListener(TriggerListener triggerListener) {
        if (triggerListener == null) {
            throw new NullPointerException("Plugin gave null trigger listener...?");
        }
        this.triggerListeners.add(triggerListener);
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public ShootHandler getShootHandler() {
        return this.shootHandler;
    }

    public ReloadHandler getReloadHandler() {
        return this.reloadHandler;
    }

    public ScopeHandler getScopeHandler() {
        return this.scopeHandler;
    }

    public DamageHandler getDamageHandler() {
        return this.damageHandler;
    }

    public SkinHandler getSkinHandler() {
        return this.skinHandler;
    }

    public MeleeHandler getMeleeHandler() {
        return this.meleeHandler;
    }

    public StatsHandler getStatsHandler() {
        return this.statsHandler;
    }

    public HitHandler getHitHandler() {
        return this.hitHandler;
    }
}

