/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.weapon;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.compatibility.worldguard.WorldGuardCompatibility;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.core.utils.ray.BlockTraceResult;
import me.deecaad.core.utils.ray.EntityTraceResult;
import me.deecaad.core.utils.ray.RayTraceResult;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import me.deecaad.weaponmechanics.weapon.explode.Explosion;
import me.deecaad.weaponmechanics.weapon.explode.ExplosionTrigger;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.WeaponProjectile;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileHitBlockEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.ProjectileHitEntityEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponMeleeHitEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class HitHandler {
    private static final double FRONT_HIT = -0.2;
    private WeaponHandler weaponHandler;

    public HitHandler(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    public boolean handleHit(RayTraceResult result, WeaponProjectile projectile) {
        if (result instanceof BlockTraceResult) {
            BlockTraceResult blockHit = (BlockTraceResult)result;
            return this.handleBlockHit(blockHit, projectile);
        }
        if (result instanceof EntityTraceResult) {
            EntityTraceResult entityHit = (EntityTraceResult)result;
            return this.handleEntityHit(entityHit, projectile);
        }
        return true;
    }

    public boolean handleMeleeHit(EntityTraceResult result, LivingEntity shooter, Vector shooterDirection, String weaponTitle, ItemStack weaponStack, EquipmentSlot slot) {
        Location loc;
        WorldGuardCompatibility worldGuard = CompatibilityAPI.getWorldGuardCompatibility();
        if (!worldGuard.testFlag(loc = result.getHitLocation().clone().toLocation(shooter.getWorld()), shooter instanceof Player ? (Player)shooter : null, "weapon-damage")) {
            Object obj = worldGuard.getValue(loc, "weapon-damage-message");
            if (obj != null && !obj.toString().isEmpty() && shooter != null) {
                shooter.sendMessage(StringUtil.colorBukkit((String)obj.toString()));
            }
            return true;
        }
        Configuration config = WeaponMechanics.getConfigurations();
        LivingEntity livingEntity = result.getEntity();
        int meleeHitDelay = config.getInt(weaponTitle + ".Melee.Melee_Hit_Delay") / 50;
        boolean backstab = livingEntity.getLocation().getDirection().dot(shooterDirection) > 0.0;
        WeaponMeleeHitEvent event = new WeaponMeleeHitEvent(weaponTitle, weaponStack, shooter, slot, livingEntity, meleeHitDelay, backstab);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return true;
        }
        if (event.getMeleeHitDelay() != 0) {
            EntityWrapper wrapper = WeaponMechanics.getEntityWrapper(shooter);
            HandData hand = wrapper.getMainHandData();
            hand.setLastMeleeTime(System.currentTimeMillis());
        }
        return !this.weaponHandler.getDamageHandler().tryUse(livingEntity, WeaponMechanics.getConfigurations().getDouble(weaponTitle + ".Damage.Base_Damage"), this.getDamagePoint(result, shooterDirection), backstab, shooter, weaponTitle, weaponStack, slot, result.getHitMinClamped());
    }

    private boolean handleBlockHit(BlockTraceResult result, WeaponProjectile projectile) {
        ProjectileHitBlockEvent hitBlockEvent = new ProjectileHitBlockEvent(projectile, result.getBlock(), result.getHitFace(), result.getHitLocation().clone());
        Bukkit.getPluginManager().callEvent((Event)hitBlockEvent);
        if (hitBlockEvent.isCancelled()) {
            return true;
        }
        Explosion explosion = (Explosion)WeaponMechanics.getConfigurations().getObject(projectile.getWeaponTitle() + ".Explosion", Explosion.class);
        if (explosion != null) {
            explosion.handleExplosion(projectile.getShooter(), result.getHitLocation().clone().toLocation(projectile.getWorld()), projectile, ExplosionTrigger.BLOCK);
        }
        return false;
    }

    private boolean handleEntityHit(EntityTraceResult result, WeaponProjectile projectile) {
        LivingEntity shooter;
        Location loc;
        WorldGuardCompatibility worldGuard = CompatibilityAPI.getWorldGuardCompatibility();
        if (!worldGuard.testFlag(loc = result.getHitLocation().toLocation(projectile.getWorld()), (shooter = projectile.getShooter()) instanceof Player ? (Player)shooter : null, "weapon-damage")) {
            Object obj = worldGuard.getValue(loc, "weapon-damage-message");
            if (obj != null && !obj.toString().isEmpty() && shooter != null) {
                shooter.sendMessage(StringUtil.colorBukkit((String)obj.toString()));
            }
            return true;
        }
        LivingEntity livingEntity = result.getEntity();
        boolean backstab = livingEntity.getLocation().getDirection().dot(projectile.getMotion()) > 0.0;
        DamagePoint hitPoint = this.getDamagePoint(result, shooter.getLocation().getDirection());
        ProjectileHitEntityEvent hitEntityEvent = new ProjectileHitEntityEvent(projectile, livingEntity, result.getHitLocation().clone(), hitPoint, backstab);
        Bukkit.getPluginManager().callEvent((Event)hitEntityEvent);
        if (hitEntityEvent.isCancelled()) {
            return true;
        }
        hitPoint = hitEntityEvent.getPoint();
        backstab = hitEntityEvent.isBackStab();
        if (!this.weaponHandler.getDamageHandler().tryUse(livingEntity, projectile, WeaponMechanics.getConfigurations().getDouble(projectile.getWeaponTitle() + ".Damage.Base_Damage"), hitPoint, backstab)) {
            return true;
        }
        Explosion explosion = (Explosion)WeaponMechanics.getConfigurations().getObject(projectile.getWeaponTitle() + ".Explosion", Explosion.class);
        if (explosion != null) {
            explosion.handleExplosion(projectile.getShooter(), result.getHitLocation().clone().toLocation(projectile.getWorld()), projectile, ExplosionTrigger.ENTITY);
        }
        return false;
    }

    private DamagePoint getDamagePoint(EntityTraceResult result, Vector normalizedMotion) {
        LivingEntity livingEntity = result.getEntity();
        Configuration basicConfiguration = WeaponMechanics.getBasicConfigurations();
        EntityType type = livingEntity.getType();
        double entityHeight = livingEntity.getHeight();
        double hitY = result.getHitLocation().getY();
        HitBox hitBox = result.getHitBox();
        double maxY = hitBox.getMaxY();
        double head = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.HEAD.name());
        if (head > 0.0 && maxY - entityHeight * head < hitY) {
            return DamagePoint.HEAD;
        }
        double body = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.BODY.name());
        if (body >= 1.0 || body > 0.0 && maxY - entityHeight * (head + body) < hitY) {
            boolean horizontalEntity = basicConfiguration.getBool("Entity_Hitboxes." + type.name() + ".Horizontal_Entity", false);
            boolean arms = basicConfiguration.getBool("Entity_Hitboxes." + type.name() + "." + DamagePoint.ARMS.name(), false);
            if (horizontalEntity || arms) {
                Vector normalizedEntityDirection = livingEntity.getLocation().getDirection();
                if (horizontalEntity && !hitBox.cloneDimensions().expand(normalizedEntityDirection, -0.2).collides(result.getHitLocation())) {
                    return DamagePoint.HEAD;
                }
                if (arms && Math.abs(normalizedMotion.clone().setY(0).dot(normalizedEntityDirection.setY(0))) < 0.5) {
                    return DamagePoint.ARMS;
                }
            }
            return DamagePoint.BODY;
        }
        double legs = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.LEGS.name());
        if (legs > 0.0 && maxY - entityHeight * (head + body + legs) < hitY) {
            return DamagePoint.LEGS;
        }
        double feet = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.FEET.name());
        if (feet > 0.0) {
            return DamagePoint.FEET;
        }
        WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Something unexpected happened and HEAD, BODY, LEGS or FEET wasn't valid", "This should never happen. Using BODY as default value...", "This happened with entity type " + type + "."});
        return DamagePoint.BODY;
    }
}

