/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.SerializerMissingKeyException;
import me.deecaad.core.file.SerializerOptionsException;
import me.deecaad.core.file.SerializerTypeException;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.StringUtil;
import org.jetbrains.annotations.NotNull;

public class Factory<T> {
    private final Map<String, Arguments> map = new HashMap<String, Arguments>();
    private final Class<T> clazz;

    protected Factory(@NotNull Class<T> clazz) {
        this.clazz = clazz;
    }

    public final T get(@NotNull String key, @NotNull Map<String, Object> arguments) throws SerializerException {
        Arguments args = this.map.get(key = key.trim().toUpperCase(Locale.ROOT));
        if (args == null) {
            String name = (String)StringUtil.splitCapitalLetters((String)this.getClass().getSimpleName()).get(0);
            throw new SerializerOptionsException(name, this.clazz.getSimpleName(), this.getOptions(), key, "FILL_ME");
        }
        Object[] objects = new Object[args.arguments.length];
        for (int i = 0; i < args.arguments.length; ++i) {
            String argument = args.arguments[i];
            Class<?> clazz = args.argumentTypes[i];
            if (!arguments.containsKey(argument)) {
                String name = (String)StringUtil.splitCapitalLetters((String)args.manufacturedType.getSimpleName()).get(0);
                throw new SerializerMissingKeyException(name, argument, "FILL_ME").addMessage("You specified: " + arguments);
            }
            if (clazz != null && !clazz.isAssignableFrom(arguments.get(argument).getClass())) {
                try {
                    if (clazz == Double.TYPE) {
                        objects[i] = Double.parseDouble(arguments.get(argument).toString());
                        continue;
                    }
                    if (clazz == Integer.TYPE) {
                        objects[i] = Integer.parseInt(arguments.get(argument).toString());
                        continue;
                    }
                    if (clazz == Boolean.TYPE) {
                        objects[i] = Boolean.parseBoolean(arguments.get(argument).toString());
                        continue;
                    }
                    throw new NumberFormatException();
                }
                catch (NumberFormatException ex) {
                    String name = (String)StringUtil.splitCapitalLetters((String)args.manufacturedType.getSimpleName()).get(0);
                    throw new SerializerTypeException(name, clazz, arguments.get(argument).getClass(), arguments.get(argument), "FILL_ME");
                }
            }
            objects[i] = arguments.get(argument);
        }
        return (T)ReflectionUtil.newInstance(args.manufacturedType, (Object[])objects);
    }

    public final void set(@NotNull String key, @NotNull Arguments args) {
        for (String str : key.split(", ?")) {
            this.map.put(str.trim().toUpperCase(Locale.ROOT), args);
        }
    }

    @NotNull
    public Set<String> getOptions() {
        return this.map.keySet();
    }

    @NotNull
    public Map<String, Class<T>> getMap() {
        HashMap temp = new HashMap(this.map.size());
        this.map.forEach((key, value) -> temp.put((String)key, value.manufacturedType));
        return temp;
    }

    public class Arguments {
        private final Class<T> manufacturedType;
        private final String[] arguments;
        private final Class<?>[] argumentTypes;

        public Arguments(Class<? extends T> manufacturedType, String[] arguments) {
            this.manufacturedType = manufacturedType;
            this.arguments = arguments;
            this.argumentTypes = new Class[arguments.length];
        }

        public Arguments(Class<? extends T> manufacturedType, String[] arguments, Class<?>[] argumentTypes) {
            this.manufacturedType = manufacturedType;
            this.arguments = arguments;
            this.argumentTypes = argumentTypes;
        }
    }
}

