/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.utils;

import java.util.Locale;
import me.deecaad.core.compatibility.CompatibilityAPI;
import org.bukkit.inventory.ItemStack;

public enum CustomTag {
    WEAPON_TITLE,
    SELECTIVE_FIRE,
    AMMO_LEFT,
    AMMO_TYPE_INDEX,
    AMMO_TITLE("ammo-name"),
    AMMO_MAGAZINE,
    FIREARM_ACTION_STATE,
    DURABILITY,
    MAX_DURABILITY,
    BROKEN_WEAPON,
    REPAIR_KIT_TITLE,
    ATTACHMENT_TITLE,
    ATTACHMENTS,
    WEAPON_SKIN,
    ARMOR_TITLE(null, "armormechanics"),
    PREVENT_REMOVE(null, "armormechanics");

    private final String owningPlugin;
    private final String id;

    private CustomTag() {
        this.id = this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        this.owningPlugin = "weaponmechanics";
    }

    private CustomTag(String id) {
        this.id = id;
        this.owningPlugin = "weaponmechanics";
    }

    private CustomTag(String id, String owningPlugin) {
        this.id = id != null ? id : this.name().toLowerCase(Locale.ROOT).replace('_', '-');
        this.owningPlugin = owningPlugin;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.owningPlugin + ":" + this.getId();
    }

    public boolean hasString(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().hasString(item, this.owningPlugin, this.id);
    }

    public String getString(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().getString(item, this.owningPlugin, this.id);
    }

    public void setString(ItemStack item, String value) {
        CompatibilityAPI.getNBTCompatibility().setString(item, this.owningPlugin, this.id, value);
    }

    public boolean hasInteger(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().hasInt(item, this.owningPlugin, this.id);
    }

    public int getInteger(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().getInt(item, this.owningPlugin, this.id);
    }

    public void setInteger(ItemStack item, int value) {
        CompatibilityAPI.getNBTCompatibility().setInt(item, this.owningPlugin, this.id, value);
    }

    public boolean hasDouble(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().hasDouble(item, this.owningPlugin, this.id);
    }

    public double getDouble(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().getDouble(item, this.owningPlugin, this.id);
    }

    public void setDouble(ItemStack item, double value) {
        CompatibilityAPI.getNBTCompatibility().setDouble(item, this.owningPlugin, this.id, value);
    }

    public boolean hasArray(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().hasArray(item, this.owningPlugin, this.id);
    }

    public int[] getArray(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().getArray(item, this.owningPlugin, this.id);
    }

    public void setArray(ItemStack item, int[] value) {
        CompatibilityAPI.getNBTCompatibility().setArray(item, this.owningPlugin, this.id, value);
    }

    public boolean hasStringArray(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().hasStringArray(item, this.owningPlugin, this.id);
    }

    public String[] getStringArray(ItemStack item) {
        return CompatibilityAPI.getNBTCompatibility().getStringArray(item, this.owningPlugin, this.id);
    }

    public void setStringArray(ItemStack item, String[] value) {
        CompatibilityAPI.getNBTCompatibility().setStringArray(item, this.owningPlugin, this.id, value);
    }

    public void remove(ItemStack item) {
        CompatibilityAPI.getNBTCompatibility().remove(item, this.owningPlugin, this.id);
    }
}

