/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.utils.CustomTag;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class OutSetSlotBobFix
extends PacketAdapter
implements Listener {
    private final Map<Player, SimpleItemData> mainHand = new HashMap<Player, SimpleItemData>();
    private final Map<Player, SimpleItemData> offHand = new HashMap<Player, SimpleItemData>();

    public OutSetSlotBobFix(Plugin plugin) {
        super(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.SET_SLOT});
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void drop(PlayerDropItemEvent event) {
        this.mainHand.put(event.getPlayer(), null);
    }

    @EventHandler
    public void click(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.mainHand.put(player, null);
        this.offHand.put(player, null);
    }

    @EventHandler
    public void click(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.mainHand.put(player, null);
        this.offHand.put(player, null);
    }

    @EventHandler(ignoreCancelled=true)
    public void held(PlayerItemHeldEvent e) {
        this.mainHand.put(e.getPlayer(), null);
    }

    @EventHandler
    public void quit(PlayerQuitEvent event) {
        this.mainHand.remove(event.getPlayer());
        this.offHand.remove(event.getPlayer());
    }

    public void onPacketReceiving(PacketEvent event) {
    }

    public void onPacketSending(PacketEvent event) {
        boolean mainHand;
        if (event.isPlayerTemporary()) {
            return;
        }
        Player player = event.getPlayer();
        if ((Integer)event.getPacket().getIntegers().read(0) != 0) {
            return;
        }
        int slotNum = (Integer)event.getPacket().getIntegers().read(ReflectionUtil.getMCVersion() >= 17 ? 2 : 1);
        boolean bl = mainHand = slotNum == 36 + player.getInventory().getHeldItemSlot();
        if (!mainHand && slotNum != 45) {
            return;
        }
        Map<Player, SimpleItemData> data = mainHand ? this.mainHand : this.offHand;
        ItemStack packetItem = (ItemStack)event.getPacket().getItemModifier().read(0);
        if (!packetItem.hasItemMeta() || !CustomTag.WEAPON_TITLE.hasString(packetItem)) {
            data.put(player, null);
            return;
        }
        SimpleItemData lastData = data.get(player);
        if (lastData == null) {
            data.put(player, new SimpleItemData(slotNum, packetItem));
            return;
        }
        SimpleItemData newData = new SimpleItemData(slotNum, packetItem);
        if (newData.isDifferent(lastData)) {
            data.put(player, newData);
            return;
        }
        event.setCancelled(true);
    }

    public static class SimpleItemData {
        private final int sentToSlot;
        private final Material type;
        private final int amount;
        private String displayName;
        private List<String> lore;
        private int customModelData;
        private int durability;

        public SimpleItemData(int sentToSlot, ItemStack itemStack) {
            Damageable damageableItemMeta;
            this.sentToSlot = sentToSlot;
            this.type = itemStack.getType();
            this.amount = itemStack.getAmount();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
                return;
            }
            if (itemMeta.hasDisplayName()) {
                this.displayName = itemMeta.getDisplayName();
            }
            if (itemMeta.hasLore()) {
                this.lore = itemMeta.getLore();
            }
            if (ReflectionUtil.getMCVersion() >= 14 && itemMeta.hasCustomModelData()) {
                this.customModelData = itemMeta.getCustomModelData();
            }
            if (ReflectionUtil.getMCVersion() < 13) {
                this.durability = itemStack.getDurability();
            } else if (itemMeta instanceof Damageable && (damageableItemMeta = (Damageable)itemMeta).hasDamage()) {
                this.durability = ((Damageable)itemMeta).getDamage();
            }
        }

        public boolean sameSlot(int newSlot) {
            return this.sentToSlot == newSlot;
        }

        public boolean isDifferent(SimpleItemData other) {
            return this.sentToSlot != other.sentToSlot || this.type != other.type || this.amount != other.amount || this.customModelData != other.customModelData || this.durability != other.durability || !Objects.equals(this.displayName, other.displayName) || !Objects.equals(this.lore, other.lore);
        }
    }
}

