/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.listeners.trigger;

import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.events.PlayerJumpEvent;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class TriggerPlayerListeners
implements Listener {
    private final WeaponHandler weaponHandler;

    public TriggerPlayerListeners(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @EventHandler
    public void join(PlayerJoinEvent e) {
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(e.getPlayer());
        this.weaponHandler.getStatsHandler().load(playerWrapper);
    }

    @EventHandler
    public void quit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.weaponHandler.getStatsHandler().save(WeaponMechanics.getPlayerWrapper(player), false);
        WeaponMechanics.removeEntityWrapper((LivingEntity)player);
    }

    @EventHandler(ignoreCancelled=true)
    public void toggleSneak(PlayerToggleSneakEvent e) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Sneak")) {
            return;
        }
        Player player = e.getPlayer();
        boolean isSneaking = e.isSneaking();
        if (isSneaking && WeaponMechanics.getPlayerWrapper(player).didDoubleSneak()) {
            this.weaponHandler.useTrigger((LivingEntity)player, TriggerType.DOUBLE_SNEAK, false);
        }
        this.weaponHandler.useTrigger((LivingEntity)player, isSneaking ? TriggerType.START_SNEAK : TriggerType.END_SNEAK, false);
    }

    @EventHandler(ignoreCancelled=true)
    public void toggleSprint(PlayerToggleSprintEvent e) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Sprint")) {
            return;
        }
        this.weaponHandler.useTrigger((LivingEntity)e.getPlayer(), e.isSprinting() ? TriggerType.START_SPRINT : TriggerType.END_SPRINT, false);
    }

    @EventHandler
    public void jump(PlayerJumpEvent e) {
        this.weaponHandler.useTrigger((LivingEntity)e.getPlayer(), e.isDoubleJump() ? TriggerType.DOUBLE_JUMP : TriggerType.JUMP, false);
    }

    @EventHandler(ignoreCancelled=true)
    public void toggleFlight(PlayerToggleFlightEvent e) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Double_Jump")) {
            return;
        }
        Player player = e.getPlayer();
        GameMode gameMode = player.getGameMode();
        if (gameMode == GameMode.SURVIVAL || gameMode == GameMode.ADVENTURE) {
            e.setCancelled(true);
            player.setFlying(false);
            player.setAllowFlight(false);
            Bukkit.getPluginManager().callEvent((Event)new PlayerJumpEvent(player, true));
        }
    }

    @EventHandler
    public void interactAt(PlayerInteractAtEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (entity.getType() != EntityType.ARMOR_STAND) {
            return;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        if (armorStand.isVisible()) {
            return;
        }
        Player player = e.getPlayer();
        EntityEquipment playerEquipment = player.getEquipment();
        GameMode gameMode = player.getGameMode();
        if (gameMode == GameMode.SPECTATOR || gameMode == GameMode.CREATIVE || playerEquipment == null) {
            return;
        }
        ItemStack mainStack = playerEquipment.getItemInMainHand();
        String mainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(mainStack, false);
        ItemStack offStack = playerEquipment.getItemInOffHand();
        String offWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(offStack, false);
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        e.setCancelled(true);
        this.interact(new PlayerInteractEvent(player, Action.RIGHT_CLICK_AIR, mainStack, null, null, e.getHand()));
    }

    @EventHandler
    public void interact(PlayerInteractEvent e) {
        boolean dualWield;
        boolean rightClick;
        Action action = e.getAction();
        Player player = e.getPlayer();
        EntityEquipment playerEquipment = player.getEquipment();
        if (player.getGameMode() == GameMode.SPECTATOR || playerEquipment == null) {
            return;
        }
        if (action == Action.PHYSICAL || e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Right_And_Left_Click")) {
            return;
        }
        EquipmentSlot hand = e.getHand();
        if (playerEquipment.getItemInMainHand().getType() == Material.AIR ? action == Action.RIGHT_CLICK_BLOCK && hand == EquipmentSlot.HAND : hand == EquipmentSlot.OFF_HAND) {
            return;
        }
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        boolean bl = rightClick = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
        if (rightClick) {
            WeaponMechanics.getPlayerWrapper(player).rightClicked();
        } else if (CompatibilityAPI.getVersion() >= 1.15 && !NumberUtil.hasMillisPassed((long)playerWrapper.getLastDropWeaponTime(), (long)25L)) {
            return;
        }
        ItemStack mainStack = playerEquipment.getItemInMainHand();
        String mainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(mainStack, true);
        ItemStack offStack = playerEquipment.getItemInOffHand();
        String offWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(offStack, true);
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        if (mainWeapon != null && WeaponMechanics.getConfigurations().getBool(mainWeapon + ".Info.Cancel.Block_Interactions") || offWeapon != null && WeaponMechanics.getConfigurations().getBool(offWeapon + ".Info.Cancel.Block_Interactions")) {
            e.setUseInteractedBlock(Event.Result.DENY);
        }
        if (mainWeapon != null && WeaponMechanics.getConfigurations().getBool(mainWeapon + ".Info.Cancel.Item_Interactions") || offWeapon != null && WeaponMechanics.getConfigurations().getBool(offWeapon + ".Info.Cancel.Item_Interactions")) {
            e.setUseItemInHand(Event.Result.DENY);
        }
        boolean bl2 = dualWield = mainWeapon != null && offWeapon != null;
        if (rightClick) {
            if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.RIGHT_CLICK, player, mainWeapon, offWeapon)) {
                return;
            }
            if (mainWeapon != null) {
                this.weaponHandler.tryUses(playerWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, TriggerType.RIGHT_CLICK, dualWield, null);
            }
            if (offWeapon != null) {
                this.weaponHandler.tryUses(playerWrapper, offWeapon, offStack, EquipmentSlot.OFF_HAND, TriggerType.RIGHT_CLICK, dualWield, null);
            }
            return;
        }
        if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.LEFT_CLICK, player, mainWeapon, offWeapon)) {
            return;
        }
        if (mainWeapon != null) {
            this.weaponHandler.tryUses(playerWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, TriggerType.LEFT_CLICK, dualWield, null);
            if (mainStack.getAmount() != 0) {
                this.weaponHandler.tryUses(playerWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, TriggerType.MELEE, dualWield, null);
            }
        }
        if (offWeapon != null) {
            this.weaponHandler.tryUses(playerWrapper, offWeapon, offStack, EquipmentSlot.OFF_HAND, TriggerType.LEFT_CLICK, dualWield, null);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void animation(PlayerAnimationEvent e) {
        if (e.getAnimationType() != PlayerAnimationType.ARM_SWING) {
            return;
        }
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Right_And_Left_Click")) {
            return;
        }
        Player player = e.getPlayer();
        EntityEquipment playerEquipment = player.getEquipment();
        if (player.getGameMode() == GameMode.SPECTATOR || playerEquipment == null) {
            return;
        }
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        double version = CompatibilityAPI.getVersion();
        if (version >= 1.15 && !NumberUtil.hasMillisPassed((long)playerWrapper.getLastDropWeaponTime(), (long)25L)) {
            e.setCancelled(true);
            return;
        }
        ItemStack mainStack = playerEquipment.getItemInMainHand();
        String mainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(mainStack, false);
        if (mainWeapon != null && WeaponMechanics.getConfigurations().getBool(mainWeapon + ".Info.Cancel.Arm_Swing_Animation")) {
            e.setCancelled(true);
            return;
        }
        ItemStack offStack = playerEquipment.getItemInOffHand();
        String offWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(offStack, false);
        if (offWeapon != null && WeaponMechanics.getConfigurations().getBool(offWeapon + ".Info.Cancel.Arm_Swing_Animation")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void dropItem(PlayerDropItemEvent e) {
        boolean dualWield;
        Player player = e.getPlayer();
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Drop_Item")) {
            return;
        }
        EntityEquipment playerEquipment = player.getEquipment();
        if (player.getGameMode() == GameMode.SPECTATOR || playerEquipment == null) {
            return;
        }
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        if (!NumberUtil.hasMillisPassed((long)playerWrapper.getLastInventoryDropTime(), (long)50L)) {
            return;
        }
        ItemStack mainStack = e.getItemDrop().getItemStack();
        String mainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(mainStack, false);
        ItemStack offStack = playerEquipment.getItemInOffHand();
        String offWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(offStack, false);
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        if (mainWeapon != null && WeaponMechanics.getConfigurations().getBool(mainWeapon + ".Info.Cancel.Drop_Item") || offWeapon != null && WeaponMechanics.getConfigurations().getBool(offWeapon + ".Info.Cancel.Drop_Item")) {
            e.setCancelled(true);
        }
        if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.DROP_ITEM, player, mainWeapon, offWeapon)) {
            return;
        }
        boolean bl = dualWield = mainWeapon != null && offWeapon != null;
        if (mainWeapon != null) {
            playerWrapper.droppedWeapon();
            Bukkit.getScheduler().runTask(WeaponMechanics.getPlugin(), () -> this.weaponHandler.tryUses(playerWrapper, mainWeapon, playerEquipment.getItemInMainHand(), EquipmentSlot.HAND, TriggerType.DROP_ITEM, dualWield, null));
        }
        if (offWeapon != null) {
            playerWrapper.droppedWeapon();
            Bukkit.getScheduler().runTask(WeaponMechanics.getPlugin(), () -> this.weaponHandler.tryUses(playerWrapper, offWeapon, playerEquipment.getItemInOffHand(), EquipmentSlot.OFF_HAND, TriggerType.DROP_ITEM, dualWield, null));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void swapHandItems(PlayerSwapHandItemsEvent e) {
        boolean dualWield;
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Swap_Main_And_Hand_Items")) {
            return;
        }
        Player player = e.getPlayer();
        EntityEquipment playerEquipment = player.getEquipment();
        if (player.getGameMode() == GameMode.SPECTATOR || playerEquipment == null) {
            return;
        }
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        ItemStack toMain = e.getMainHandItem();
        String toMainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(toMain, false);
        ItemStack toOff = e.getOffHandItem();
        String toOffWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(toOff, false);
        if (toMainWeapon == null && toOffWeapon == null) {
            return;
        }
        if (toMainWeapon != null && WeaponMechanics.getConfigurations().getBool(toMainWeapon + ".Info.Cancel.Swap_Hands") || toOffWeapon != null && WeaponMechanics.getConfigurations().getBool(toOffWeapon + ".Info.Cancel.Swap_Hands")) {
            e.setCancelled(true);
            toOff = playerEquipment.getItemInMainHand();
            toMain = playerEquipment.getItemInOffHand();
        } else {
            playerWrapper.getMainHandData().cancelTasks();
            playerWrapper.getOffHandData().cancelTasks();
        }
        boolean bl = dualWield = toMainWeapon != null && toOffWeapon != null;
        if (this.isValid(toMain)) {
            if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.SWAP_HANDS, player, toMainWeapon, toOffWeapon)) {
                return;
            }
            if (toMainWeapon != null) {
                ItemStack finalToMain = toMain;
                Bukkit.getScheduler().runTask(WeaponMechanics.getPlugin(), () -> this.weaponHandler.tryUses(playerWrapper, toMainWeapon, finalToMain, EquipmentSlot.OFF_HAND, TriggerType.SWAP_HANDS, dualWield, null));
            }
        }
        if (this.isValid(toOff)) {
            if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.SWAP_HANDS, player, toMainWeapon, toOffWeapon)) {
                return;
            }
            if (toOffWeapon != null) {
                ItemStack finalToOff = toOff;
                Bukkit.getScheduler().runTask(WeaponMechanics.getPlugin(), () -> this.weaponHandler.tryUses(playerWrapper, toOffWeapon, finalToOff, EquipmentSlot.HAND, TriggerType.SWAP_HANDS, dualWield, null));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        String weaponTitle;
        Player player = event.getPlayer();
        ItemStack weapon = player.getInventory().getItemInMainHand();
        String string = weaponTitle = !this.isValid(weapon) ? null : this.weaponHandler.getInfoHandler().getWeaponTitle(weapon, false);
        if (weaponTitle != null && WeaponMechanics.getConfigurations().getBool(weaponTitle + ".Info.Cancel.Break_Blocks")) {
            if ("WeaponMechanicsBlockDamage".equals(event.getEventName())) {
                return;
            }
            event.setCancelled(true);
        }
    }

    private boolean isValid(ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR;
    }
}

