/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.listeners.trigger;

import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.events.EntityToggleInMidairEvent;
import me.deecaad.weaponmechanics.events.EntityToggleStandEvent;
import me.deecaad.weaponmechanics.events.EntityToggleSwimEvent;
import me.deecaad.weaponmechanics.events.EntityToggleWalkEvent;
import me.deecaad.weaponmechanics.utils.MetadataKey;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.trigger.TriggerType;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class TriggerEntityListeners
implements Listener {
    private WeaponHandler weaponHandler;

    public TriggerEntityListeners(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void damageMonitor(EntityDamageByEntityEvent e) {
        Entity victim = e.getEntity();
        if (!MetadataKey.VANILLA_DAMAGE.has(victim)) {
            return;
        }
        MetadataKey.VANILLA_DAMAGE.remove(victim);
        if (e.isCancelled()) {
            MetadataKey.CANCELLED_DAMAGE.set(victim, null);
        }
    }

    @EventHandler
    public void damage(EntityDamageByEntityEvent e) {
        boolean isSweep;
        Entity victim = e.getEntity();
        if (MetadataKey.VANILLA_DAMAGE.has(victim)) {
            return;
        }
        if (victim.hasMetadata("doing-weapon-damage")) {
            return;
        }
        if (victim.hasMetadata("doing-skill-damage")) {
            return;
        }
        EntityDamageEvent.DamageCause cause = e.getCause();
        boolean bl = isSweep = ReflectionUtil.getMCVersion() > 10 && cause == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK;
        if (cause != EntityDamageEvent.DamageCause.ENTITY_ATTACK && !isSweep) {
            return;
        }
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Right_And_Left_Click")) {
            return;
        }
        Entity damager = e.getDamager();
        if (!damager.getType().isAlive() || !victim.getType().isAlive()) {
            return;
        }
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper((LivingEntity)damager, true);
        if (entityWrapper == null) {
            return;
        }
        LivingEntity livingEntity = entityWrapper.getEntity();
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        ItemStack mainStack = entityEquipment.getItemInMainHand();
        String mainWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(mainStack, false);
        ItemStack offStack = entityEquipment.getItemInOffHand();
        String offWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(offStack, false);
        if (mainWeapon == null && offWeapon == null) {
            return;
        }
        if (mainWeapon != null) {
            e.setCancelled(true);
        }
        if (isSweep) {
            return;
        }
        if (this.weaponHandler.getInfoHandler().denyDualWielding(TriggerType.MELEE, livingEntity.getType() == EntityType.PLAYER ? (Player)livingEntity : null, mainWeapon, offWeapon)) {
            return;
        }
        if (mainStack.getAmount() != 0) {
            this.weaponHandler.tryUses(entityWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, TriggerType.LEFT_CLICK, mainWeapon != null && offWeapon != null, (LivingEntity)victim);
            this.weaponHandler.tryUses(entityWrapper, mainWeapon, mainStack, EquipmentSlot.HAND, TriggerType.MELEE, mainWeapon != null && offWeapon != null, (LivingEntity)victim);
        }
    }

    @EventHandler
    public void death(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            return;
        }
        WeaponMechanics.removeEntityWrapper(e.getEntity());
    }

    @EventHandler
    public void toggleWalk(EntityToggleWalkEvent e) {
        this.weaponHandler.useTrigger(e.getLivingEntity(), e.isWalking() ? TriggerType.START_WALK : TriggerType.END_WALK, false);
    }

    @EventHandler
    public void toggleInMidair(EntityToggleInMidairEvent e) {
        this.weaponHandler.useTrigger(e.getLivingEntity(), e.isInMidair() ? TriggerType.START_IN_MIDAIR : TriggerType.END_IN_MIDAIR, false);
    }

    @EventHandler
    public void toggleStand(EntityToggleStandEvent e) {
        this.weaponHandler.useTrigger(e.getLivingEntity(), e.isStanding() ? TriggerType.START_STAND : TriggerType.END_STAND, false);
    }

    @EventHandler
    public void toggleSwim(EntityToggleSwimEvent e) {
        this.weaponHandler.useTrigger(e.getLivingEntity(), e.isSwimming() ? TriggerType.START_SWIM : TriggerType.END_SWIM, false);
    }

    @EventHandler(ignoreCancelled=true)
    public void toggleGlide(EntityToggleGlideEvent e) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Disabled_Trigger_Checks.Glide")) {
            return;
        }
        if (!e.getEntityType().isAlive()) {
            return;
        }
        this.weaponHandler.useTrigger((LivingEntity)e.getEntity(), e.isGliding() ? TriggerType.START_GLIDE : TriggerType.END_GLIDE, false);
    }
}

