/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.listeners;

import java.util.Map;
import me.deecaad.core.events.EntityEquipmentEvent;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.MetadataKey;
import me.deecaad.weaponmechanics.weapon.WeaponHandler;
import me.deecaad.weaponmechanics.weapon.damage.AssistData;
import me.deecaad.weaponmechanics.weapon.info.WeaponInfoDisplay;
import me.deecaad.weaponmechanics.weapon.stats.WeaponStat;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponAssistEvent;
import me.deecaad.weaponmechanics.weapon.weaponevents.WeaponEquipEvent;
import me.deecaad.weaponmechanics.wrappers.EntityWrapper;
import me.deecaad.weaponmechanics.wrappers.HandData;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import me.deecaad.weaponmechanics.wrappers.StatsData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class WeaponListeners
implements Listener {
    private WeaponHandler weaponHandler;

    public WeaponListeners(WeaponHandler weaponHandler) {
        this.weaponHandler = weaponHandler;
    }

    @EventHandler
    public void equip(EntityEquipmentEvent e) {
        if (e.isArmor()) {
            return;
        }
        LivingEntity entity = (LivingEntity)e.getEntity();
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper(entity);
        ItemStack weaponStack = e.getEquipped();
        String weaponTitle = this.weaponHandler.getInfoHandler().getWeaponTitle(weaponStack, true);
        boolean alreadyUsedEquipMechanics = false;
        boolean mainhand = e.getSlot() == EquipmentSlot.HAND;
        HandData handData = mainhand ? entityWrapper.getMainHandData() : entityWrapper.getOffHandData();
        handData.setCurrentWeaponTitle(weaponTitle);
        if (weaponTitle != null) {
            if (e.getEntityType() == EntityType.PLAYER) {
                WeaponInfoDisplay weaponInfoDisplay;
                PlayerWrapper playerWrapper = (PlayerWrapper)entityWrapper;
                if (playerWrapper.getStatsData() != null) {
                    playerWrapper.getStatsData().add(weaponTitle, WeaponStat.EQUIP_TIMES, 1);
                }
                if ((weaponInfoDisplay = (WeaponInfoDisplay)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Info_Display", WeaponInfoDisplay.class)) != null) {
                    weaponInfoDisplay.send(playerWrapper, e.getSlot(), (ItemStack)(mainhand ? weaponStack : null), (ItemStack)(!mainhand ? weaponStack : null));
                }
            }
            this.weaponHandler.getSkinHandler().tryUse(entityWrapper, weaponTitle, weaponStack, e.getSlot());
            Mechanics equipMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Info.Weapon_Equip_Mechanics", Mechanics.class);
            if (equipMechanics != null) {
                equipMechanics.use(new CastData(entity, weaponTitle, weaponStack));
                alreadyUsedEquipMechanics = true;
            }
            handData.setLastEquipTime(System.currentTimeMillis());
            Bukkit.getPluginManager().callEvent((Event)new WeaponEquipEvent(weaponTitle, weaponStack, entity, e.getSlot() == EquipmentSlot.HAND));
        } else {
            handData.cancelTasks(false);
        }
        ItemStack dequipped = e.getDequipped();
        String dequippedWeapon = this.weaponHandler.getInfoHandler().getWeaponTitle(dequipped, false);
        if (dequippedWeapon != null) {
            Mechanics holsterMechanics;
            if (!alreadyUsedEquipMechanics && (holsterMechanics = (Mechanics)WeaponMechanics.getConfigurations().getObject(dequippedWeapon + ".Info.Weapon_Holster_Mechanics", Mechanics.class)) != null) {
                holsterMechanics.use(new CastData(entity, dequippedWeapon, dequipped));
            }
            this.weaponHandler.getSkinHandler().tryUse(entityWrapper, dequippedWeapon, dequipped, e.getSlot(), true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void itemHeld(PlayerItemHeldEvent e) {
        Player player = e.getPlayer();
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper((LivingEntity)player);
        entityWrapper.getMainHandData().cancelTasks();
        EntityEquipment entityEquipment = player.getEquipment();
        ItemStack nextSlot = player.getInventory().getItem(e.getNewSlot());
        if (entityEquipment.getItemInOffHand().getType() != Material.AIR && nextSlot != null && nextSlot.getType() != Material.AIR) {
            entityWrapper.getOffHandData().cancelTasks(true);
        }
    }

    @EventHandler
    public void death(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (MetadataKey.ASSIST_DATA.has((Entity)entity)) {
            AssistData allData = (AssistData)MetadataKey.ASSIST_DATA.get((Entity)entity).get(0).value();
            Map<Player, Map<String, AssistData.DamageInfo>> assistData = allData.getAssists(entity.getKiller());
            if (assistData != null) {
                assistData.forEach((player, data) -> {
                    StatsData statsData = WeaponMechanics.getPlayerWrapper(player).getStatsData();
                    if (statsData != null) {
                        if (entity.getType() == EntityType.PLAYER) {
                            data.keySet().forEach(weaponTitle -> statsData.add((String)weaponTitle, WeaponStat.PLAYER_ASSISTS, 1));
                        } else {
                            data.keySet().forEach(weaponTitle -> statsData.add((String)weaponTitle, WeaponStat.OTHER_ASSISTS, 1));
                        }
                    }
                    Bukkit.getPluginManager().callEvent((Event)new WeaponAssistEvent((Player)player, entity, (Map<String, AssistData.DamageInfo>)data));
                });
            }
            MetadataKey.ASSIST_DATA.remove((Entity)entity);
        }
    }

    @EventHandler
    public void quit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        if (!MetadataKey.ASSIST_DATA.has((Entity)player)) {
            return;
        }
        MetadataKey.ASSIST_DATA.remove((Entity)player);
    }

    @EventHandler
    public void unload(ChunkUnloadEvent e) {
        if (WeaponMechanics.getBasicConfigurations().getBool("Assists_Event.Only_Players", true)) {
            return;
        }
        for (Entity entity : e.getChunk().getEntities()) {
            if (!MetadataKey.ASSIST_DATA.has(entity)) continue;
            MetadataKey.ASSIST_DATA.remove(entity);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void click(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        ClickType clickType = e.getClick();
        if (clickType == ClickType.DROP || clickType == ClickType.CONTROL_DROP || e.getSlot() == -999) {
            playerWrapper.inventoryDrop();
        }
        if (e.getSlotType() != InventoryType.SlotType.QUICKBAR) {
            return;
        }
        playerWrapper.getMainHandData().cancelTasks(true);
        playerWrapper.getOffHandData().cancelTasks(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void swapHandItems(PlayerSwapHandItemsEvent e) {
        EntityWrapper entityWrapper = WeaponMechanics.getEntityWrapper((LivingEntity)e.getPlayer());
        entityWrapper.getMainHandData().cancelTasks();
        entityWrapper.getOffHandData().cancelTasks();
    }
}

