/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;

public class ResourcePackListener
implements Listener {
    private String resourcePackVersion;
    private String resourcePackLink;

    public ResourcePackListener() {
        try {
            String link = "https://api.github.com/repos/WeaponMechanics/MechanicsMain/releases/latest";
            URL url = new URL(link);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(30000);
            InputStream in = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray assets = json.getAsJsonArray("assets");
            for (JsonElement asset : assets) {
                String[] split;
                String fileName = asset.getAsJsonObject().get("name").getAsString();
                if (!fileName.startsWith("WeaponMechanicsResourcePack") || (split = fileName.split("-")).length <= 1) continue;
                String version = split[1];
                if (version.endsWith(".zip")) {
                    version = version.substring(0, version.length() - 4);
                }
                this.resourcePackVersion = version;
                break;
            }
        }
        catch (IOException ex) {
            WeaponMechanics.debug.log(LogLevel.DEBUG, "Failed to fetch resource pack version due to timeout", (Throwable)ex);
        }
        if (this.resourcePackVersion == null) {
            WeaponMechanics.debug.warn(new String[]{"Failed to fetch resource pack version! Enable debug mode for more logs."});
        } else {
            this.resourcePackLink = "https://raw.githubusercontent.com/WeaponMechanics/MechanicsMain/master/resourcepack/WeaponMechanicsResourcePack-" + this.resourcePackVersion + ".zip";
        }
    }

    public String getResourcePackVersion() {
        return this.resourcePackVersion;
    }

    public String getResourcePackLink() {
        return this.resourcePackLink;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!WeaponMechanics.getBasicConfigurations().getBool("Resource_Pack_Download.Automatically_Send_To_Player")) {
            return;
        }
        String link = WeaponMechanics.getBasicConfigurations().getString("Resource_Pack_Download.Link");
        if (link == null || link.isEmpty()) {
            WeaponMechanics.debug.warn(new String[]{"Resource_Pack_Download Link was missing in the config.yml!", "If you don't want to send players the resource pack, please disable Automatically_Send_To_Player instead!"});
            return;
        }
        if ("https://raw.githubusercontent.com/WeaponMechanics/MechanicsMain/master/WeaponMechanicsResourcePack.zip".equals(link)) {
            Bukkit.getScheduler().runTaskLater(WeaponMechanics.getPlugin(), () -> player.setResourcePack(this.resourcePackLink), 10L);
            return;
        }
        WeaponMechanics.debug.debug(new String[]{"Sending " + player.getName() + " resource pack: " + link});
        player.setResourcePack(link);
    }

    @EventHandler
    public void onPack(PlayerResourcePackStatusEvent event) {
        PlayerResourcePackStatusEvent.Status status;
        Player player = event.getPlayer();
        if (WeaponMechanics.getBasicConfigurations().getBool("Resource_Pack_Download.Force_Player_Download") && ((status = event.getStatus()) == PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD || status == PlayerResourcePackStatusEvent.Status.DECLINED)) {
            String message = WeaponMechanics.getBasicConfigurations().getString("Resource_Pack_Download.Kick_Message");
            player.kickPlayer(StringUtil.colorBukkit((String)message));
        }
    }
}

