/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.listeners;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.file.BukkitConfig;
import me.deecaad.core.file.ConfigLike;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.SerializeData;
import me.deecaad.core.file.Serializer;
import me.deecaad.core.file.SerializerException;
import me.deecaad.core.file.serializers.ItemSerializer;
import me.deecaad.core.mechanics.CastData;
import me.deecaad.core.mechanics.Mechanics;
import me.deecaad.core.utils.FileUtil;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.shoot.CustomDurability;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class RepairItemListener
implements Listener {
    private static RepairItemListener INSTANCE = null;
    public final Map<String, RepairKit> repairKits;

    public static RepairItemListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RepairItemListener();
        }
        return INSTANCE;
    }

    private RepairItemListener() {
        File repairKitFolder = new File(WeaponMechanics.getPlugin().getDataFolder(), "repair_kits");
        this.repairKits = new HashMap<String, RepairKit>();
        try {
            if (!repairKitFolder.exists()) {
                FileUtil.copyResourcesTo((URL)this.getClass().getClassLoader().getResource("WeaponMechanics/repair_kits"), (Path)repairKitFolder.toPath());
            }
            FileUtil.PathReference pathReference = FileUtil.PathReference.of((URI)repairKitFolder.toURI());
            Files.walkFileTree(pathReference.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    YamlConfiguration config;
                    InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                    if (file.endsWith("readme.txt")) {
                        WeaponMechanics.debug.debug(new String[]{"Found readme.txt at '" + file + "', skipping."});
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        config = new YamlConfiguration();
                        config.load((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                    catch (InvalidConfigurationException ex) {
                        WeaponMechanics.debug.log(LogLevel.WARN, new String[]{"Could not read file '" + file.toFile() + "'... make sure it is a valid YAML file"});
                        return FileVisitResult.CONTINUE;
                    }
                    for (String key : config.getKeys(false)) {
                        try {
                            SerializeData data = new SerializeData((Serializer)new RepairKit(), file.toFile(), key, (ConfigLike)new BukkitConfig((ConfigurationSection)config));
                            RepairKit repairKit = (RepairKit)data.of().serialize(RepairKit.class);
                            if (RepairItemListener.this.repairKits.containsKey(key)) {
                                throw data.exception(null, new String[]{"Found duplicate Repair Kit name '" + key + "'"});
                            }
                            RepairItemListener.this.repairKits.put(key, repairKit);
                        }
                        catch (SerializerException ex) {
                            ex.log(WeaponMechanics.debug);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            WeaponMechanics.debug.log(LogLevel.ERROR, "Some error occurred whilst reading repair_kits folder", e);
        }
        WeaponMechanics.debug.info(new String[]{"Registered " + this.repairKits.size() + " RepairKits"});
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event instanceof InventoryCreativeEvent) {
            WeaponMechanics.debug.debug(new String[]{"Cannot use InventoryCreativeEvent for repair item"});
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory instanceof PlayerInventory) {
            String weaponTitle;
            PlayerInventory inventory2 = (PlayerInventory)inventory;
            if (!event.getWhoClicked().equals(inventory2.getHolder())) {
                return;
            }
            ItemStack weapon = inventory2.getItem(event.getSlot());
            String string = weaponTitle = weapon == null ? null : CustomTag.WEAPON_TITLE.getString(weapon);
            if (weapon == null) {
                return;
            }
            if (CustomTag.BROKEN_WEAPON.hasString(weapon)) {
                this.repairBrokenItem(event);
            } else {
                if (weaponTitle == null || event.getCursor() == null) {
                    return;
                }
                Configuration config = WeaponMechanics.getConfigurations();
                CustomDurability customDurability = (CustomDurability)config.getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class);
                if (customDurability != null && customDurability.isRepairOnlyBroken()) {
                    return;
                }
                CastData cast = new CastData((LivingEntity)event.getWhoClicked(), weaponTitle, weapon);
                this.repair(weapon, weaponTitle, event.getCursor(), cast);
            }
        }
    }

    public void repairBrokenItem(InventoryClickEvent event) {
        ItemStack weapon = event.getClickedInventory().getItem(event.getSlot());
        String weaponTitle = CustomTag.BROKEN_WEAPON.getString(weapon);
        CastData cast = new CastData((LivingEntity)event.getWhoClicked(), weaponTitle, weapon);
        boolean isConsumedItem = this.repair(weapon, weaponTitle, event.getCursor(), cast);
        if (!isConsumedItem) {
            return;
        }
        ItemStack weaponTemplate = WeaponMechanics.getWeaponHandler().getInfoHandler().generateWeapon(weaponTitle, 1);
        if (weaponTemplate == null) {
            WeaponMechanics.debug.debug(new String[]{event.getWhoClicked() + " has old configuration of weapon '" + weaponTitle + "'"});
            return;
        }
        CompatibilityAPI.getNBTCompatibility().copyTagsFromTo(weapon, weaponTemplate, "PublicBukkitValues");
        weapon.setType(weaponTemplate.getType());
        weapon.setItemMeta(weaponTemplate.getItemMeta());
        CustomTag.WEAPON_TITLE.setString(weapon, weaponTitle);
        CustomTag.BROKEN_WEAPON.remove(weapon);
    }

    public boolean repair(ItemStack weapon, String weaponTitle, ItemStack repairItem, CastData cast) {
        int durability;
        String repairKitTitle;
        Configuration config = WeaponMechanics.getConfigurations();
        CustomDurability customDurability = (CustomDurability)config.getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class);
        if (customDurability == null) {
            return false;
        }
        String string = repairKitTitle = repairItem.hasItemMeta() ? CustomTag.REPAIR_KIT_TITLE.getString(repairItem) : null;
        if (repairKitTitle != null) {
            RepairKit kit = this.repairKits.get(repairKitTitle);
            if (kit == null) {
                WeaponMechanics.debug.debug(new String[]{"RepairKit '" + repairKitTitle + "' no longer exists."});
                return false;
            }
            if (!kit.canUseWeapon(weaponTitle)) {
                return false;
            }
            int durability2 = CustomTag.DURABILITY.getInteger(weapon);
            int maxDurability = customDurability.getMaxDurability(weapon);
            int availableRepair = CustomTag.DURABILITY.getInteger(repairItem);
            if (durability2 + availableRepair > maxDurability) {
                int consume = maxDurability - durability2;
                CustomTag.DURABILITY.setInteger(weapon, maxDurability);
                CustomTag.DURABILITY.setInteger(repairItem, availableRepair - consume);
            } else {
                CustomTag.DURABILITY.setInteger(weapon, durability2 + availableRepair);
                repairItem.setAmount(0);
                if (kit.getBreakMechanics() != null) {
                    kit.getBreakMechanics().use(cast);
                }
            }
            if (kit.consumeOnUse) {
                repairItem.setAmount(0);
            }
            customDurability.modifyMaxDurability(weapon, kit.getOverrideMaxDurabilityLoss());
            return true;
        }
        int availableItems = repairItem.getAmount();
        repairItem.setAmount(1);
        if (!customDurability.getRepairItems().containsKey(repairItem)) {
            repairItem.setAmount(availableItems);
            return false;
        }
        int repairPerItem = customDurability.getRepairItems().get(repairItem);
        repairItem.setAmount(availableItems);
        int maxDurability = customDurability.getMaxDurability(weapon);
        if (maxDurability <= 0 || durability >= maxDurability) {
            if (customDurability.getDenyRepairMechanics() != null) {
                customDurability.getDenyRepairMechanics().use(cast);
            }
            return false;
        }
        for (durability = CustomTag.DURABILITY.getInteger(weapon); availableItems > 0 && durability < maxDurability; durability += repairPerItem, --availableItems) {
            maxDurability = customDurability.modifyMaxDurability(weapon);
        }
        repairItem.setAmount(availableItems);
        CustomTag.DURABILITY.setInteger(weapon, Math.min(maxDurability, durability));
        if (customDurability.getRepairMechanics() != null) {
            customDurability.getRepairMechanics().use(cast);
        }
        return true;
    }

    @EventHandler
    public void onExp(PlayerExpChangeEvent event) {
        int availableExp;
        Configuration config;
        CustomDurability customDurability;
        String weaponTitle;
        ItemStack weapon = event.getPlayer().getInventory().getItemInMainHand();
        String string = weaponTitle = !weapon.hasItemMeta() ? null : CustomTag.WEAPON_TITLE.getString(weapon);
        if (weaponTitle == null) {
            weapon = event.getPlayer().getInventory().getItemInOffHand();
            String string2 = weaponTitle = !weapon.hasItemMeta() ? null : CustomTag.WEAPON_TITLE.getString(weapon);
            if (weaponTitle == null) {
                return;
            }
        }
        if ((customDurability = (CustomDurability)(config = WeaponMechanics.getConfigurations()).getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class)) == null) {
            return;
        }
        int durability = CustomTag.DURABILITY.getInteger(weapon);
        int maxDurability = customDurability.getMaxDurability(weapon);
        for (availableExp = event.getAmount(); availableExp > 0 && durability < maxDurability; durability += customDurability.getRepairPerExp(), --availableExp) {
        }
        event.setAmount(availableExp);
        CustomTag.DURABILITY.setInteger(weapon, Math.min(maxDurability, durability));
    }

    public static class RepairKit
    implements Serializer<RepairKit> {
        private ItemStack item;
        private int totalDurability;
        private int overrideMaxDurabilityLoss;
        private boolean blacklist;
        private Set<String> weapons;
        private Set<String> armors;
        private Mechanics breakMechanics;
        private boolean consumeOnUse;

        public RepairKit() {
        }

        public RepairKit(ItemStack item, int totalDurability, int overrideMaxDurabilityLoss, boolean blacklist, Set<String> weapons, Set<String> armors, Mechanics breakMechanics, boolean consumeOnUse) {
            this.item = item;
            this.totalDurability = totalDurability;
            this.overrideMaxDurabilityLoss = overrideMaxDurabilityLoss;
            this.blacklist = blacklist;
            this.weapons = weapons;
            this.armors = armors;
            this.breakMechanics = breakMechanics;
            this.consumeOnUse = consumeOnUse;
        }

        public ItemStack getItem() {
            return this.item.clone();
        }

        public int getTotalDurability() {
            return this.totalDurability;
        }

        public int getOverrideMaxDurabilityLoss() {
            return this.overrideMaxDurabilityLoss;
        }

        public boolean isBlacklist() {
            return this.blacklist;
        }

        public Set<String> getWeapons() {
            return this.weapons;
        }

        public Set<String> getArmors() {
            return this.armors;
        }

        public Mechanics getBreakMechanics() {
            return this.breakMechanics;
        }

        public boolean isConsumeOnUse() {
            return this.consumeOnUse;
        }

        public void setConsumeOnUse(boolean consumeOnUse) {
            this.consumeOnUse = consumeOnUse;
        }

        public boolean canUseWeapon(String weaponTitle) {
            return this.isBlacklist() != this.weapons.contains(weaponTitle);
        }

        public boolean canUseArmor(String armorTitle) {
            return this.isBlacklist() != this.armors.contains(armorTitle);
        }

        @NotNull
        public RepairKit serialize(@NotNull SerializeData data) throws SerializerException {
            String repairKitTitle = data.key.split("\\.")[0];
            int totalDurability = data.of("Total_Durability").assertPositive().assertExists().getInt();
            int overrideMaxDurabilityLoss = data.of("Override_Max_Durability_Loss").assertPositive().getInt(-1);
            boolean blacklist = data.of("Blacklist").getBool(false);
            Set<String> weapons = data.ofList("Weapons").addArgument(String.class, true).assertList().stream().map(arr -> arr[0]).collect(Collectors.toSet());
            Set<String> armors = data.ofList("Armors").addArgument(String.class, true).assertList().stream().map(arr -> arr[0]).collect(Collectors.toSet());
            data.of("Item").assertExists();
            Map<String, String> tags = Map.of(CustomTag.DURABILITY.getKey(), totalDurability, CustomTag.REPAIR_KIT_TITLE.getKey(), repairKitTitle);
            ItemStack item = new ItemSerializer().serializeWithTags(data.move("Item"), tags);
            Mechanics breakMechanics = (Mechanics)data.of("Break_Mechanics").serialize(Mechanics.class);
            boolean consumeOnUse = data.of("Consume_On_Use").getBool(false);
            return new RepairKit(item, totalDurability, overrideMaxDurabilityLoss, blacklist, weapons, armors, breakMechanics, consumeOnUse);
        }
    }
}

