/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.lib;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.WeaponMechanicsAPI;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MythicMobsWeaponShootSkill
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private final String weaponTitle;
    private final double spread;
    private final boolean targetHead;

    public MythicMobsWeaponShootSkill(MythicLineConfig config) {
        String weaponTitle = config.getString(new String[]{"weaponTitle", "weapon"});
        this.spread = Math.toRadians(config.getDouble(new String[]{"spread"}, 0.0));
        this.targetHead = config.getBoolean("head", true);
        try {
            weaponTitle = WeaponMechanics.getWeaponHandler().getInfoHandler().getWeaponTitle(weaponTitle);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.weaponTitle = weaponTitle;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }

    public boolean getTargetsSpectators() {
        return false;
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        Location target;
        Entity entity = abstractEntity.getBukkitEntity();
        if (this.targetHead && entity.getType().isAlive()) {
            target = ((LivingEntity)entity).getEyeLocation();
        } else {
            target = entity.getLocation();
            target.setY(target.getY() + entity.getHeight() / 2.0);
        }
        return this.castAtLocation(skillMetadata, BukkitAdapter.adapt((Location)target));
    }

    public SkillResult castAtLocation(SkillMetadata skillMetadata, AbstractLocation abstractLocation) {
        Entity entity = skillMetadata.getCaster().getEntity().getBukkitEntity();
        if (entity == null) {
            return SkillResult.ERROR;
        }
        if (!entity.getType().isAlive()) {
            return SkillResult.ERROR;
        }
        Location target = BukkitAdapter.adapt((AbstractLocation)abstractLocation);
        if (this.spread != 0.0) {
            double delta = Math.tan(this.spread) * entity.getLocation().distance(target);
            target.setX(target.getX() + RandomUtil.range((double)(-delta), (double)delta));
            target.setY(target.getY() + RandomUtil.range((double)(-delta), (double)delta));
            target.setZ(target.getZ() + RandomUtil.range((double)(-delta), (double)delta));
        }
        WeaponMechanicsAPI.shoot((LivingEntity)entity, this.weaponTitle, target);
        return SkillResult.SUCCESS;
    }
}

