/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.lib;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import java.util.HashSet;
import java.util.Set;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class MythicMobsArmedCondition
implements IEntityCondition {
    private final boolean wildcard;
    private final Set<String> weapons = new HashSet<String>();

    public MythicMobsArmedCondition(MythicLineConfig config) {
        String weapons = config.getString(new String[]{"weapons", "weapon", "title", "weaponTitle", "w"}, "*", new String[0]);
        this.wildcard = "*".equals(weapons.trim());
        if (this.wildcard) {
            return;
        }
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        for (String title : weapons.split(", ?")) {
            this.weapons.add(info.getWeaponTitle(title));
        }
    }

    public boolean check(AbstractEntity abstractEntity) {
        String offTitle;
        LivingEntity entity = (LivingEntity)abstractEntity.getBukkitEntity();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            return false;
        }
        ItemStack main = equipment.getItemInMainHand();
        ItemStack off = equipment.getItemInOffHand();
        String mainTitle = main.hasItemMeta() ? CustomTag.WEAPON_TITLE.getString(main) : null;
        String string = offTitle = off.hasItemMeta() ? CustomTag.WEAPON_TITLE.getString(off) : null;
        if (this.wildcard) {
            return mainTitle != null || offTitle != null;
        }
        return mainTitle != null && this.weapons.contains(mainTitle) || offTitle != null && this.weapons.contains(offTitle);
    }
}

