/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.lib.CrackShotConvert;

import com.shampaggon.crackshot.MaterialManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import me.DeeCaaD.CrackShotPlus.CSPapi;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class CrackShotPlusConverter {
    public void convertOneKey(YamlConfiguration configuration, String key, YamlConfiguration outputConfiguration) {
        for (Paths path : Paths.values()) {
            path.convert(key + "." + path.from, key + "." + path.to, path.type, configuration, outputConfiguration);
        }
    }

    private static String getMaterial(String type) {
        if (type == null) {
            return null;
        }
        try {
            Material material = MaterialManager.getMaterial((String)type);
            if (material != null) {
                return material.name();
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            try {
                return Material.valueOf((String)type.toUpperCase(Locale.ROOT)).name();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String materialName = StringUtil.didYouMean((String)type, (Iterable)EnumUtil.getOptions(Material.class));
        WeaponMechanics.debug.error(new String[]{"Invalid material: " + type + " swapped to: " + materialName});
        return materialName;
    }

    private static String getBossBarStyle(String type) {
        if (type == null) {
            return null;
        }
        if ("SOLID".equals(type = type.trim().toUpperCase(Locale.ROOT))) {
            return "PROGRESS";
        }
        return "NOTCHED_" + type.substring("SEGMENTED_".length());
    }

    private static enum Paths {
        TITLE_SHOOTER_HEAD("Damage.Title_And_Subtitle.Shooter.Headshot", "Damage.Head.Mechanics", Type.STR, new TitleConvert(false)),
        TITLE_VICTIM_HEAD("Damage.Title_And_Subtitle.Victim.Headshot", "Damage.Head.Mechanics", Type.STR, new TitleConvert(true)),
        TITLE_SHOOTER_BACK("Damage.Title_And_Subtitle.Shooter.Backstab", "Damage.Backstab.Mechanics", Type.STR, new TitleConvert(false)),
        TITLE_VICTIM_BACK("Damage.Title_And_Subtitle.Victim.Backstab", "Damage.Backstab.Mechanics", Type.STR, new TitleConvert(true)),
        TITLE_SHOOTER_CRIT("Damage.Title_And_Subtitle.Shooter.Critical_Hit", "Damage.Critical_Hit.Mechanics", Type.STR, new TitleConvert(false)),
        TITLE_VICTIM_CRIT("Damage.Title_And_Subtitle.Victim.Critical_Hit", "Damage.Critical_Hit.Mechanics", Type.STR, new TitleConvert(true)),
        TITLE_SHOOTER_HIT("Damage.Title_And_Subtitle.Shooter.Hit", "Damage.Mechanics", Type.STR, new TitleConvert(false)),
        TITLE_VICTIM_HIT("Damage.Title_And_Subtitle.Victim.Hit", "Damage.Mechanics", Type.STR, new TitleConvert(true)),
        SPAWN_FIREWORK("Damage.Spawn_Firework.", "Damage.Mechanics", Type.STR, new FireworkConvert(true)),
        SOUNDS_SHOOTER_HEAD("Damage.Custom_Sounds.Shooter_Location.Headshot", "Damage.Head.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_VICTIM_HEAD("Damage.Custom_Sounds.Victim_Location.Headshot", "Damage.Head.Mechanics", Type.STR, new CustomSoundConvert(true)),
        SOUNDS_SHOOTER_BACK("Damage.Custom_Sounds.Shooter_Location.Backstab", "Damage.Backstab.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_VICTIM_BACK("Damage.Custom_Sounds.Victim_Location.Backstab", "Damage.Backstab.Mechanics", Type.STR, new CustomSoundConvert(true)),
        SOUNDS_SHOOTER_CRIT("Damage.Custom_Sounds.Shooter_Location.Critical_Hit", "Damage.Critical_Hit.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_VICTIM_CRIT("Damage.Custom_Sounds.Victim_Location.Critical_Hit", "Damage.Critical_Hit.Mechanics", Type.STR, new CustomSoundConvert(true)),
        SOUNDS_SHOOTER_HIT("Damage.Custom_Sounds.Shooter_Location.Hit", "Damage.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_VICTIM_HIT("Damage.Custom_Sounds.Victim_Location.Hit", "Damage.Mechanics", Type.STR, new CustomSoundConvert(true)),
        COMMAND_SHOOTER_HEAD("Damage.Run_Command.Headshot.Command", "Damage.Head.Mechanics", Type.STR, new CommandConvert()),
        COMMAND_SHOOTER_BACK("Damage.Run_Command.Backstab.Command", "Damage.Backstab.Mechanics", Type.STR, new CommandConvert()),
        COMMAND_SHOOTER_CRIT("Damage.Run_Command.Critical_Hit.Command", "Damage.Critical_Hit.Mechanics", Type.STR, new CommandConvert()),
        COMMAND_SHOOTER_HIT("Damage.Run_Command.Hit.Command", "Damage.Mechanics", Type.STR, new CommandConvert()),
        SOUNDS_AIRSTRIKE("Explode.Custom_Sounds.Explode_Location.Airstrike", "Explosion.Airstrike.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_SPLIT("Explode.Custom_Sounds.Explode_Location.Split", "Explosion.Cluster_Bomb.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_EXPLODE("Explode.Custom_Sounds.Explode_Location.Explode", "Explosion.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_HELD("Held.Custom_Held_Sound", "Info.Weapon_Equip_Mechanics", Type.STR, new CustomSoundConvert()),
        WEAPON_WEIGHT("Held.Weapon_Weight", "Info.Weapon_Item.Attributes", Type.DOUBLE, new GeneralObjectModifier(x -> Collections.singletonList("GENERIC_MOVEMENT_SPEED-" + x))),
        HIDE_ATTRIBUTES("Held.Hide_Attributes", "Info.Weapon_Item.Hide_Flags", Type.BOOL),
        DURABILITY("Held.Durability", "Info.Weapon_Item.Durability", Type.INT),
        CUSTOM_MODEL_DATA("Held.Custom_Model_Data", "Info.Weapon_Item.Custom_Model_Data", Type.INT),
        UPDATE_LORE("Held.Update_Lore.Lore", "Info.Weapon_Item.Lore", Type.LIST),
        COMMAND_SHOOTER_KILL("Kill.Command.Run_Command", "Damage.Kill.Mechanics", Type.STR, new CommandConvert()),
        TITLE_SHOOTER_KILL("Kill.Title_And_Subtitle", "Damage.Kill.Mechanics", Type.STR, new TitleConvert(false)),
        KILLFEED("Kill.Killfeed.", "Damage.Kill.Mechanics", Type.STR, new KillfeedConvert()),
        SOUNDS_PRE_RELOAD_START("Reload.Custom_Pre_Reload_Sound", "Reload.Start_Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_RELOAD_START("Reload.Custom_Reload_Sound", "Reload.Start_Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_RELOAD_COMPLETE("Reload.Custom_Reload_Complete_Sound", "Reload.Finish_Mechanics", Type.STR, new CustomSoundConvert()),
        COMMAND_RELOAD_START("Reload.Reload_Run_Command", "Reload.Start_Mechanics", Type.STR, new CommandConvert()),
        COMMAND_RELOAD_COMPLETE("Reload.Reload_Complete_Run_Command", "Reload.Finish_Mechanics", Type.STR, new CommandConvert()),
        SOUNDS_SCOPE("Scope.Custom_Scope_Sound", "Scope.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_SCOPE_END("Scope.Custom_Scope_End_Sound", "Scope.Zoom_Off.Mechanics", Type.STR, new CustomSoundConvert()),
        SECOND_ZOOM_STACKS("Scope.Second_Zoom.Amount", "Scope.Zoom_Stacking.Stacks", Type.INT, new GeneralObjectModifier(x -> Collections.singletonList(NumberUtil.lerp((double)1.0, (double)5.0, (double)((Integer)x > 6 ? 6.0 : (double)((Integer)x).intValue() / 6.0))))),
        INVISIBLE_PROJECTILES("Shoot.Invisible_Projectiles", "Projectile.Projectile_Settings.Type", Type.BOOL, new GeneralObjectModifier(x -> "INVISIBLE")),
        SOUNDS_PREPARE_SHOOT("Shoot.Custom_Prepare_Shoot_Sound", "Shoot.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_PRE_SHOOT("Shoot.Custom_Pre_Shoot_Sound", "Shoot.Mechanics", Type.STR, new CustomSoundConvert()),
        SOUNDS_SHOOT("Shoot.Custom_Shoot_Sound", "Shoot.Mechanics", Type.STR, new CustomSoundConvert()),
        COMMAND_SHOOT("Shoot.Shoot_Run_Command", "Shoot.Mechanics", Type.STR, new CommandConvert()),
        BOUNCING_PROJECTILES("Shoot.Bouncing_Projectiles.", "Projectile.Bouncy.", Type.STR, new BouncingProjectilesConvert()),
        CAMERA_RECOIL("Shoot.Camera_Recoil.", "Shoot.Recoil.", Type.DOUBLE, new CameraRecoilConvert()),
        SKIN("Skin.Default_Skin", "Skin.", Type.STR, new SkinConvert()),
        TRAIL("Shoot.Trails.Default_Trail", "Trail.", Type.STR, new TrailConvert()),
        BLOCK_CRACK("Hit_Block.Break_Blocks", "Cosmetics.Block_Damage.", Type.STR, new BlockDamageConvert()),
        VISUAL_RELOAD("Reload.Visual_Reload.Default_Visual_Reload", "Show_Time.Reload.", Type.STR, new VisualReloadConvert()),
        DUMMY(null, null, Type.STR);

        private final String from;
        private final String to;
        private final Type type;
        private final Converter converter;

        private Paths(String from, String to, Type type) {
            this.from = from;
            this.to = to;
            this.type = type;
            this.converter = new ValueConvert();
        }

        private Paths(String from, String to, Type type, Converter converter) {
            this.from = from;
            this.to = to;
            this.type = type;
            this.converter = converter;
        }

        private void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            this.converter.convert(from, to, type, fromConfig, toConfig);
        }
    }

    private static enum Type {
        BOOL,
        STR,
        INT,
        DOUBLE,
        LIST;


        Object get(String key) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BOOL -> CSPapi.getBoolean((String)key);
                case STR -> CSPapi.getString((String)key);
                case INT -> CSPapi.getInteger((String)key);
                case DOUBLE -> CSPapi.getDouble((String)key);
                case LIST -> CSPapi.getList((String)key);
            };
        }
    }

    private static class VisualReloadConvert
    implements Converter {
        private VisualReloadConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String visualReload = CSPapi.getString((String)from);
            if (visualReload == null) {
                return;
            }
            String weapon = from.split("\\.")[0];
            String reloadPath = visualReload + ".";
            toConfig.set(to + "Action_Bar", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Reload_Message.Action_Bar"))));
            toConfig.set(to + "Title", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Reload_Message.Title"))));
            toConfig.set(to + "Subtitle", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Reload_Message.Subtitle"))));
            toConfig.set(to + "Boss_Bar.Message", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Reload_Message.Boss_Bar.Title"))));
            toConfig.set(to + "Boss_Bar.Color", (Object)CSPapi.getString((String)(reloadPath + "Reload_Message.Boss_Bar.Settings.Color")));
            toConfig.set(to + "Boss_Bar.Style", (Object)CrackShotPlusConverter.getBossBarStyle(CSPapi.getString((String)(reloadPath + "Reload_Message.Boss_Bar.Settings.Style"))));
            toConfig.set(to + "Action_Bar_Cancelled", (Object)"<red>Reload Cancelled");
            toConfig.set(to + "Exp", (Object)CSPapi.getString((String)(reloadPath + "Reload_Message.Exp")));
            toConfig.set(to + "Bar.Left_Color", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Left_Color"))));
            toConfig.set(to + "Bar.Right_Color", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Right_Color"))));
            toConfig.set(to + "Bar.Left_Symbol", (Object)VisualReloadConvert.convert(CSPapi.getString((String)(reloadPath + "Symbol"))));
            toConfig.set(to + "Bar.Symbol_Amount", (Object)CSPapi.getInteger((String)(reloadPath + "Symbol_Amount")));
        }

        private static String convert(String msg) {
            if (msg == null) {
                return null;
            }
            msg = msg.replaceAll("#[Bb][Aa][Rr]#", "%bar%");
            msg = msg.replaceAll("#[Tt][Ii][Mm][Ee]#", "%time%");
            return StringUtil.colorAdventure((String)msg);
        }
    }

    private static class BlockDamageConvert
    implements Converter {
        private BlockDamageConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            if (CSPapi.getString((String)(from + ".Blacklist")) == null) {
                String[] split = from.split("\\.");
                CharSequence[] copy = new String[split.length - 1];
                System.arraycopy(split, 0, copy, 0, copy.length);
                String path = String.join((CharSequence)".", copy);
                int min = fromConfig.getInt(path + ".Block_Crack_Animation.Minium_Crack", 0);
                int max = fromConfig.getInt(path + ".Block_Crack_Animation.Maxium_Crack", 0);
                if (min == 0 && max == 0) {
                    return;
                }
                toConfig.set(to + "Damage_Per_Hit", (Object)Math.max(1, min));
                toConfig.set(to + "Default_Block_Durability", (Object)Math.max(1, max));
                toConfig.set(to + "Blacklist", (Object)true);
                return;
            }
            toConfig.set(to + "Break_Blocks", (Object)true);
            toConfig.set(to + "Ticks_Before_Regenerate", (Object)CSPapi.getString((String)(from + ".Regen_Blocks_After_Milliseconds")));
            toConfig.set(to + "Blacklist", (Object)CSPapi.getBoolean((String)(from + ".Blacklist")));
            toConfig.set(to + "Block_List", (Object)CSPapi.getList((String)(from + ".Blocks_List")));
        }
    }

    private static class TrailConvert
    implements Converter {
        private TrailConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String defaultTrail = CSPapi.getString((String)from);
            if (defaultTrail == null) {
                return;
            }
            String[] defaultTrails = defaultTrail.split(",");
            Double d = CSPapi.getDouble((String)(defaultTrails[0] + ".Trail_Catch.Space_Between_Trails"));
            toConfig.set(to + "Distance_Between_Particles", (Object)(d == null ? 0.33 : d));
            toConfig.set(to + "Shape", (Object)"LINE");
            toConfig.set(to + "Particle_Chooser", (Object)"LOOP");
            List mechanics = toConfig.getStringList(to + "Particles");
            for (String trail : defaultTrails) {
                String cspTrail = CSPapi.getString((String)(trail + ".Trail"));
                if (cspTrail == null) {
                    WeaponMechanics.debug.error(new String[]{"Trail not found: " + from + " : " + to + " : trail(s)=" + defaultTrail});
                    continue;
                }
                String cspColor = CSPapi.getString((String)(trail + ".Trail_Color"));
                Integer cspCount = CSPapi.getInteger((String)(trail + ".Trail_Settings.Particle_Count"));
                StringBuilder builder = new StringBuilder("Particle{particle=%s".formatted(cspTrail));
                if (cspColor != null) {
                    builder.append(", color=%s".formatted(cspColor));
                }
                if (cspCount != null) {
                    builder.append(", count=%s".formatted(cspCount));
                }
                builder.append("}");
                mechanics.add(builder.toString());
            }
            toConfig.set(to + "Particles", (Object)mechanics);
        }
    }

    private static class SkinConvert
    implements Converter {
        private SkinConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            Integer scopeCustomModelData;
            Integer scopeDurability;
            String scopePath;
            String scopeType;
            Integer reloadCustomModelData;
            Integer reloadDurability;
            String reloadPath;
            String reloadType;
            Integer normalCustomModelData;
            Integer normalDurability;
            String defaultSkin = fromConfig.getString(from);
            if (defaultSkin == null) {
                return;
            }
            String weapon = from.split("\\.")[0];
            String skinPath = weapon + "_" + defaultSkin;
            String normalType = CSPapi.getString((String)(skinPath + ".Change_Item_Type"));
            if (normalType != null) {
                toConfig.set(to + ".Default.Type", (Object)CrackShotPlusConverter.getMaterial(normalType));
                toConfig.set(weapon + ".Info.Weapon_Item.Type", (Object)CrackShotPlusConverter.getMaterial(normalType));
            }
            if ((normalDurability = CSPapi.getInteger((String)(skinPath + ".Durability"))) != null) {
                toConfig.set(weapon + ".Info.Weapon_Item.Unbreakable", (Object)true);
                toConfig.set(to + ".Default.Durability", (Object)normalDurability);
                toConfig.set(weapon + ".Info.Weapon_Item.Durability", (Object)normalDurability);
            }
            if ((normalCustomModelData = CSPapi.getInteger((String)(skinPath + ".Custom_Model_Data"))) != null) {
                toConfig.set(to + ".Default.Custom_Model_Data", (Object)normalCustomModelData);
                toConfig.set(weapon + ".Info.Weapon_Item.Custom_Model_Data", (Object)normalCustomModelData);
            }
            if ((reloadType = CSPapi.getString((String)((reloadPath = skinPath + (CSPapi.getBoolean((String)(weapon + ".Reload.Reload_Skin")) != null && CSPapi.getBoolean((String)(weapon + ".Reload.Reload_Skin")) != false ? "_Reload" : ".Reload")) + ".Change_Item_Type"))) != null) {
                toConfig.set(to + ".Reload.Type", (Object)reloadType);
            }
            if ((reloadDurability = CSPapi.getInteger((String)(reloadPath + ".Durability"))) != null) {
                toConfig.set(weapon + ".Info.Weapon_Item.Unbreakable", (Object)true);
                toConfig.set(to + ".Reload.Durability", (Object)reloadDurability);
            }
            if ((reloadCustomModelData = CSPapi.getInteger((String)(reloadPath + ".Custom_Model_Data"))) != null) {
                toConfig.set(to + ".Reload.Custom_Model_Data", (Object)reloadCustomModelData);
            }
            if ((scopeType = CSPapi.getString((String)((scopePath = skinPath + (CSPapi.getBoolean((String)(weapon + ".Scope.Scope_Skin")) != null && CSPapi.getBoolean((String)(weapon + ".Scope.Scope_Skin")) != false ? "_Scope" : ".Scope")) + ".Change_Item_Type"))) != null) {
                toConfig.set(to + ".Scope.Type", (Object)scopeType);
            }
            if ((scopeDurability = CSPapi.getInteger((String)(scopePath + ".Durability"))) != null) {
                toConfig.set(weapon + ".Info.Weapon_Item.Unbreakable", (Object)true);
                toConfig.set(to + ".Scope.Durability", (Object)scopeDurability);
            }
            if ((scopeCustomModelData = CSPapi.getInteger((String)(scopePath + ".Custom_Model_Data"))) != null) {
                toConfig.set(to + ".Scope.Custom_Model_Data", (Object)scopeCustomModelData);
            }
        }
    }

    private static class CameraRecoilConvert
    implements Converter {
        private CameraRecoilConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            Double upMin = CSPapi.getDouble((String)(from + "Upwards.Minium"));
            Double upMax = CSPapi.getDouble((String)(from + "Upwards.Maxium"));
            ArrayList<Double> up = new ArrayList<Double>();
            if (upMin != null) {
                up.add(upMin);
            }
            if (upMax != null) {
                up.add(upMax);
            }
            Double sidMin = CSPapi.getDouble((String)(from + "Sideways.Minium"));
            Double sidMax = CSPapi.getDouble((String)(from + "Sideways.Maxium"));
            ArrayList<Double> sid = new ArrayList<Double>();
            if (sidMin != null) {
                sid.add(sidMin);
            }
            if (sidMax != null) {
                sid.add(sidMax);
            }
            if (!up.isEmpty()) {
                toConfig.set(to + "Vertical", up);
            }
            if (!sid.isEmpty()) {
                toConfig.set(to + "Horizontal", sid);
            }
        }
    }

    private static class BouncingProjectilesConvert
    implements Converter {
        private BouncingProjectilesConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            Double decreaseVelocityPerBounce;
            Integer bounceAmount = CSPapi.getInteger((String)(from + "Bounce_Amount"));
            if (bounceAmount == null) {
                return;
            }
            if (bounceAmount > 25) {
                bounceAmount = -1;
            }
            if ((decreaseVelocityPerBounce = CSPapi.getDouble((String)(from + "Decrese_Velocity_Per_Bounce"))) == null) {
                decreaseVelocityPerBounce = 0.6;
            }
            toConfig.set(to + "Maximum_Bounce_Amount", (Object)bounceAmount);
            toConfig.set(to + ".Blocks.Allow_Any", (Object)true);
            toConfig.set(to + ".Blocks.Default_Speed_Multiplier", (Object)decreaseVelocityPerBounce);
            toConfig.set(to + ".Entities.Allow_Any", (Object)true);
            toConfig.set(to + ".Entities.Default_Speed_Multiplier", (Object)decreaseVelocityPerBounce);
        }
    }

    private static class KillfeedConvert
    implements Converter {
        private KillfeedConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String barStyle;
            String barColor;
            String title = CSPapi.getString((String)(from + "Title"));
            if (title == null) {
                return;
            }
            title = title.replaceAll("#KILLED#", "%victim%").replaceAll("#KILLER#", "%shooter%").replaceAll(",", "\\\\,");
            Integer time = CSPapi.getInteger((String)(from + "Time"));
            if (time == null) {
                time = 60;
            }
            if ((barColor = CSPapi.getString((String)(from + "Bar.Color"))) == null) {
                barColor = "WHITE";
            }
            if ((barStyle = CSPapi.getString((String)(from + "Bar.Style"))) == null) {
                barStyle = "NOTCHED_20";
            }
            try {
                BossBar.Overlay.valueOf((String)barStyle);
            }
            catch (IllegalArgumentException e) {
                String temp = barStyle;
                barStyle = StringUtil.didYouMean((String)barStyle, (Iterable)EnumUtil.getOptions(BossBar.Overlay.class));
                WeaponMechanics.debug.error(new String[]{"Invalid boss bar style: " + temp + " swapped to: " + barStyle});
            }
            List mechanics = toConfig.getStringList(to);
            mechanics.add("BossBar{title=%s, color=%s, style=%s, time=%s} @ServerPlayers{}".formatted(title, barColor, barStyle, time));
            toConfig.set(to, (Object)mechanics);
        }
    }

    private record TitleConvert(boolean isTarget) implements Converter
    {
        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            Object title = type.get(from + ".Title");
            Object subtitle = type.get(from + ".Subtitle");
            if (title == null && subtitle == null) {
                return;
            }
            title = StringUtil.colorAdventure((String)((String)title));
            subtitle = StringUtil.colorAdventure((String)((String)subtitle));
            List mechanics = toConfig.getStringList(to);
            StringBuilder builder = new StringBuilder("Title{");
            if (title != null) {
                builder.append("title=%s".formatted(((String)title).replaceAll(",", "\\\\,")));
            }
            if (subtitle != null) {
                if (title != null) {
                    builder.append(", ");
                }
                builder.append("subtitle=%s".formatted(((String)subtitle).replaceAll(",", "\\\\,")));
            }
            builder.append("}");
            if (this.isTarget) {
                builder.append(" @Target{}");
            }
            mechanics.add(builder.toString());
            toConfig.set(to, (Object)mechanics);
        }
    }

    private record GeneralObjectModifier(Function<Object, Object> function) implements Converter
    {
        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            Object value = type.get(from);
            if (value == null) {
                return;
            }
            if (type == Type.BOOL && !((Boolean)value).booleanValue()) {
                return;
            }
            toConfig.set(to, this.function.apply(value));
        }
    }

    private record CommandConvert() implements Converter
    {
        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String value = CSPapi.getString((String)from);
            if (value == null) {
                return;
            }
            value = value.replaceAll("#DAMAGED#", "<target_name>").replaceAll("#PLAYER#", "<source_name>").replaceAll("#WEAPON#", "<weapon_title>").replaceAll("#KILLER#", "<source_name>").replaceAll("#KILLED#", "<target_name>");
            List mechanics = toConfig.getStringList(to);
            for (String command : value.split(",")) {
                if (command.startsWith("#C#")) {
                    mechanics.add("Command{command=%s, console=true}".formatted(command.replaceFirst("#C#", "")));
                    continue;
                }
                if (command.startsWith("#P#")) {
                    mechanics.add("Command{command=%s}".formatted(command.replaceFirst("#P#", "")));
                    continue;
                }
                if (!command.startsWith("#V#")) continue;
                mechanics.add("Command{command=%s} @Target{}".formatted(command.replaceFirst("#V#", "")));
            }
            if (!mechanics.isEmpty()) {
                toConfig.set(to, (Object)mechanics);
            }
        }
    }

    private static class CustomSoundConvert
    implements Converter {
        private final boolean isTarget;

        public CustomSoundConvert() {
            this.isTarget = false;
        }

        public CustomSoundConvert(boolean isTarget) {
            this.isTarget = isTarget;
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String customSounds = CSPapi.getString((String)from);
            if (customSounds == null) {
                return;
            }
            List mechanics = toConfig.getStringList(to);
            for (String sound : customSounds.replaceAll(" ", "").split(",")) {
                String pitch;
                String[] splitted = sound.split("-");
                String soundName = splitted[0];
                String volume = splitted[1];
                if (Double.parseDouble(volume) <= 0.05) {
                    volume = "1";
                }
                if (Double.parseDouble(pitch = splitted[2]) <= 0.5) {
                    pitch = "0.5";
                }
                if (Double.parseDouble(pitch) >= 2.0) {
                    pitch = "2.0";
                }
                if (this.isTarget) {
                    mechanics.add("CustomSound{sound=%s, volume=%s, pitch=%s} @Target{}".formatted(soundName, volume, pitch));
                    continue;
                }
                mechanics.add("CustomSound{sound=%s, volume=%s, pitch=%s}".formatted(soundName, volume, pitch));
            }
            toConfig.set(to, (Object)mechanics);
        }
    }

    private static class FireworkConvert
    implements Converter {
        private final boolean isTarget;

        public FireworkConvert() {
            this.isTarget = false;
        }

        public FireworkConvert(boolean isTarget) {
            this.isTarget = isTarget;
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            String shape = CSPapi.getString((String)(from + "Shape"));
            if (shape == null) {
                return;
            }
            Boolean flicker = CSPapi.getBoolean((String)(from + "Flicker"));
            if (flicker == null) {
                flicker = false;
            }
            List mechanics = toConfig.getStringList(to);
            if (this.isTarget) {
                mechanics.add("Firework{effects=[{shape=%s, color=RED, flicker=%s}]} @Target{}".formatted(shape, flicker));
            } else {
                mechanics.add("Firework{effects=[{shape=%s, color=RED, flicker=%s}]}".formatted(shape, flicker));
            }
            toConfig.set(to, (Object)mechanics);
        }
    }

    private static class ValueConvert
    implements Converter {
        private ValueConvert() {
        }

        @Override
        public void convert(String from, String to, Type type, YamlConfiguration fromConfig, YamlConfiguration toConfig) {
            ArrayList value = type.get(from);
            if (value == null) {
                return;
            }
            if (type == Type.BOOL && !((Boolean)((Object)value)).booleanValue()) {
                return;
            }
            if (type == Type.STR) {
                value = ((String)((Object)value)).replaceAll("#DAMAGED#", "%victim%").replaceAll("#PLAYER#", "%shooter%").replaceAll("#WEAPON#", "%weapon-title%").replaceAll("#KILLER#", "%shooter%").replaceAll("#KILLED#", "%victim%").replaceAll("#C#", "console:");
                value = StringUtil.colorAdventure((String)((String)((Object)value)));
            } else if (type == Type.LIST) {
                List currentList = value;
                ArrayList newList = new ArrayList(currentList.size());
                currentList.forEach(line -> newList.add(StringUtil.colorAdventure((String)((String)line))));
                value = newList;
            }
            toConfig.set(to, (Object)value);
        }
    }

    private static interface Converter {
        public void convert(String var1, String var2, Type var3, YamlConfiguration var4, YamlConfiguration var5);
    }
}

