/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.lib.CrackShotConvert;

import java.io.File;
import java.io.IOException;
import me.deecaad.weaponmechanics.lib.CrackShotConvert.CrackShotConverter;
import me.deecaad.weaponmechanics.lib.CrackShotConvert.CrackShotPlusConverter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class Converter {
    private int convertCounter;
    private final CommandSender sender;
    private CrackShotConverter cs;
    private CrackShotPlusConverter csp;

    public Converter(CommandSender sender) {
        this.sender = sender;
        sender.sendMessage(ChatColor.GREEN + "Starting CrackShot and CrackShotPlus conversion...");
        if (Bukkit.getPluginManager().getPlugin("CrackShot") == null) {
            sender.sendMessage(ChatColor.RED + "Could not find CrackShot!");
            return;
        }
        this.cs = new CrackShotConverter();
        sender.sendMessage(ChatColor.GREEN + "Found CrackShot");
        if (Bukkit.getPluginManager().getPlugin("CrackShotPlus") != null) {
            this.csp = new CrackShotPlusConverter();
            sender.sendMessage(ChatColor.GREEN + "Found CrackShotPlus");
        } else {
            sender.sendMessage(ChatColor.RED + "Could not find CrackShotPlus!");
        }
    }

    public void convertAllFiles(File outputDirectory) {
        File crackShotDirectory = new File("plugins/CrackShot/");
        if (crackShotDirectory == null || crackShotDirectory.listFiles() == null) {
            this.sender.sendMessage(ChatColor.RED + "Could not find CrackShot directory or it was empty!");
            return;
        }
        this.convertAllFiles(crackShotDirectory, outputDirectory);
        if (this.convertCounter <= 0) {
            this.sender.sendMessage(ChatColor.RED + "Could not convert any weapons... check console");
            return;
        }
        this.sender.sendMessage(ChatColor.GREEN + "Successfully converted " + this.convertCounter + " weapons to WeaponMechanics!");
        this.sender.sendMessage(ChatColor.GREEN + "CrackShot" + (this.csp == null ? " " : " and CrackShotPlus ") + "configurations converted to folder " + outputDirectory);
        this.sender.sendMessage(ChatColor.GREEN + "If WeaponMechanics reports there is errors, they're most likely invalid sound conversions, make sure to check console and then restart server.");
    }

    public void convertAllFiles(File directory, File outputDirectory) {
        if (directory == null || directory.listFiles() == null) {
            throw new IllegalArgumentException("The given file MUST be a directory!");
        }
        for (File directoryFile : directory.listFiles()) {
            if (directoryFile.isDirectory()) {
                this.convertAllFiles(directoryFile, new File(outputDirectory, directoryFile.getName() + "/"));
                continue;
            }
            if (!directoryFile.getName().endsWith(".yml") || directoryFile.getName().startsWith("messages") || directoryFile.getName().startsWith("general")) continue;
            this.convertOneFile(directoryFile, outputDirectory);
        }
    }

    public void convertOneFile(File file, File outputDirectory) {
        YamlConfiguration outputConfiguration = new YamlConfiguration();
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        for (String key : configuration.getKeys(false)) {
            try {
                this.cs.convertOneKey(configuration, key, outputConfiguration);
                if (this.csp != null) {
                    this.csp.convertOneKey(configuration, key, outputConfiguration);
                }
                ++this.convertCounter;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String pathInOutput = outputDirectory.getPath() + "/" + file.getName();
        try {
            outputConfiguration.save(new File(pathInOutput));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

