/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.commands.testcommands;

import java.util.ArrayList;
import me.deecaad.core.commands.CommandPermission;
import me.deecaad.core.commands.SubCommand;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.Recoil;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

@CommandPermission(permission="weaponmechanics.commands.test.recoil")
public class RecoilCommand
extends SubCommand {
    public RecoilCommand() {
        super("wm test", "recoil", "Tries recoil with given values", "<push-time> <recover-time> <yaws> <pitches> <fire-rate> <shoot-time>");
    }

    public void execute(final CommandSender sender, String[] args) {
        long rotationTime = Long.parseLong(args[0]);
        long recoverTime = Long.parseLong(args[1]);
        ArrayList<Float> yaws = new ArrayList<Float>();
        for (String yaw : args[2].split(",")) {
            yaws.add(Float.valueOf(Float.parseFloat(yaw)));
        }
        ArrayList<Float> pitches = new ArrayList<Float>();
        for (String pitch : args[3].split(",")) {
            pitches.add(Float.valueOf(Float.parseFloat(pitch)));
        }
        final int fireRate = Integer.parseInt(args[4]);
        if (fireRate < 1 || fireRate > 20) {
            sender.sendMessage(ChatColor.RED + "Only fire rates between 1-20 are allowed for testing.");
            return;
        }
        final int shootTime = Integer.parseInt(args[5]);
        final Recoil recoil = new Recoil(rotationTime, recoverTime, yaws, pitches, null, null);
        final PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper((Player)sender);
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (playerWrapper.isRightClicking()) {
                    recoil.start((Player)sender, true);
                }
                this.ticks += fireRate;
                if (this.ticks > shootTime) {
                    this.cancel();
                }
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, (long)fireRate);
    }
}

