/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.commands.testcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.deecaad.core.commands.CommandPermission;
import me.deecaad.core.commands.SubCommand;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.block.BlockCompatibility;
import me.deecaad.core.utils.EnumUtil;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.weaponmechanics.WeaponMechanics;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

@CommandPermission(permission="weaponmechanics.commands.test.mask")
public class MaskCommand
extends SubCommand {
    public MaskCommand() {
        super("wm test", "mask", "Masks the blocks around you", "<material> <range> <time>");
    }

    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Player only command!");
            return;
        }
        final Player player = (Player)sender;
        Block location = player.getLocation().getBlock();
        Material material = args.length > 0 ? Material.valueOf((String)args[0]) : Material.STONE;
        int range = args.length > 1 ? Integer.parseInt(args[1]) : 3;
        int time = args.length > 2 ? Integer.parseInt(args[2]) * 20 : 200;
        int minX = location.getX() - range;
        int maxX = location.getX() + range;
        int minY = NumberUtil.clamp((int)(location.getY() - range), (int)0, (int)255);
        int maxY = NumberUtil.clamp((int)(location.getY() + range), (int)0, (int)255);
        int minZ = location.getZ() - range;
        int maxZ = location.getZ() + range;
        World world = player.getWorld();
        final HashMap<Chunk, List> blockMap = new HashMap<Chunk, List>();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (!block.getType().isSolid()) continue;
                    if (!block.getChunk().isLoaded()) {
                        WeaponMechanics.debug.debug(new String[]{"Tried to mask block outside of loaded chunks"});
                        continue;
                    }
                    List temp = blockMap.computeIfAbsent(block.getChunk(), k -> new ArrayList());
                    temp.add(block);
                }
            }
        }
        WeaponMechanics.debug.debug(new String[]{"Sending block mask to " + player.getName()});
        final BlockCompatibility blockCompatibility = CompatibilityAPI.getCompatibility().getBlockCompatibility();
        for (List blocks : blockMap.values()) {
            List packet = blockCompatibility.getMultiBlockMaskPacket(blocks, material, (byte)-1);
            CompatibilityAPI.getCompatibility().sendPackets(player, (Object)packet);
        }
        new BukkitRunnable(){

            public void run() {
                for (List blocks : blockMap.values()) {
                    List packet = blockCompatibility.getMultiBlockMaskPacket(blocks, null);
                    CompatibilityAPI.getCompatibility().sendPackets(player, (Object)packet);
                }
            }
        }.runTaskLaterAsynchronously(WeaponMechanics.getPlugin(), (long)time);
    }

    protected List<String> handleCustomTag(String[] args, String tag) {
        return switch (tag) {
            case "<material>" -> new ArrayList(EnumUtil.getOptions(Material.class));
            case "<range>" -> Arrays.asList(tag, "5", "10");
            case "<time>" -> Arrays.asList(tag, "10", "20");
            default -> super.handleCustomTag(args, tag);
        };
    }
}

