/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.commands.testcommands;

import java.util.Arrays;
import java.util.Map;
import me.deecaad.core.commands.CommandPermission;
import me.deecaad.core.commands.SubCommand;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.weapon.explode.BlockDamage;
import me.deecaad.weaponmechanics.weapon.explode.Explosion;
import me.deecaad.weaponmechanics.weapon.explode.Flashbang;
import me.deecaad.weaponmechanics.weapon.explode.exposures.OptimizedExposure;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.RegenerationData;
import me.deecaad.weaponmechanics.weapon.explode.shapes.CuboidExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.DefaultExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ParabolicExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.SphericalExplosion;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

@CommandPermission(permission="weaponmechanics.commands.test.explosion")
public class ExplosionCommand
extends SubCommand {
    public ExplosionCommand() {
        super("wm test", "explosion", "Explode functions for devs", "<subcommand>");
        this.commands.register((SubCommand)new SphereExplosionCommand());
        this.commands.register((SubCommand)new CubeExplosionCommand());
        this.commands.register((SubCommand)new ParabolaExplosionCommand());
        this.commands.register((SubCommand)new DefaultExplosionCommand());
    }

    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return;
        }
        if (args.length > 0) {
            this.commands.execute(args[0], sender, Arrays.copyOfRange(args, 1, args.length));
            return;
        }
        this.sendHelp(sender, args);
    }

    private void explode(final ExplosionShape shape, final Player player, final Location loc) {
        new BukkitRunnable(){

            public void run() {
                RegenerationData regeneration = new RegenerationData(160, 2, 1);
                BlockDamage blockDamage = new BlockDamage(0.0, 1, 1, Material.AIR, BlockDamage.BreakMode.BREAK, Map.of());
                Explosion explosion = new Explosion(shape, new OptimizedExposure(), blockDamage, regeneration, null, 0.9, 1.0, null, null, new Flashbang(10.0, null), null);
                explosion.explode((LivingEntity)player, loc, null);
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), 100L);
    }

    @CommandPermission(permission="weaponmechanics.commands.test.explosion.sphere")
    private class SphereExplosionCommand
    extends SubCommand {
        SphereExplosionCommand() {
            super("wm test explosion", "sphere", "Spherical explosion", "<3,5,16,32>");
        }

        public void execute(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            double radius = args.length > 0 ? Double.parseDouble(args[0]) : 5.0;
            player.sendMessage(ChatColor.GOLD + "Causing a " + ChatColor.GRAY + "sphere" + ChatColor.GOLD + " shaped explosion with a radius of " + ChatColor.GRAY + radius);
            ExplosionCommand.this.explode(new SphericalExplosion(radius), player, player.getLocation());
        }
    }

    @CommandPermission(permission="weaponmechanics.commands.test.explosion.cube")
    private class CubeExplosionCommand
    extends SubCommand {
        CubeExplosionCommand() {
            super("wm test explosion", "cube", "Cubical Explosion Test", "<amount> <amount>");
        }

        public void execute(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            int width = (int)(args.length > 0 ? Double.parseDouble(args[0]) : 5.0);
            int height = (int)(args.length > 1 ? Double.parseDouble(args[1]) : 5.0);
            player.sendMessage(ChatColor.GOLD + "Causing a " + ChatColor.GRAY + "cube" + ChatColor.GOLD + " shaped explosion with a width of " + ChatColor.GRAY + width + ChatColor.GOLD + " and a height of " + ChatColor.GRAY + height);
            ExplosionCommand.this.explode(new CuboidExplosion(width, height), player, player.getLocation());
        }
    }

    @CommandPermission(permission="weaponmechanics.commands.test.explosion.parabola")
    private class ParabolaExplosionCommand
    extends SubCommand {
        ParabolaExplosionCommand() {
            super("wm test explosion", "parabola", "Parabolic Explosion Test", "<angle> <depth>");
        }

        public void execute(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            double angle = args.length > 0 ? Double.parseDouble(args[0]) : 0.5;
            double depth = args.length > 1 ? Double.parseDouble(args[1]) : -3.0;
            player.sendMessage(ChatColor.GOLD + "Causing a " + ChatColor.GRAY + "parabola" + ChatColor.GOLD + " shaped explosion with an angle of " + ChatColor.GRAY + angle + ChatColor.GOLD + " and a depth of " + ChatColor.GRAY + depth);
            ExplosionCommand.this.explode(new ParabolicExplosion(depth, angle), player, player.getLocation());
        }
    }

    @CommandPermission(permission="weaponmechanics.commands.test.explosion.default")
    private class DefaultExplosionCommand
    extends SubCommand {
        DefaultExplosionCommand() {
            super("wm test explosion", "default", "Parabolic Explosion Test", "<3,5,10>");
        }

        public void execute(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            double yield = args.length > 0 ? Double.parseDouble(args[0]) : 5.0;
            player.sendMessage(ChatColor.GOLD + "Causing a " + ChatColor.GRAY + "Minecraft" + ChatColor.GOLD + " shaped explosion with an yield of " + ChatColor.GRAY + yield);
            ExplosionCommand.this.explode(new DefaultExplosion(yield), player, player.getLocation());
        }
    }
}

