/*
 * Decompiled with CFR 0.152.
 */
package me.deecaad.weaponmechanics.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.deecaad.core.MechanicsCore;
import me.deecaad.core.commands.Argument;
import me.deecaad.core.commands.CommandBuilder;
import me.deecaad.core.commands.CommandData;
import me.deecaad.core.commands.CommandExecutor;
import me.deecaad.core.commands.HelpCommandBuilder;
import me.deecaad.core.commands.SuggestionsBuilder;
import me.deecaad.core.commands.Tooltip;
import me.deecaad.core.commands.arguments.BlockPredicateArgumentType;
import me.deecaad.core.commands.arguments.BooleanArgumentType;
import me.deecaad.core.commands.arguments.ColorArgumentType;
import me.deecaad.core.commands.arguments.CommandArgumentType;
import me.deecaad.core.commands.arguments.DoubleArgumentType;
import me.deecaad.core.commands.arguments.EntityArgumentType;
import me.deecaad.core.commands.arguments.EntityListArgumentType;
import me.deecaad.core.commands.arguments.EntityTypeArgumentType;
import me.deecaad.core.commands.arguments.EnumArgumentType;
import me.deecaad.core.commands.arguments.GreedyArgumentType;
import me.deecaad.core.commands.arguments.IntegerArgumentType;
import me.deecaad.core.commands.arguments.ListArgumentType;
import me.deecaad.core.commands.arguments.LocationArgumentType;
import me.deecaad.core.commands.arguments.MapArgumentType;
import me.deecaad.core.commands.arguments.PlayerArgumentType;
import me.deecaad.core.commands.arguments.StringArgumentType;
import me.deecaad.core.commands.arguments.TimeArgumentType;
import me.deecaad.core.compatibility.CompatibilityAPI;
import me.deecaad.core.compatibility.HitBox;
import me.deecaad.core.compatibility.entity.EntityCompatibility;
import me.deecaad.core.compatibility.entity.FakeEntity;
import me.deecaad.core.file.Configuration;
import me.deecaad.core.file.TaskChain;
import me.deecaad.core.utils.EntityTransform;
import me.deecaad.core.utils.LogLevel;
import me.deecaad.core.utils.NumberUtil;
import me.deecaad.core.utils.Quaternion;
import me.deecaad.core.utils.RandomUtil;
import me.deecaad.core.utils.ReflectionUtil;
import me.deecaad.core.utils.StringUtil;
import me.deecaad.core.utils.TableBuilder;
import me.deecaad.core.utils.Transform;
import me.deecaad.core.utils.ray.RayTrace;
import me.deecaad.weaponmechanics.WeaponMechanics;
import me.deecaad.weaponmechanics.WeaponMechanicsAPI;
import me.deecaad.weaponmechanics.lib.CrackShotConvert.Converter;
import me.deecaad.weaponmechanics.listeners.RepairItemListener;
import me.deecaad.weaponmechanics.utils.CustomTag;
import me.deecaad.weaponmechanics.weapon.damage.DamagePoint;
import me.deecaad.weaponmechanics.weapon.explode.BlockDamage;
import me.deecaad.weaponmechanics.weapon.explode.Explosion;
import me.deecaad.weaponmechanics.weapon.explode.Flashbang;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExplosionExposure;
import me.deecaad.weaponmechanics.weapon.explode.exposures.ExposureFactory;
import me.deecaad.weaponmechanics.weapon.explode.regeneration.RegenerationData;
import me.deecaad.weaponmechanics.weapon.explode.shapes.CuboidExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.DefaultExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ExplosionShape;
import me.deecaad.weaponmechanics.weapon.explode.shapes.ParabolicExplosion;
import me.deecaad.weaponmechanics.weapon.explode.shapes.SphericalExplosion;
import me.deecaad.weaponmechanics.weapon.info.InfoHandler;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.Projectile;
import me.deecaad.weaponmechanics.weapon.projectile.weaponprojectile.ProjectileSettings;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoConfig;
import me.deecaad.weaponmechanics.weapon.reload.ammo.AmmoRegistry;
import me.deecaad.weaponmechanics.weapon.shoot.CustomDurability;
import me.deecaad.weaponmechanics.weapon.shoot.recoil.Recoil;
import me.deecaad.weaponmechanics.wrappers.PlayerWrapper;
import me.deecaad.weaponmechanics.wrappers.StatsData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WeaponMechanicsCommand {
    public static String WIKI = "https://cjcrafter.gitbook.io/weaponmechanics/";
    public static char SYM = (char)10146;
    public static Function<CommandData, Tooltip[]> WEAPON_SUGGESTIONS = data -> {
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        return (Tooltip[])info.getSortedWeaponList().stream().map(Tooltip::of).toArray(Tooltip[]::new);
    };
    public static Function<CommandData, Tooltip[]> AMMO_SUGGESTIONS = data -> (Tooltip[])AmmoRegistry.AMMO_REGISTRY.getOptions().stream().map(Tooltip::of).toArray(Tooltip[]::new);
    public static Function<CommandData, Tooltip[]> REPAIR_KIT_SUGGESTIONS = data -> (Tooltip[])RepairItemListener.getInstance().repairKits.keySet().stream().map(Tooltip::of).toArray(Tooltip[]::new);

    public static void build() {
        new CommandBuilder("gundurability").withAliases(new String[]{"weapondurability"}).withPermission("weaponmechanics.commands.gundurability").withDescription("Check the durability of your held weapon").executes(CommandExecutor.player((sender, args) -> {
            String weaponTitle;
            ItemStack item = sender.getInventory().getItemInMainHand();
            String string = weaponTitle = item == null || !item.hasItemMeta() ? null : CustomTag.WEAPON_TITLE.getString(item);
            if (weaponTitle == null) {
                sender.sendMessage(ChatColor.RED + "Held item is not a weapon!");
                return;
            }
            CustomDurability durability = (CustomDurability)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class);
            if (durability == null) {
                sender.sendMessage(ChatColor.RED + weaponTitle + " does not use durability");
                return;
            }
            sender.sendMessage(ChatColor.GREEN + weaponTitle + " has " + CustomTag.DURABILITY.getInteger(item) + "/" + durability.getMaxDurability(item) + " durability remaining.");
        })).register();
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        MapArgumentType weaponDataMap = new MapArgumentType().with("ammo", MapArgumentType.INT((Integer[])new Integer[]{1, 10, 30})).with("firemode", MapArgumentType.INT((Integer[])new Integer[]{0, 1, 2})).with("skipMainhand", MapArgumentType.INT((Integer[])new Integer[]{0, 1})).with("slot", MapArgumentType.INT((Integer[])((Integer[])IntStream.rangeClosed(0, 40).boxed().toArray(Integer[]::new)))).with("durability", MapArgumentType.INT((Integer[])new Integer[]{500, 1000})).with("maxDurability", MapArgumentType.INT((Integer[])new Integer[]{500, 1000})).with("attachments", MapArgumentType.LIST((String[])new String[]{"[]"})).with("skin", MapArgumentType.STRING((String[])new String[]{"default"}));
        CommandBuilder command = new CommandBuilder("wm").withAliases(new String[]{"weaponmechanics"}).withPermission("weaponmechanics.admin").withDescription("WeaponMechanics' main command").withSubcommand(new CommandBuilder("give").withPermission("weaponmechanics.commands.give").withDescription("Gives the target(s) with requested weapon(s)").withArgument(new Argument("target", (CommandArgumentType)new EntityListArgumentType()).withDesc("Who to give the weapon(s) to")).withArgument(new Argument("weapon", (CommandArgumentType)new StringArgumentType().withLiterals(new String[]{"*", "**", "*r"})).withDesc("Which weapon(s) to give").replace(WEAPON_SUGGESTIONS)).withArgument(new Argument("amount", (CommandArgumentType)new IntegerArgumentType(1, 64), (Object)1).withDesc("How many of each weapon to give").append(IntegerArgumentType.ITEM_COUNT)).withArgument(new Argument("data", (CommandArgumentType)weaponDataMap, new HashMap()).withDesc("Extra data for the weapon")).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.give(sender, (List)args[0], (String)args[1], (Integer)args[2], (Map)args[3])))).withSubcommand(new CommandBuilder("get").withPermission("weaponmechanics.commands.get").withDescription("Gives you the requested weapon(s)").withArgument(new Argument("weapon", (CommandArgumentType)new StringArgumentType().withLiterals(new String[]{"*", "**", "*r"})).withDesc("Which weapon(s) to give").replace(WEAPON_SUGGESTIONS)).withArgument(new Argument("amount", (CommandArgumentType)new IntegerArgumentType(1, 64), (Object)1).withDesc("How many of each weapon to give").append(IntegerArgumentType.ITEM_COUNT)).withArgument(new Argument("data", (CommandArgumentType)weaponDataMap, new HashMap()).withDesc("Extra data for the weapon")).executes(CommandExecutor.entity((sender, args) -> WeaponMechanicsCommand.give((CommandSender)sender, Collections.singletonList(sender), (String)args[0], (Integer)args[1], (Map)args[2])))).withSubcommand(new CommandBuilder("ammo").withPermission("weaponmechanics.commands.ammo").withDescription("Gets ammo for held weapon").withArgument(new Argument("amount", (CommandArgumentType)new IntegerArgumentType(), (Object)64).withDesc("How much ammo to give").replace(IntegerArgumentType.ITEM_COUNT)).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.giveAmmo(sender, (Integer)args[0])))).withSubcommand(new CommandBuilder("giveammo").withPermission("weaponmechanics.commands.giveammo").withDescription("Gives ammo of a certain type to a player").withArgument(new Argument("player", (CommandArgumentType)new PlayerArgumentType()).withDesc("Who recieves the ammo")).withArgument(new Argument("ammo", (CommandArgumentType)new StringArgumentType()).withDesc("Which ammo to give").replace(AMMO_SUGGESTIONS)).withArgument(new Argument("magazine", (CommandArgumentType)new BooleanArgumentType(), (Object)false).withDesc("Whether to give the magazine or bullet")).withArgument(new Argument("amount", (CommandArgumentType)new IntegerArgumentType(), (Object)64).withDesc("How much ammo to give").replace(IntegerArgumentType.ITEM_COUNT)).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.giveAmmo(sender, (Player)args[0], (String)args[1], (Boolean)args[2], (Integer)args[3])))).withSubcommand(new CommandBuilder("info").withPermission("weaponmechanics.commands.info").withDescription("Displays information about WeaponMechanics").executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.info(sender)))).withSubcommand(new CommandBuilder("list").withPermission("weaponmechanics.commands.list").withDescription("Displays a table of weapons").withArgument(new Argument("page", (CommandArgumentType)new IntegerArgumentType(1), (Object)1).withDesc("Which page to display").append(SuggestionsBuilder.range((int)1, (int)(1 + info.getSortedWeaponList().size() / 16)))).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.list(sender, (Integer)args[0])))).withSubcommand(new CommandBuilder("wiki").withPermission("weaponmechanics.commands.wiki").withDescription("Gives you wiki links (click!)").executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.wiki(sender)))).withSubcommand(new CommandBuilder("convert").withPermission("weaponmechanics.commands.convert").withDescription("Convert weapons from another plugin").withArgument(new Argument("plugin", (CommandArgumentType)new StringArgumentType().withLiterals(new String[]{"crackshot"}))).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.convert(sender, (String)args[0])))).withSubcommand(new CommandBuilder("reload").withPermission("weaponmechanics.commands.reload").withDescription("Reloads config").executes(CommandExecutor.any((sender, args) -> WeaponMechanicsAPI.getInstance().onReload().thenRunSync(() -> sender.sendMessage(ChatColor.GREEN + "Reloaded configuration"))))).withSubcommand(new CommandBuilder("repair").withPermission("weaponmechanics.commands.repair").withDescription("Repairs the weapons in a target player's inventory").withArgument(new Argument("target", (CommandArgumentType)new EntityListArgumentType(), null).withDesc("Whose inventory to search for weapons")).withArgument(new Argument("mode", (CommandArgumentType)new EnumArgumentType(RepairMode.class), (Object)RepairMode.HAND).withDesc("Search the whole inventory, or just hand")).withArgument(new Argument("repair-max", (CommandArgumentType)new BooleanArgumentType(), (Object)false).withDesc("Repair max-durability as well")).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.repair(sender, (List)args[0], (RepairMode)((Object)((Object)args[1])), (Boolean)args[2])))).withSubcommand(new CommandBuilder("repairkit").withPermission("weaponmechanics.commands.repairkit").withDescription("Gets the specified repair kit").withArgument(new Argument("repair-kit", (CommandArgumentType)new StringArgumentType()).append(REPAIR_KIT_SUGGESTIONS).withDesc("Which repair kit to give")).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.giveRepairKit((CommandSender)sender, sender, (String)args[0]))));
        Argument[] explosionArgs = new Argument[]{new Argument("origin", (CommandArgumentType)new LocationArgumentType()).withDesc("Where the center of explosion is"), new Argument("exposure", (CommandArgumentType)new StringArgumentType(), (Object)"DEFAULT").withDesc("How to calculate entity damage").replace(SuggestionsBuilder.from((Object[])new Object[]{ExposureFactory.getInstance().getOptions()})), new Argument("break", (CommandArgumentType)new BooleanArgumentType(), (Object)true).withDesc("true to have the explosion break blocks"), new Argument("blacklist", (CommandArgumentType)new BlockPredicateArgumentType(), (Object)BlockPredicateArgumentType.FALSE((String)"none")).withDesc("Which blocks should not be broken"), new Argument("regeneration", (CommandArgumentType)new TimeArgumentType(), (Object)200).withDesc("How long after should the blocks regenerate")};
        CommandBuilder test = new CommandBuilder("test").withPermission("weaponmechanics.commands.test").withDescription("Contains useful testing dev commands").withSubcommand(new CommandBuilder("nbt").withPermission("weaponmechanics.commands.test.nbt").withDescription("Shows every NBT tag for the target's held item").withArgument(new Argument("target", (CommandArgumentType)new EntityArgumentType(), null).withDesc("Whose item should we investigate")).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.nbt(sender, (Entity)args[0])))).withSubcommand(new CommandBuilder("explosion").withPermission("weaponmechanics.commands.test.explosion").withRequirements(LivingEntity.class::isInstance).withDescription("Spawns in an explosion that regenerates").withSubcommand(new CommandBuilder("sphere").withArgument(new Argument("radius", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("The radius of the sphere").append(SuggestionsBuilder.from((Object[])new Object[]{5.0, 10.0, 15.0}))).withArguments(explosionArgs).executes(CommandExecutor.entity((entity, args) -> WeaponMechanicsCommand.explode((LivingEntity)entity, new SphericalExplosion((Double)args[0]), (Location)args[1], args[2].toString(), (Boolean)args[3], (Predicate)args[4], (Integer)args[5])))).withSubcommand(new CommandBuilder("cube").withArgument(new Argument("width", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("The horizontal size of the cube").append(SuggestionsBuilder.from((Object[])new Object[]{5.0, 10.0, 15.0}))).withArgument(new Argument("height", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("The vertical size of the cube").append(SuggestionsBuilder.from((Object[])new Object[]{5.0, 10.0, 15.0}))).withArguments(explosionArgs).executes(CommandExecutor.entity((entity, args) -> WeaponMechanicsCommand.explode((LivingEntity)entity, new CuboidExplosion((Double)args[0], (Double)args[1]), (Location)args[2], args[3].toString(), (Boolean)args[4], (Predicate)args[5], (Integer)args[6])))).withSubcommand(new CommandBuilder("parabola").withArgument(new Argument("angle", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("The slope of the parabola").append(SuggestionsBuilder.from((Object[])new Object[]{0.25, 0.5, 0.75, 1.0}))).withArgument(new Argument("depth", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("How far down to start the parabola").append(SuggestionsBuilder.from((Object[])new Object[]{5.0, 10.0, 15.0}))).withArguments(explosionArgs).executes(CommandExecutor.entity((entity, args) -> WeaponMechanicsCommand.explode((LivingEntity)entity, new ParabolicExplosion((Double)args[0], (Double)args[1]), (Location)args[2], args[3].toString(), (Boolean)args[4], (Predicate)args[5], (Integer)args[6])))).withSubcommand(new CommandBuilder("vanilla").withArgument(new Argument("yield", (CommandArgumentType)new DoubleArgumentType(0.1)).withDesc("How big the explosion is").append(SuggestionsBuilder.from((Object[])new Object[]{0, 0.25, 0.5, 0.75, 1.0}))).withArgument(new Argument("rays", (CommandArgumentType)new IntegerArgumentType(1)).withDesc("How accurate to ray-trace, should scale with <yield>").append(SuggestionsBuilder.from((Object[])new Object[]{8, 16, 24, 32}))).withArguments(explosionArgs).executes(CommandExecutor.entity((entity, args) -> WeaponMechanicsCommand.explode((LivingEntity)entity, new DefaultExplosion((Double)args[0], (Integer)args[1]), (Location)args[2], args[3].toString(), (Boolean)args[4], (Predicate)args[5], (Integer)args[6]))))).withSubcommand(new CommandBuilder("fakeentity").withPermission("weaponmechanics.commands.test.fakeentity").withRequirements(LivingEntity.class::isInstance).withDescription("Spawns in a fake entity").withArgument(new Argument("entity", (CommandArgumentType)new EntityTypeArgumentType()).withDesc("Which entity to spawn")).withArgument(new Argument("location", (CommandArgumentType)new LocationArgumentType()).withDesc("Where should the entity be spawned")).withArgument(new Argument("move", (CommandArgumentType)new StringArgumentType()).withDesc("How should the entity act").append(SuggestionsBuilder.from((Object[])new Object[]{"none", "spin", "flash", "x", "y", "z"}))).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)600).withDesc("How long should the entity exist")).withArgument(new Argument("gravity", (CommandArgumentType)new BooleanArgumentType(), (Object)true).withDesc("Should the entity be effected by gravity")).withArgument(new Argument("name", (CommandArgumentType)new GreedyArgumentType(), null).withDesc("What is the entity's custom name")).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.spawn(sender, (Location)args[1], (EntityType)args[0], (String)args[2], (Integer)args[3], (Boolean)args[4], (String)args[5])))).withSubcommand(new CommandBuilder("meta").withPermission("weaponmechanics.commands.test.meta").withArgument(new Argument("targets", (CommandArgumentType)new EntityListArgumentType()).withDesc("Which entities to change")).withArgument(new Argument("flag", (CommandArgumentType)new EnumArgumentType(EntityCompatibility.EntityMeta.class)).withDesc("Which flag to set")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType()).withDesc("How long to show")).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.meta(sender, (List)args[0], (EntityCompatibility.EntityMeta)args[1], (Integer)args[2])))).withSubcommand(new CommandBuilder("firework").withPermission("weaponmechanics.commands.test.firework").withDescription("Spawns in a fake firework").withArgument(new Argument("location", (CommandArgumentType)new LocationArgumentType()).withDesc("Where to spawn the firework")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)60).withDesc("How long before the firework explodes")).withArgument(new Argument("shape", (CommandArgumentType)new EnumArgumentType(FireworkEffect.Type.class), (Object)FireworkEffect.Type.BURST).withDesc("Which shape should the particles be spread")).withArgument(new Argument("color", (CommandArgumentType)new ColorArgumentType(), (Object)Color.RED).withDesc("Color of the particles")).withArgument(new Argument("fade", (CommandArgumentType)new ColorArgumentType(), (Object)Color.RED).withDesc("Fade color of the particles")).withArgument(new Argument("flicker", (CommandArgumentType)new BooleanArgumentType(), (Object)true).withDesc("Should the particles flash")).withArgument(new Argument("trail", (CommandArgumentType)new BooleanArgumentType(), (Object)true).withDesc("Should the firework have a trail")).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.firework((Location)args[0], (Integer)args[1], (FireworkEffect.Type)args[2], (Color)args[3], (Color)args[4], (Boolean)args[5], (Boolean)args[6])))).withSubcommand(new CommandBuilder("hitbox").withPermission("weaponmechanics.commands.test.hitbox").withDescription("Shows the hitboxes of nearby entities").withArgument(new Argument("targets", (CommandArgumentType)new EntityListArgumentType()).withDesc("Whose hitbox to show")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)200).withDesc("How long to show the hitbox")).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.hitbox((CommandSender)sender, (List)args[0], (Integer)args[1])))).withSubcommand(new CommandBuilder("ray").withPermission("weaponmechanics.commands.test.ray").withDescription("Ray traces blocks/entities").withRequirements(LivingEntity.class::isInstance).withArgument(new Argument("highlight-box", (CommandArgumentType)new BooleanArgumentType(), (Object)false).withDesc("false=show point, true=show hitbox")).withArgument(new Argument("size", (CommandArgumentType)new DoubleArgumentType(0.0), (Object)0.1).withDesc("Size of ray-trace")).withArgument(new Argument("distance", (CommandArgumentType)new IntegerArgumentType(1), (Object)10).withDesc("How far to ray-trace")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)200).withDesc("How long to show the particles")).executes(CommandExecutor.entity((sender, args) -> WeaponMechanicsCommand.ray((LivingEntity)sender, (Boolean)args[0], (Double)args[1], (Integer)args[2], (Integer)args[3])))).withSubcommand(new CommandBuilder("recoil").withPermission("weaponmechanics.commands.test.recoil").withDescription("Test screen recoil").withArgument(new Argument("push", (CommandArgumentType)new TimeArgumentType()).withDesc("How long to push screen away")).withArgument(new Argument("recover", (CommandArgumentType)new TimeArgumentType()).withDesc("Time to return to center")).withArgument(new Argument("yaws", (CommandArgumentType)ListArgumentType.doubles((Double[])new Double[]{0.5, 1.0, 1.5})).withDesc("A random yaw to select")).withArgument(new Argument("pitches", (CommandArgumentType)ListArgumentType.doubles((Double[])new Double[]{0.5, 1.0, 1.5})).withDesc("A random pitch to select")).withArgument(new Argument("delay", (CommandArgumentType)new IntegerArgumentType(1, 20), (Object)5).withDesc("Delay between shots")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)100).withDesc("How long to shoot for")).executes(CommandExecutor.player((sender, args) -> WeaponMechanicsCommand.recoil(sender, (Integer)args[0], (Integer)args[1], (List)args[2], (List)args[3], (Integer)args[4], (Integer)args[5])))).withSubcommand(new CommandBuilder("shoot").withPermission("weaponmechanics.commands.test.shoot").withDescription("Test projectile shooting").withRequirements(LivingEntity.class::isInstance).withArgument(new Argument("speed", (CommandArgumentType)new DoubleArgumentType(0.0)).withDesc("How fast to move the projectile")).withArgument(new Argument("gravity", (CommandArgumentType)new DoubleArgumentType(), (Object)0.05).withDesc("The downward acceleration")).withArgument(new Argument("disguise", (CommandArgumentType)new EntityTypeArgumentType(), null).withDesc("Which disguise to use")).executes(CommandExecutor.entity((sender, args) -> WeaponMechanicsCommand.shoot((LivingEntity)sender, (Double)args[0], (Double)args[1], (EntityType)args[2])))).withSubcommand(new CommandBuilder("stats").withPermission("weaponmechanics.commands.test.stats").withDescription("Check player stats").withArgument(new Argument("type", (CommandArgumentType)new StringArgumentType()).withDesc("Which stats to fetch").append(SuggestionsBuilder.from((Object[])new Object[]{"player", "weapon"}))).withArgument(new Argument("target", (CommandArgumentType)new PlayerArgumentType()).withDesc("Whose stats to check")).withArgument(new Argument("weapon", (CommandArgumentType)new StringArgumentType(), null).withDesc("Which weapon stats to check").replace(WEAPON_SUGGESTIONS)).executes(CommandExecutor.any((sender, args) -> WeaponMechanicsCommand.stats(sender, (String)args[0], (Player)args[1], (String)args[2])))).withSubcommand(new CommandBuilder("transform").withPermission("weaponmechanics.commands.test.transform").withDescription("Test the Transform.class").withArgument(new Argument("children", (CommandArgumentType)new IntegerArgumentType(1, 128), (Object)16).withDesc("How many diamonds")).withArgument(new Argument("time", (CommandArgumentType)new TimeArgumentType(), (Object)200).withDesc("How long should the animation last")).withArgument(new Argument("speed", (CommandArgumentType)new DoubleArgumentType(0.0, 720.0), (Object)(Math.PI * 2)).withDesc("How fast to spin")).withArgument(new Argument("radius", (CommandArgumentType)new DoubleArgumentType(0.0, 24.0), (Object)2.0).withDesc("Radius of the circle")).withArgument(new Argument("particles", (CommandArgumentType)new BooleanArgumentType(), (Object)false).withDesc("true to show particle axis")).executes(CommandExecutor.entity((sender, args) -> WeaponMechanicsCommand.transform(sender, (Integer)args[0], (Integer)args[1], Math.toRadians((Double)args[2]), (Double)args[3], (Boolean)args[4]))));
        command.withSubcommand(test);
        command.registerHelp(HelpCommandBuilder.HelpColor.from((ChatColor)ChatColor.GOLD, (ChatColor)ChatColor.GRAY, (char)SYM));
        command.register();
    }

    public static void stats(CommandSender sender, String type, Player target, String weapon) {
        if (target == null) {
            sender.sendMessage(ChatColor.RED + "No target found");
            return;
        }
        PlayerWrapper wrapper = WeaponMechanics.getPlayerWrapper(target);
        StatsData statsData = wrapper.getStatsData();
        if (statsData == null) {
            sender.sendMessage(ChatColor.RED + "Stats are disabled or not yet synced...");
            return;
        }
        if ("player".equals(type)) {
            List<String> playerData = statsData.getPlayerData();
            if (playerData == null) {
                sender.sendMessage(ChatColor.RED + "No player stats found from " + target.getName());
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "Showing stats of " + target.getName() + ":");
            for (String msg : playerData) {
                sender.sendMessage(msg);
            }
            return;
        }
        if (weapon == null) {
            sender.sendMessage(ChatColor.RED + "Weapon title has to be defined when trying to fetch weapon stats");
            return;
        }
        List<String> weaponData = statsData.getWeaponData(weapon);
        if (weaponData == null) {
            sender.sendMessage(ChatColor.RED + "No weapon stats found from " + weapon + " of player " + target.getName());
            return;
        }
        sender.sendMessage(ChatColor.GOLD + "Showing " + target.getName() + " stats of " + weapon + ":");
        for (String msg : weaponData) {
            sender.sendMessage(msg);
        }
    }

    public static void give(CommandSender sender, List<Entity> targets, String weaponTitle, int amount, Map<String, Object> data) {
        HoverEventSource targetHover;
        String weaponInfo;
        String targetInfo;
        if (targets.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "No entities were found");
            return;
        }
        data.put("sender", sender);
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        ArrayList<LivingEntity> entitiesGiven = new ArrayList<LivingEntity>();
        HashSet<String> weaponsGiven = new HashSet<String>();
        if ("*r".equalsIgnoreCase(weaponTitle)) {
            weaponTitle = (String)RandomUtil.element(info.getSortedWeaponList());
        }
        for (Entity loop : targets) {
            Player player;
            if (!loop.getType().isAlive()) continue;
            LivingEntity entity = (LivingEntity)loop;
            boolean isPlayer = entity instanceof Player;
            Player player2 = player = isPlayer ? (Player)entity : null;
            if ("*".equalsIgnoreCase(weaponTitle) || "**".equalsIgnoreCase(weaponTitle)) {
                if (!isPlayer) continue;
                entitiesGiven.add(entity);
                for (String title : info.getSortedWeaponList()) {
                    if (!"**".equalsIgnoreCase(weaponTitle) && player.getInventory().firstEmpty() == -1) continue;
                    info.giveOrDropWeapon(title, (LivingEntity)player, amount, data);
                    weaponsGiven.add(title);
                }
                continue;
            }
            if (!info.giveOrDropWeapon(weaponTitle = info.getWeaponTitle(weaponTitle), entity, amount, data)) continue;
            entitiesGiven.add(entity);
            weaponsGiven.add(weaponTitle);
        }
        if (entitiesGiven.isEmpty() || weaponsGiven.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "No entities were given any weapons...");
            return;
        }
        String string = targetInfo = entitiesGiven.size() == 1 ? ((Entity)entitiesGiven.get(0)).getName() : String.valueOf(entitiesGiven.size());
        String string2 = weaponsGiven.size() == 1 ? amount + " " + (String)weaponsGiven.stream().findAny().get() + (amount > 1 ? "s" : "") : (weaponInfo = weaponsGiven.size() + " weapons");
        if (entitiesGiven.size() == 1 && entitiesGiven.get(0) instanceof HoverEventSource) {
            targetHover = (HoverEventSource)entitiesGiven.get(0);
        } else if (entitiesGiven.isEmpty()) {
            targetHover = null;
        } else {
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append((Component)Component.text((String)((Entity)entitiesGiven.get(0)).getName()));
            for (int i = 1; i < entitiesGiven.size(); ++i) {
                ((TextComponent.Builder)builder.append((Component)Component.text((String)", "))).append((Component)Component.text((String)((Entity)entitiesGiven.get(i)).getName()));
            }
            targetHover = builder.build();
        }
        Style style = Style.style((TextColor)NamedTextColor.GREEN);
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Gave ", (Style)style))).append(((TextComponent.Builder)Component.text().content(targetInfo).style(style)).hoverEvent(targetHover))).append((Component)Component.text((String)" ", (Style)style))).append(Component.text().content(weaponInfo).style(style));
        MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((ComponentLike)builder);
    }

    public static void giveAmmo(Player sender, int amount) {
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        String title = info.getWeaponTitle(sender.getInventory().getItemInMainHand(), false);
        if (title == null) {
            sender.sendMessage(ChatColor.RED + "Not holding gun");
            return;
        }
        AmmoConfig ammo = (AmmoConfig)WeaponMechanics.getConfigurations().getObject(title + ".Reload.Ammo", AmmoConfig.class);
        if (ammo == null) {
            sender.sendMessage(ChatColor.RED + title + " does not use ammo");
            return;
        }
        ammo.giveAmmo(sender.getInventory().getItemInMainHand(), WeaponMechanics.getPlayerWrapper(sender), amount, 64);
        sender.sendMessage(ChatColor.GREEN + "Sent ammo");
    }

    public static void giveAmmo(CommandSender sender, Player player, String ammoName, boolean magazine, int amount) {
        ItemStack item;
        try {
            item = WeaponMechanicsAPI.generateAmmo(ammoName, magazine);
        }
        catch (Throwable ex) {
            sender.sendMessage(ChatColor.RED + ex.getMessage());
            return;
        }
        if (item == null) {
            sender.sendMessage(ChatColor.RED + "No such ammo exists");
            return;
        }
        item.setAmount(amount);
        HashMap overflow = player.getInventory().addItem(new ItemStack[]{item});
        if (overflow == null || !overflow.isEmpty()) {
            sender.sendMessage(ChatColor.RED + player.getName() + "'s inventory was full");
        } else {
            sender.sendMessage(ChatColor.GREEN + player.getName() + " recieved " + amount + " " + ammoName);
        }
    }

    public static void repair(CommandSender sender, List<Entity> targets, RepairMode mode, boolean repairFully) {
        if (targets == null) {
            if (sender instanceof Entity) {
                Entity entity = (Entity)sender;
                targets = List.of(entity);
            } else {
                sender.sendMessage(ChatColor.RED + "You must specify a target");
                return;
            }
        }
        int repairedWeapons = 0;
        int repairedEntities = 0;
        for (Entity entity : targets) {
            CustomDurability customDurability;
            String weaponTitle;
            if (entity instanceof InventoryHolder) {
                ItemStack[] items;
                ItemStack[] itemStackArray;
                ItemStack mainHand;
                InventoryHolder holder = (InventoryHolder)entity;
                Inventory inventory = holder.getInventory();
                boolean repairedOne = false;
                if (inventory instanceof PlayerInventory) {
                    PlayerInventory playerInventory = (PlayerInventory)inventory;
                    v0 = playerInventory.getItemInMainHand();
                } else {
                    v0 = mainHand = null;
                }
                if (mode == RepairMode.INVENTORY) {
                    itemStackArray = inventory.getContents();
                } else {
                    ItemStack[] itemStackArray2 = new ItemStack[1];
                    itemStackArray = itemStackArray2;
                    itemStackArray2[0] = mainHand;
                }
                for (ItemStack item : items = itemStackArray) {
                    CustomDurability customDurability2;
                    if (item == null || !item.hasItemMeta()) continue;
                    String title = WeaponMechanicsAPI.getWeaponTitle(item);
                    if (title == null) {
                        title = CustomTag.BROKEN_WEAPON.getString(item);
                    }
                    if ((customDurability2 = (CustomDurability)WeaponMechanics.getConfigurations().getObject(title + ".Shoot.Custom_Durability", CustomDurability.class)) == null || !customDurability2.repair(item, repairFully)) continue;
                    ++repairedWeapons;
                    if (repairedOne) continue;
                    ++repairedEntities;
                    repairedOne = true;
                }
                continue;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            EntityEquipment equipment = living.getEquipment();
            ItemStack item = equipment == null ? null : equipment.getItemInMainHand();
            String string = weaponTitle = item == null ? null : WeaponMechanicsAPI.getWeaponTitle(item);
            if (weaponTitle == null && item != null && item.hasItemMeta()) {
                weaponTitle = CustomTag.BROKEN_WEAPON.getString(item);
            }
            if (weaponTitle == null || (customDurability = (CustomDurability)WeaponMechanics.getConfigurations().getObject(weaponTitle + ".Shoot.Custom_Durability", CustomDurability.class)) == null || !customDurability.repair(item, repairFully)) continue;
            ++repairedWeapons;
            ++repairedEntities;
        }
        sender.sendMessage(ChatColor.GREEN + "Repaired " + repairedWeapons + " weapons in " + repairedEntities + " different inventories.");
    }

    public static void giveRepairKit(CommandSender sender, Player receiver, String repairKit) {
        Map<String, RepairItemListener.RepairKit> options = RepairItemListener.getInstance().repairKits;
        repairKit = StringUtil.didYouMean((String)repairKit, options.keySet());
        ItemStack item = options.get(repairKit).getItem().clone();
        receiver.getInventory().addItem(new ItemStack[]{item});
        sender.sendMessage(ChatColor.GREEN + "Gave 1 " + repairKit);
    }

    public static void info(CommandSender sender) {
        PluginDescriptionFile desc = WeaponMechanics.getPlugin().getDescription();
        sender.sendMessage(ChatColor.GRAY + ChatColor.GOLD + ChatColor.BOLD + "Weapon" + ChatColor.GRAY + ChatColor.BOLD + "Mechanics" + ChatColor.GRAY + ", v" + ChatColor.ITALIC + desc.getVersion());
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " Authors: " + ChatColor.GRAY + String.join((CharSequence)", ", desc.getAuthors()));
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " Command:" + ChatColor.GRAY + " /weaponmechanics");
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " Server: " + ChatColor.GRAY + Bukkit.getName() + " " + Bukkit.getVersion());
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " MechanicsCore: " + ChatColor.GRAY + MechanicsCore.getPlugin().getDescription().getVersion());
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " Java: " + ChatColor.GRAY + System.getProperty("java.version"));
        LinkedHashSet<String> softDepends = new LinkedHashSet<String>(desc.getSoftDepend());
        softDepends.addAll(MechanicsCore.getPlugin().getDescription().getSoftDepend());
        softDepends.remove("MechanicsCore");
        softDepends.removeIf(name -> Bukkit.getPluginManager().getPlugin(name) == null);
        if (softDepends.isEmpty()) {
            softDepends.add("No supported plugins installed");
        }
        sender.sendMessage("  " + ChatColor.GRAY + SYM + ChatColor.GOLD + " Supported plugins: " + ChatColor.GRAY + String.join((CharSequence)", ", softDepends));
    }

    public static void list(CommandSender sender, int requestedPage) {
        InfoHandler info = WeaponMechanics.getWeaponHandler().getInfoHandler();
        List<String> weapons = info.getSortedWeaponList();
        Style gold = Style.style((TextColor)NamedTextColor.GOLD);
        Style gray = Style.style((TextColor)NamedTextColor.GRAY);
        TextComponent table = new TableBuilder().withConstraints(TableBuilder.DEFAULT_CONSTRAINTS.setColumns(3).setPixels(310)).withElementChar('-').withElementCharStyle(gold).withFillChar('=').withFillCharStyle(Style.style((TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH})).withHeader("Weapons [Page " + requestedPage + "/" + ((weapons.size() - 1) / 24 + 1) + "]").withHeaderStyle(gold).withElementStyle(gray).withLeft((TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00ab").style(gold)).clickEvent(ClickEvent.runCommand((String)("/wm list " + (requestedPage - 1))))).hoverEvent((HoverEventSource)Component.text((String)("Click to go to page " + (requestedPage - 1)), (Style)gray))).build()).withRight((TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00bb").style(gold)).clickEvent(ClickEvent.runCommand((String)("/wm list " + (requestedPage + 1))))).hoverEvent((HoverEventSource)Component.text((String)("Click to go to page " + (requestedPage + 1)), (Style)gray))).build()).withAttemptSinglePixelFix().withSupplier(i -> {
            int index = i + (requestedPage - 1) * 3 * 8;
            if (weapons.size() <= index) {
                return Component.empty();
            }
            String title = (String)weapons.get(index);
            ItemStack item = info.generateWeapon(title, 1);
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(title.toUpperCase(Locale.ROOT)).clickEvent(ClickEvent.runCommand((String)("/wm get " + title)))).hoverEvent((HoverEventSource)LegacyComponentSerializer.legacySection().deserialize(item.getItemMeta().getDisplayName()))).build();
        }).build();
        MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)table);
    }

    public static void wiki(CommandSender sender) {
        List<String> pages = Arrays.asList("Info", "Shoot", "Scope", "Reload", "Skin", "Projectile", "Explosion", "Damage", "Firearm_Action", "Melee");
        Style gold = Style.style((TextColor)NamedTextColor.GOLD);
        Style gray = Style.style((TextColor)NamedTextColor.GRAY);
        TextComponent table = new TableBuilder().withConstraints(TableBuilder.DEFAULT_CONSTRAINTS.setPixels(300)).withElementChar('-').withElementCharStyle(gold).withElementStyle(gray).withAttemptSinglePixelFix().withSupplier(i -> i >= pages.size() ? Component.empty() : (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(((String)pages.get(i)).toUpperCase(Locale.ROOT)).clickEvent(ClickEvent.openUrl((String)(WIKI + "/weapon-modules/" + ((String)pages.get(i)).toLowerCase(Locale.ROOT))))).hoverEvent((HoverEventSource)Component.text((String)"Click to go to the wiki", (Style)gray))).build()).build();
        MechanicsCore.getPlugin().adventure.sender(sender).sendMessage((Component)table);
    }

    public static void convert(CommandSender sender, String plugin) {
        if (plugin.equalsIgnoreCase("crackshot")) {
            sender.sendMessage(ChatColor.GREEN + "Converting config...");
            WeaponMechanics pl = WeaponMechanicsAPI.getInstance();
            File outputPath = new File(pl.getDataFolder().getPath() + "/weapons/crackshotconvert/");
            new TaskChain(WeaponMechanics.getPlugin()).thenRunSync(() -> sender.sendMessage(ChatColor.GREEN + "Starting CrackShot conversion")).thenRunAsync(() -> new Converter(sender).convertAllFiles(outputPath)).thenRunSync(() -> sender.sendMessage(ChatColor.GREEN + "Output converted files to " + outputPath));
            return;
        }
        sender.sendMessage(ChatColor.RED + "Conversion currently only supports CrackShot!");
    }

    public static void nbt(CommandSender sender, Entity target) {
        if (target == null) {
            if (sender instanceof LivingEntity) {
                target = (LivingEntity)sender;
            } else {
                sender.sendMessage(ChatColor.RED + "NBT is an Entity only command!");
                return;
            }
        }
        if (!(target instanceof LivingEntity)) {
            sender.sendMessage(ChatColor.RED + "Target must be a creature, player, or armor stand! Got: " + target.getType());
            return;
        }
        LivingEntity entity = (LivingEntity)target;
        if (entity.getEquipment() == null) {
            sender.sendMessage(ChatColor.RED + entity.getName() + " did not have any equipment");
            return;
        }
        ItemStack item = entity.getEquipment().getItemInMainHand();
        if (!item.hasItemMeta()) {
            sender.sendMessage(ChatColor.RED + entity.getName() + "'s " + item.getType() + " did not have any NBT data.");
            return;
        }
        String tags = CompatibilityAPI.getNBTCompatibility().getNBTDebug(item);
        WeaponMechanics.debug.info(new String[]{tags});
        sender.sendMessage(StringUtil.colorBukkit((String)tags));
    }

    public static void explode(final LivingEntity cause, final ExplosionShape shape, final Location origin, final String exposureString, boolean isBreakBlocks, final Predicate<Block> blackList, final int regen) {
        cause.sendMessage(ChatColor.GREEN + "Spawning explosion in 5 seconds");
        new BukkitRunnable(){

            public void run() {
                RegenerationData regeneration = new RegenerationData(regen, Math.max(1, (int)shape.getArea() / 100), 1);
                BlockDamage blockDamage = new BlockDamage(0.0, 1, 1, Material.AIR, BlockDamage.BreakMode.BREAK, Map.of()){

                    @Override
                    public BlockDamage.BreakMode getBreakMode(Block block) {
                        return blackList.test(block) ? BlockDamage.BreakMode.BREAK : BlockDamage.BreakMode.CRACK;
                    }
                };
                ExplosionExposure exposure = (ExplosionExposure)ReflectionUtil.newInstance(ExposureFactory.getInstance().getMap().get(exposureString));
                Explosion explosion = new Explosion(shape, exposure, blockDamage, regeneration, null, 0.0, 1.0, null, null, new Flashbang(10.0, null), null);
                explosion.explode(cause, origin, null);
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), 100L);
    }

    public static void spawn(Player player, Location location, EntityType type, final String moveType, final int time, boolean gravity, String name) {
        final FakeEntity entity = CompatibilityAPI.getEntityCompatibility().generateFakeEntity(location, type, (Object)(type == EntityType.DROPPED_ITEM ? new ItemStack(Material.STONE_AXE) : null));
        entity.setGravity(gravity);
        entity.setDisplay(name);
        entity.show(player);
        entity.setMotion(0.0, 0.0, 0.0);
        new BukkitRunnable(){
            int ticksAlive = 0;
            boolean flash = true;

            public void run() {
                if (this.ticksAlive++ >= time) {
                    entity.remove();
                    this.cancel();
                    return;
                }
                switch (moveType) {
                    case "spin": {
                        entity.setRotation(entity.getYaw() + 5.0f, entity.getYaw() / 2.0f);
                        break;
                    }
                    case "flash": {
                        if (this.ticksAlive % 10 != 0) break;
                        this.flash = !this.flash;
                        entity.setInvisible(!this.flash);
                        entity.setGlowing(this.flash);
                        entity.updateMeta();
                        break;
                    }
                    case "y": {
                        entity.setPosition(entity.getX(), entity.getY() + 0.1, entity.getZ());
                        break;
                    }
                    case "x": {
                        entity.setPosition(entity.getX() + 0.1, entity.getY(), entity.getZ());
                        break;
                    }
                    case "z": {
                        entity.setPosition(entity.getX(), entity.getY(), entity.getZ() + 0.1);
                    }
                }
            }
        }.runTaskTimerAsynchronously(WeaponMechanics.getPlugin(), 0L, 0L);
    }

    public static void meta(final Player sender, final List<Entity> targets, EntityCompatibility.EntityMeta flag, int ticks) {
        final EntityCompatibility compatibility = CompatibilityAPI.getEntityCompatibility();
        sender.sendMessage(ChatColor.GREEN + "Making " + targets.size() + " targets " + flag);
        for (Entity entity : targets) {
            Object packet = compatibility.generateMetaPacket(entity);
            compatibility.modifyMetaPacket(packet, flag, true);
            CompatibilityAPI.getCompatibility().sendPackets(sender, packet);
        }
        new BukkitRunnable(){

            public void run() {
                sender.sendMessage(ChatColor.GREEN + "Resetting META...");
                for (Entity entity : targets) {
                    Object packet = compatibility.generateMetaPacket(entity);
                    CompatibilityAPI.getCompatibility().sendPackets(sender, packet);
                }
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), (long)ticks);
    }

    public static void hitbox(final CommandSender sender, final List<Entity> targets, final int ticks) {
        sender.sendMessage(ChatColor.GREEN + "Showing hitboxes of " + targets.size() + " entities for " + ticks + " ticks.");
        final Configuration basicConfiguration = WeaponMechanics.getBasicConfigurations();
        new BukkitRunnable(){
            int ticksPassed = 0;

            public void run() {
                for (Entity entity : targets) {
                    if (!(entity instanceof LivingEntity) || entity.equals(sender)) continue;
                    EntityType type = entity.getType();
                    double head = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.HEAD.name(), -1.0);
                    double body = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.BODY.name(), -1.0);
                    double legs = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.LEGS.name(), -1.0);
                    double feet = basicConfiguration.getDouble("Entity_Hitboxes." + type.name() + "." + DamagePoint.FEET.name(), -1.0);
                    if (head == -1.0 || body == -1.0 || legs == -1.0 || feet == -1.0) {
                        WeaponMechanics.debug.log(LogLevel.ERROR, new String[]{"Entity type " + type.name() + " is missing some of its damage point values, please add it", "Located at file /WeaponMechanics/config.yml in Entity_Hitboxes." + type.name() + " in configurations", "Its missing one of these: HEAD, BODY, LEGS or FEET"});
                        continue;
                    }
                    double sumOf = head + body + legs + feet;
                    if (!NumberUtil.approximately((double)sumOf, (double)1.0)) {
                        WeaponMechanics.debug.log(LogLevel.ERROR, new String[]{"Entity type " + type.name() + " hit box values sum doesn't match 1.0", "Located at file /WeaponMechanics/config.yml in Entity_Hitboxes." + type.name() + " in configurations", "Now the total sum was " + sumOf + ", please make it 1.0."});
                        continue;
                    }
                    HitBox box = CompatibilityAPI.getEntityCompatibility().getHitBox(entity);
                    if (box == null) continue;
                    double max = box.getMaxY();
                    double height = box.getHeight();
                    double headY = max - height * head;
                    double bodyY = max - height * (head + body);
                    double legsY = max - height * (head + body + legs);
                    double feetY = max - height * (head + body + legs + feet);
                    for (double x = box.getMinX(); x <= box.getMaxX(); x += 0.25) {
                        for (double z = box.getMinZ(); z <= box.getMaxZ(); z += 0.25) {
                            if (head > 0.0) {
                                entity.getWorld().spawnParticle(Particle.REDSTONE, x, headY, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(Color.RED, 1.0f), true);
                            }
                            if (body > 0.0) {
                                entity.getWorld().spawnParticle(Particle.REDSTONE, x, bodyY, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f), true);
                            }
                            if (legs > 0.0) {
                                entity.getWorld().spawnParticle(Particle.REDSTONE, x, legsY, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(Color.YELLOW, 1.0f), true);
                            }
                            if (!(feet > 0.0)) continue;
                            entity.getWorld().spawnParticle(Particle.REDSTONE, x, feetY, z, 1, 0.0, 0.0, 0.0, 1.0E-4, (Object)new Particle.DustOptions(Color.GREEN, 1.0f), true);
                        }
                    }
                }
                this.ticksPassed += 5;
                if (this.ticksPassed >= ticks) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(WeaponMechanics.getPlugin(), 0L, 5L);
    }

    public static void firework(Location location, int time, FireworkEffect.Type type, Color color, Color fade, boolean flicker, boolean trail) {
        ItemStack itemStack = new ItemStack(Material.FIREWORK_ROCKET);
        FireworkMeta meta = (FireworkMeta)itemStack.getItemMeta();
        FireworkEffect effect = FireworkEffect.builder().with(type).withColor(color).withFade(fade).flicker(flicker).trail(trail).build();
        meta.addEffect(effect);
        itemStack.setItemMeta((ItemMeta)meta);
        Random random = new Random();
        final FakeEntity fakeEntity = CompatibilityAPI.getEntityCompatibility().generateFakeEntity(location, EntityType.FIREWORK, (Object)itemStack);
        fakeEntity.setMotion(random.nextGaussian() * 0.001, 0.3, random.nextGaussian() * 0.001);
        fakeEntity.show();
        if (time == 0) {
            fakeEntity.playEffect(EntityEffect.FIREWORK_EXPLODE);
            fakeEntity.remove();
            return;
        }
        new BukkitRunnable(){

            public void run() {
                fakeEntity.playEffect(EntityEffect.FIREWORK_EXPLODE);
                fakeEntity.remove();
            }
        }.runTaskLater(WeaponMechanics.getPlugin(), (long)time);
    }

    public static void ray(final LivingEntity sender, boolean box, double size, final int distance, final int ticks) {
        sender.sendMessage(ChatColor.GREEN + "Showing hitboxes in distance " + distance + " for " + NumberUtil.toTime((int)(ticks / 20)));
        final RayTrace rayTrace = new RayTrace().withEntityFilter(entity -> entity.getEntityId() == sender.getEntityId()).withRaySize(size);
        if (box) {
            rayTrace.withOutlineHitBox((Entity)sender);
        } else {
            rayTrace.withOutlineHitPosition((Entity)sender);
        }
        new BukkitRunnable(){
            int ticker = 0;

            public void run() {
                Location location = sender.getEyeLocation();
                Vector direction = location.getDirection();
                rayTrace.cast(sender.getWorld(), location.toVector(), direction, (double)distance);
                if (++this.ticker >= ticks) {
                    this.cancel();
                }
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, 0L);
    }

    public static void recoil(final Player player, int push, int recover, List<Double> yaws, List<Double> pitches, final int rate, final int time) {
        final Recoil recoil = new Recoil(push, recover, yaws.stream().map(Double::floatValue).collect(Collectors.toList()), pitches.stream().map(Double::floatValue).collect(Collectors.toList()), null, null);
        final PlayerWrapper playerWrapper = WeaponMechanics.getPlayerWrapper(player);
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (playerWrapper.isRightClicking()) {
                    recoil.start(player, true);
                }
                this.ticks += rate;
                if (this.ticks > time) {
                    this.cancel();
                }
            }
        }.runTaskTimer(WeaponMechanics.getPlugin(), 0L, (long)rate);
    }

    public static void shoot(LivingEntity sender, double speed, double gravity, EntityType entity) {
        ProjectileSettings projectileSettings = new ProjectileSettings(entity, null, gravity, false, -1.0, false, -1.0, 0.99, 0.96, 0.98, false, 600, -1.0, 0.1);
        Projectile projectile = new Projectile(projectileSettings, null, null, null, null);
        projectile.shoot(sender, sender.getEyeLocation(), sender.getLocation().getDirection().multiply(speed), null, null, null);
    }

    public static void transform(final Entity sender, final int children, final int time, final double speed, double radius, final boolean particles) {
        EntityCompatibility compatibility = CompatibilityAPI.getEntityCompatibility();
        final Transform parent = new Transform();
        parent.setParent((Transform)new EntityTransform(sender));
        final ArrayList<FakeEntity> entities = new ArrayList<FakeEntity>(children * children / 2);
        for (int i = 0; i < children; ++i) {
            Transform transform = new Transform(parent);
            double angle = (double)i * (Math.PI * 2) / (double)children;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            transform.setLocalPosition(new Vector(x, 0.0, z));
            transform.setForward(transform.getLocalPosition().normalize().crossProduct(new Vector(0, 1, 0)).normalize());
            for (int j = 0; j < children / 2; ++j) {
                angle = (double)j / ((double)children / 2.0) * (Math.PI * 2);
                x = Math.cos(angle) * radius / 3.0;
                z = Math.sin(angle) * radius / 3.0;
                Transform local = new Transform(transform);
                local.setLocalPosition(new Vector(x, 0.0, z));
                FakeEntity entity = compatibility.generateFakeEntity(transform.getPosition().toLocation(sender.getWorld()), new ItemStack(Material.DIAMOND));
                entity.setGravity(false);
                entity.show();
                entities.add(entity);
            }
        }
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (particles) {
                    parent.getParent().debug(sender.getWorld());
                }
                double deltaTime = 0.05;
                double rotationSpeed = (double)this.ticks * speed / (double)time * deltaTime;
                Quaternion spin = Quaternion.angleAxis((double)rotationSpeed, (Vector)parent.getUp());
                parent.applyRotation(spin);
                for (int i = 0; i < children; ++i) {
                    Transform transform = parent.getChild(i);
                    if (particles) {
                        transform.debug(sender.getWorld());
                    }
                    for (int j = 0; j < children / 2; ++j) {
                        Transform local = transform.getChild(j);
                        if (particles) {
                            local.debug(sender.getWorld());
                        }
                        Vector position = local.getPosition();
                        Vector rotation = local.getRotation().getEulerAngles();
                        FakeEntity entity = (FakeEntity)entities.get(i * children / 2 + j);
                        entity.setPosition(position, (float)rotation.getX(), (float)rotation.getY());
                    }
                }
                if (this.ticks++ >= time) {
                    entities.forEach(FakeEntity::remove);
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(WeaponMechanics.getPlugin(), 0L, 0L);
    }

    private static enum RepairMode {
        HAND,
        INVENTORY;

    }
}

